/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.objcinterop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NativeStandardInteropNames;
import org.jetbrains.kotlin.native.interop.ObjCMethodInfo;
import org.jetbrains.kotlin.resolve.annotations.UtilsKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.utils.CollectionUtilKt;

public final class ObjCInteropKt {
    @NotNull
    private static final FqName interopPackageName = NativeStandardInteropNames.INSTANCE.getCInteropPackage();
    @NotNull
    private static final FqName objCObjectFqName = NativeStandardInteropNames.INSTANCE.getObjCObjectClassId().asSingleFqName();
    @NotNull
    private static final FqName objCClassFqName;
    @NotNull
    private static final FqName objCProtocolFqName;
    @NotNull
    private static final FqName externalObjCClassFqName;
    @NotNull
    private static final FqName objCDirectFqName;
    @NotNull
    private static final FqName objCMethodFqName;
    @NotNull
    private static final FqName objCConstructorFqName;
    @NotNull
    private static final FqName objCFactoryFqName;

    /*
     * WARNING - void declaration
     */
    private static final ObjCMethodInfo decodeObjCMethodAnnotation(FunctionDescriptor $this$decodeObjCMethodAnnotation) {
        ObjCMethodInfo objCMethodInfo;
        boolean bl = $this$decodeObjCMethodAnnotation.getKind().isReal();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AnnotationDescriptor annotationDescriptor = $this$decodeObjCMethodAnnotation.getAnnotations().findAnnotation(objCMethodFqName);
        if (annotationDescriptor != null) {
            Boolean bl2;
            ConstantValue constantValue$iv;
            void $this$filterTo$iv$iv$iv$iv;
            void $this$getArgumentValueOrNull$iv;
            AnnotationDescriptor it = annotationDescriptor;
            boolean bl3 = false;
            AnnotationDescriptor annotationDescriptor2 = it;
            String string3 = "isStret";
            String string4 = UtilsKt.getAnnotationStringValue(it, "encoding");
            String string5 = UtilsKt.getAnnotationStringValue(it, "selector");
            boolean $i$f$getArgumentValueOrNull = false;
            Iterable $this$atMostOne$iv$iv = $this$getArgumentValueOrNull$iv.getAllValueArguments().entrySet();
            boolean $i$f$atMostOne = false;
            Iterable $this$filter$iv$iv$iv = $this$atMostOne$iv$iv;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv$iv$iv;
            Collection destination$iv$iv$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv$iv$iv : $this$filterTo$iv$iv$iv$iv) {
                void name$iv;
                Map.Entry it$iv = (Map.Entry)element$iv$iv$iv$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual(((Name)it$iv.getKey()).asString(), name$iv)) continue;
                destination$iv$iv$iv$iv.add(element$iv$iv$iv$iv);
            }
            Map.Entry entry = (Map.Entry)CollectionUtilKt.atMostOne((List)destination$iv$iv$iv$iv);
            ConstantValue constantValue = constantValue$iv = entry != null ? (ConstantValue)entry.getValue() : null;
            Boolean bl5 = bl2 = (Boolean)(constantValue != null ? constantValue.getValue() : null);
            AnnotationDescriptor annotationDescriptor3 = $this$decodeObjCMethodAnnotation.getAnnotations().findAnnotation(objCDirectFqName);
            String string6 = annotationDescriptor3 != null ? UtilsKt.getAnnotationStringValue(annotationDescriptor3, "symbol") : null;
            boolean bl6 = bl5 != null ? bl5 : false;
            String string7 = string4;
            String string8 = string5;
            objCMethodInfo = new ObjCMethodInfo(string8, string7, bl6, string6);
        } else {
            objCMethodInfo = null;
        }
        ObjCMethodInfo methodInfo = objCMethodInfo;
        return methodInfo;
    }

    private static final ObjCMethodInfo getObjCMethodInfo(FunctionDescriptor $this$getObjCMethodInfo, boolean onlyExternal) {
        ObjCMethodInfo objCMethodInfo;
        block4: {
            if ($this$getObjCMethodInfo.getKind().isReal()) {
                ObjCMethodInfo objCMethodInfo2 = ObjCInteropKt.decodeObjCMethodAnnotation($this$getObjCMethodInfo);
                if (objCMethodInfo2 != null) {
                    ObjCMethodInfo it = objCMethodInfo2;
                    boolean bl = false;
                    return it;
                }
                if (onlyExternal) {
                    return null;
                }
            }
            Collection<? extends FunctionDescriptor> collection = $this$getObjCMethodInfo.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            for (FunctionDescriptor it : (Iterable)collection) {
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                ObjCMethodInfo objCMethodInfo3 = ObjCInteropKt.getObjCMethodInfo(it, onlyExternal);
                if (objCMethodInfo3 == null) continue;
                objCMethodInfo = objCMethodInfo3;
                break block4;
            }
            objCMethodInfo = null;
        }
        return objCMethodInfo;
    }

    @Nullable
    public static final ObjCMethodInfo getObjCMethodInfo(@NotNull FunctionDescriptor $this$getObjCMethodInfo) {
        Intrinsics.checkNotNullParameter($this$getObjCMethodInfo, "<this>");
        return ObjCInteropKt.getObjCMethodInfo($this$getObjCMethodInfo, false);
    }

    static {
        Name name = Name.identifier("ObjCClass");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        objCClassFqName = interopPackageName.child(name);
        Name name2 = Name.identifier("ObjCProtocol");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        objCProtocolFqName = interopPackageName.child(name2);
        externalObjCClassFqName = NativeStandardInteropNames.INSTANCE.getExternalObjCClassClassId().asSingleFqName();
        objCDirectFqName = NativeStandardInteropNames.INSTANCE.getObjCDirectClassId().asSingleFqName();
        objCMethodFqName = NativeStandardInteropNames.INSTANCE.getObjCMethodClassId().asSingleFqName();
        objCConstructorFqName = NativeStandardInteropNames.INSTANCE.getObjCConstructorClassId().asSingleFqName();
        objCFactoryFqName = NativeStandardInteropNames.INSTANCE.getObjCFactoryClassId().asSingleFqName();
    }
}

