/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

public class JsFirstExpressionVisitor
extends RecursiveJsVisitor {
    private boolean needsParentheses = false;

    public static boolean exec(JsExpressionStatement statement) {
        JsExpression expression = statement.getExpression();
        if (expression instanceof JsFunction || expression instanceof JsClass) {
            return false;
        }
        JsFirstExpressionVisitor visitor2 = new JsFirstExpressionVisitor();
        visitor2.accept(statement.getExpression());
        return visitor2.needsParentheses;
    }

    private JsFirstExpressionVisitor() {
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(0);
        }
        this.accept(x.getArrayExpression());
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(2);
        }
        this.accept(x.getArg1());
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(3);
        }
        this.accept(x.getTestExpression());
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(4);
        }
        this.needsParentheses = true;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(5);
        }
        this.accept(invocation.getQualifier());
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(6);
        }
        if (!nameRef.isLeaf()) {
            this.accept(nameRef.getQualifier());
        }
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(7);
        }
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(8);
        }
        this.needsParentheses = true;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(9);
        }
        this.accept(x.getArg());
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        if (x == null) {
            JsFirstExpressionVisitor.$$$reportNull$$$0(10);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameRef";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccess";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArray";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitBinaryExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditional";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitFunction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInvocation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNameRef";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNew";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitObjectLiteral";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPostfixOperation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

