/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001f\u001eB!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R2\u0010\u0016\u001a\u001e\u0012\b\u0012\u00060\u0014R\u00020\u0000\u0018\u00010\u0013j\u000e\u0012\b\u0012\u00060\u0014R\u00020\u0000\u0018\u0001`\u00158\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001a\u0010\u001a\u001a\b\u0018\u00010\u0014R\u00020\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R,\u0010\u001d\u001a\u001a\u0012\b\u0012\u00060\u0014R\u00020\u00000\u0013j\f\u0012\b\u0012\u00060\u0014R\u00020\u0000`\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope;", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "parent", "", "description", "", "useParentScopeStack", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsScope;Ljava/lang/String;Z)V", "label", "outputName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "enterLabel", "(Ljava/lang/String;Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "exitLabel", "()V", "findLabel", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "Lkotlin/collections/ArrayList;", "labelScopesImpl", "Ljava/util/ArrayList;", "getTopLabelScope", "()Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$LabelScope;", "topLabelScope", "getLabelScopes", "()Ljava/util/ArrayList;", "labelScopes", "Companion", "LabelScope"})
public class JsDeclarationScope
extends JsScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ArrayList<LabelScope> labelScopesImpl;
    @NotNull
    public static final Set<String> RESERVED_WORDS;

    public JsDeclarationScope(@NotNull JsScope parent2, @NotNull String description2, boolean useParentScopeStack) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(description2, "description");
        super(parent2, description2);
        this.labelScopesImpl = parent2 instanceof JsDeclarationScope && useParentScopeStack ? ((JsDeclarationScope)parent2).labelScopesImpl : null;
    }

    public /* synthetic */ JsDeclarationScope(JsScope jsScope, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(jsScope, string2, bl);
    }

    private final LabelScope getTopLabelScope() {
        LabelScope labelScope;
        ArrayList<LabelScope> arrayList = this.labelScopesImpl;
        if (arrayList != null) {
            ArrayList<LabelScope> it = arrayList;
            boolean bl = false;
            labelScope = !((Collection)it).isEmpty() ? (LabelScope)CollectionsKt.last((List)it) : null;
        } else {
            labelScope = null;
        }
        return labelScope;
    }

    private final ArrayList<LabelScope> getLabelScopes() {
        ArrayList<LabelScope> arrayList = this.labelScopesImpl;
        if (arrayList == null) {
            ArrayList arrayList2;
            ArrayList it = arrayList2 = new ArrayList();
            boolean bl = false;
            this.labelScopesImpl = it;
            arrayList = arrayList2;
        }
        return arrayList;
    }

    @NotNull
    public JsName enterLabel(@NotNull String label, @NotNull String outputName) {
        Intrinsics.checkNotNullParameter(label, "label");
        Intrinsics.checkNotNullParameter(outputName, "outputName");
        LabelScope scope2 = new LabelScope(this.getTopLabelScope(), label, outputName);
        this.getLabelScopes().add(scope2);
        return scope2.getLabelName();
    }

    public void exitLabel() {
        boolean bl;
        ArrayList<LabelScope> it = this.getLabelScopes();
        boolean bl2 = false;
        boolean bl3 = bl = !((Collection)it).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "No scope to exit from";
            throw new AssertionError((Object)string2);
        }
        LabelScope cfr_ignored_0 = (LabelScope)CollectionsKt.removeLast((List)it);
    }

    @Nullable
    public JsName findLabel(@NotNull String label) {
        Intrinsics.checkNotNullParameter(label, "label");
        LabelScope labelScope = this.getTopLabelScope();
        return labelScope != null ? labelScope.findName(label) : null;
    }

    static {
        String[] stringArray = new String[]{"NaN", "isNaN", "Infinity", "undefined", "Error", "Object", "Math", "String", "Number", "Boolean", "Date", "Array", "RegExp", "JSON", "require", "define", "module", "window", "self", "Kotlin"};
        RESERVED_WORDS = SetsKt.plus(IdentifierPolicyKt.getRESERVED_KEYWORDS(), (Iterable)SetsKt.setOf(stringArray));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsDeclarationScope$Companion;", "", "<init>", "()V", "", "", "RESERVED_WORDS", "Ljava/util/Set;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private final class LabelScope
    extends JsScope {
        @NotNull
        private final String ident;
        @NotNull
        private final JsName labelName;

        public LabelScope(@NotNull LabelScope parent2, @NotNull String ident, String outputIdent) {
            Intrinsics.checkNotNullParameter(ident, "ident");
            Intrinsics.checkNotNullParameter(outputIdent, "outputIdent");
            super(parent2, "Label scope for " + ident);
            this.ident = ident;
            this.labelName = new JsName(outputIdent, true);
        }

        @NotNull
        public final JsName getLabelName() {
            return this.labelName;
        }

        @Override
        @Nullable
        protected JsName findOwnName(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return Intrinsics.areEqual(name, this.ident) ? this.labelName : null;
        }
    }
}

