/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import com.intellij.util.SmartList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;

public final class JsFunction
extends JsLiteral
implements HasName {
    @NotNull
    private JsBlock body;
    private List<JsParameter> params;
    @NotNull
    private final JsFunctionScope scope;
    private JsName name;
    private Set<Modifier> modifiers;
    private boolean isEs6Arrow;

    public JsFunction(@NotNull JsScope parentScope, @NotNull String description2) {
        if (parentScope == null) {
            JsFunction.$$$reportNull$$$0(0);
        }
        if (description2 == null) {
            JsFunction.$$$reportNull$$$0(1);
        }
        this(parentScope, description2, null);
    }

    private JsFunction(@NotNull JsScope parentScope, @NotNull String description2, @Nullable JsName name) {
        if (parentScope == null) {
            JsFunction.$$$reportNull$$$0(5);
        }
        if (description2 == null) {
            JsFunction.$$$reportNull$$$0(6);
        }
        this.name = name;
        this.scope = new JsFunctionScope(parentScope, name == null ? description2 : name.getIdent());
    }

    @NotNull
    public JsBlock getBody() {
        JsBlock jsBlock = this.body;
        if (jsBlock == null) {
            JsFunction.$$$reportNull$$$0(7);
        }
        return jsBlock;
    }

    @Override
    public JsName getName() {
        return this.name;
    }

    @NotNull
    public List<JsParameter> getParameters() {
        if (this.params == null) {
            this.params = new SmartList<JsParameter>();
        }
        List<JsParameter> list = this.params;
        if (list == null) {
            JsFunction.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public JsFunctionScope getScope() {
        JsFunctionScope jsFunctionScope = this.scope;
        if (jsFunctionScope == null) {
            JsFunction.$$$reportNull$$$0(9);
        }
        return jsFunctionScope;
    }

    public boolean isStatic() {
        return this.modifiers != null && this.modifiers.contains((Object)Modifier.STATIC);
    }

    public boolean isGetter() {
        return this.modifiers != null && this.modifiers.contains((Object)Modifier.GET);
    }

    public boolean isSetter() {
        return this.modifiers != null && this.modifiers.contains((Object)Modifier.SET);
    }

    public boolean isGenerator() {
        return this.modifiers != null && this.modifiers.contains((Object)Modifier.GENERATOR);
    }

    @NotNull
    public Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = EnumSet.noneOf(Modifier.class);
        }
        Set<Modifier> set = this.modifiers;
        if (set == null) {
            JsFunction.$$$reportNull$$$0(10);
        }
        return set;
    }

    public boolean isEs6Arrow() {
        return this.isEs6Arrow;
    }

    public void setBody(@NotNull JsBlock body2) {
        if (body2 == null) {
            JsFunction.$$$reportNull$$$0(11);
        }
        this.body = body2;
    }

    public void setName(@Nullable JsName name) {
        this.name = name;
    }

    @Override
    public void accept(JsVisitor v) {
        v.visitFunction(this);
    }

    @Override
    public void acceptChildren(JsVisitor visitor2) {
        visitor2.acceptWithInsertRemove(this.getParameters());
        visitor2.accept(this.body);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentScope";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/backend/ast/JsFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/backend/ast/JsFunction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBody";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "deepCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setBody";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Modifier {
        STATIC,
        GET,
        SET,
        GENERATOR;

    }
}

