/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u00d6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00d7\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0003\u001a\u00020\u00028\u0016X\u0097\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0013R\u0014\u0010\u0005\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u00048\u0016X\u0097\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0014R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00028\u0016X\u0097\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocationWithSource;", "", "file", "", "startLine", "startChar", "name", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "I"})
public final class JsLocation
implements JsLocationWithSource {
    @NotNull
    public final String file;
    public final int startLine;
    public final int startChar;
    @Nullable
    public final String name;

    public JsLocation(@NotNull String file2, int startLine, int startChar, @Nullable String name) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.file = file2;
        this.startLine = startLine;
        this.startChar = startChar;
        this.name = name;
    }

    @NotNull
    public String toString() {
        return "JsLocation(file=" + this.file + ", startLine=" + this.startLine + ", startChar=" + this.startChar + ", name=" + this.name + ')';
    }

    public int hashCode() {
        int result2 = this.file.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.startLine);
        result2 = result2 * 31 + Integer.hashCode(this.startChar);
        result2 = result2 * 31 + (this.name == null ? 0 : this.name.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsLocation)) {
            return false;
        }
        JsLocation jsLocation = (JsLocation)other;
        if (!Intrinsics.areEqual(this.file, jsLocation.file)) {
            return false;
        }
        if (this.startLine != jsLocation.startLine) {
            return false;
        }
        if (this.startChar != jsLocation.startChar) {
            return false;
        }
        return Intrinsics.areEqual(this.name, jsLocation.name);
    }
}

