/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.util.Maps;

public abstract class JsScope {
    @NotNull
    private final String description;
    private Map<String, JsName> names;
    private final JsScope parent;

    public JsScope(JsScope parent2, @NotNull String description2) {
        if (description2 == null) {
            JsScope.$$$reportNull$$$0(0);
        }
        this.names = Collections.emptyMap();
        this.description = description2;
        this.parent = parent2;
    }

    protected JsScope(@NotNull String description2) {
        if (description2 == null) {
            JsScope.$$$reportNull$$$0(1);
        }
        this.names = Collections.emptyMap();
        this.description = description2;
        this.parent = null;
    }

    @NotNull
    public JsName declareName(@NotNull String identifier) {
        JsName name;
        if (identifier == null) {
            JsScope.$$$reportNull$$$0(2);
        }
        JsName jsName = (name = this.findOwnName(identifier)) != null ? name : this.doCreateName(identifier);
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(3);
        }
        return jsName;
    }

    @Nullable
    public final JsName findName(@NotNull String ident) {
        JsName name;
        if (ident == null) {
            JsScope.$$$reportNull$$$0(5);
        }
        if ((name = this.findOwnName(ident)) == null && this.parent != null) {
            return this.parent.findName(ident);
        }
        return name;
    }

    public final JsScope getParent() {
        return this.parent;
    }

    public final String toString() {
        if (this.parent != null) {
            return this.description + "->" + this.parent;
        }
        return this.description;
    }

    @NotNull
    protected JsName doCreateName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(9);
        }
        JsName name = new JsName(ident, false);
        this.names = Maps.put(this.names, ident, name);
        JsName jsName = name;
        if (jsName == null) {
            JsScope.$$$reportNull$$$0(10);
        }
        return jsName;
    }

    protected JsName findOwnName(@NotNull String ident) {
        if (ident == null) {
            JsScope.$$$reportNull$$$0(11);
        }
        return this.names.get(ident);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 5: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ident";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/backend/ast/JsScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "declareName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "declareName";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "declareTemporaryName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasOwnName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCreateName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOwnName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

