/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDebugger;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsDocComment;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsRegExp;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.JsYield;

public abstract class JsVisitor {
    public <T extends JsNode> void accept(T node) {
        block0: {
            T t = node;
            if (t == null) break block0;
            t.accept(this);
        }
    }

    public final <T extends JsNode> void acceptList(@NotNull List<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        for (JsNode node : collection) {
            this.accept(node);
        }
    }

    public final void acceptLvalue(@NotNull JsExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.accept((JsNode)expression);
    }

    public final <T extends JsNode> void acceptWithInsertRemove(@NotNull List<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, "collection");
        for (JsNode node : collection) {
            this.accept(node);
        }
    }

    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitArray(@NotNull JsArrayLiteral x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitBlock(@NotNull JsBlock x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitBoolean(@NotNull JsBooleanLiteral x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitBreak(@NotNull JsBreak x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitCase(@NotNull JsCase x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitCatch(@NotNull JsCatch x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitClass(@NotNull JsClass x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitConditional(@NotNull JsConditional x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitContinue(@NotNull JsContinue x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitYield(@NotNull JsYield x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitDebugger(@NotNull JsDebugger x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitDefault(@NotNull JsDefault x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitDoWhile(@NotNull JsDoWhile x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitLoop(x);
    }

    public void visitEmpty(@NotNull JsEmpty x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitExpressionStatement(@NotNull JsExpressionStatement x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitFor(@NotNull JsFor x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitLoop(x);
    }

    public void visitForIn(@NotNull JsForIn x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitLoop(x);
    }

    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitIf(@NotNull JsIf x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitInvocation(@NotNull JsInvocation invocation) {
        Intrinsics.checkNotNullParameter(invocation, "invocation");
        this.visitElement(invocation);
    }

    public void visitLabel(@NotNull JsLabel x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitLoop(@NotNull JsLoop x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitNameRef(@NotNull JsNameRef nameRef) {
        Intrinsics.checkNotNullParameter(nameRef, "nameRef");
        this.visitElement(nameRef);
    }

    public void visitNew(@NotNull JsNew x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitNull(@NotNull JsNullLiteral x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitInt(@NotNull JsIntLiteral x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitDouble(@NotNull JsDoubleLiteral x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitParameter(@NotNull JsParameter x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitProgram(@NotNull JsProgram x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitPropertyInitializer(@NotNull JsPropertyInitializer x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitRegExp(@NotNull JsRegExp x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitReturn(@NotNull JsReturn x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitString(@NotNull JsStringLiteral x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visit(@NotNull JsSwitch x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitThis(@NotNull JsThisRef x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitThrow(@NotNull JsThrow x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitTry(@NotNull JsTry x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visit(@NotNull JsVars.JsVar x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitElement(x);
    }

    public void visitWhile(@NotNull JsWhile x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.visitLoop(x);
    }

    public void visitDocComment(@NotNull JsDocComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        this.visitElement(comment);
    }

    public void visitSingleLineComment(@NotNull JsSingleLineComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        this.visitElement(comment);
    }

    public void visitMultiLineComment(@NotNull JsMultiLineComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        this.visitElement(comment);
    }

    protected void visitElement(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
    }
}

