/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.common;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

public final class IdentifierPolicyKt {
    @NotNull
    private static final Set<String> SPECIAL_KEYWORDS = SetsKt.setOf("default");
    @NotNull
    private static final Set<String> RESERVED_KEYWORDS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isAllowedLatinLetterOrSpecial(char $this$isAllowedLatinLetterOrSpecial) {
        boolean bl;
        boolean bl2;
        if ('a' <= $this$isAllowedLatinLetterOrSpecial) {
            if ($this$isAllowedLatinLetterOrSpecial < '{') {
                return true;
            }
            bl2 = false;
        } else {
            bl2 = false;
        }
        if (bl2) return true;
        if ('A' <= $this$isAllowedLatinLetterOrSpecial) {
            if ($this$isAllowedLatinLetterOrSpecial < '[') {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if ($this$isAllowedLatinLetterOrSpecial == '_') return true;
        if ($this$isAllowedLatinLetterOrSpecial != '$') return false;
        return true;
    }

    private static final boolean isAllowedSimpleDigit(char $this$isAllowedSimpleDigit) {
        return '0' <= $this$isAllowedSimpleDigit ? $this$isAllowedSimpleDigit < ':' : false;
    }

    private static final boolean isNotAllowedSimpleCharacter(char $this$isNotAllowedSimpleCharacter) {
        boolean bl;
        switch ($this$isNotAllowedSimpleCharacter) {
            case ' ': 
            case '-': 
            case '<': 
            case '>': 
            case '?': {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isES5IdentifierStart(char $this$isES5IdentifierStart) {
        if (IdentifierPolicyKt.isAllowedLatinLetterOrSpecial($this$isES5IdentifierStart)) {
            return true;
        }
        if (IdentifierPolicyKt.isNotAllowedSimpleCharacter($this$isES5IdentifierStart)) {
            return false;
        }
        return IdentifierPolicyKt.isES5IdentifierStartFull($this$isES5IdentifierStart);
    }

    private static final boolean isES5IdentifierStartFull(char $this$isES5IdentifierStartFull) {
        return Character.isLetter($this$isES5IdentifierStartFull) || (byte)Character.getType($this$isES5IdentifierStartFull) == 10;
    }

    public static final boolean isES5IdentifierPart(char $this$isES5IdentifierPart) {
        byte by;
        if (IdentifierPolicyKt.isAllowedLatinLetterOrSpecial($this$isES5IdentifierPart)) {
            return true;
        }
        if (IdentifierPolicyKt.isAllowedSimpleDigit($this$isES5IdentifierPart)) {
            return true;
        }
        if (IdentifierPolicyKt.isNotAllowedSimpleCharacter($this$isES5IdentifierPart)) {
            return false;
        }
        return IdentifierPolicyKt.isES5IdentifierStartFull($this$isES5IdentifierPart) || (by = (byte)Character.getType($this$isES5IdentifierPart)) == 6 || by == 8 || by == 9 || by == 23 || $this$isES5IdentifierPart == '\u200c' || $this$isES5IdentifierPart == '\u200d';
    }

    public static final boolean isValidES5Identifier(@NotNull String $this$isValidES5Identifier) {
        Intrinsics.checkNotNullParameter($this$isValidES5Identifier, "<this>");
        if (((CharSequence)$this$isValidES5Identifier).length() == 0 || !IdentifierPolicyKt.isES5IdentifierStart($this$isValidES5Identifier.charAt(0))) {
            return false;
        }
        int n = $this$isValidES5Identifier.length();
        for (int idx = 1; idx < n; ++idx) {
            if (IdentifierPolicyKt.isES5IdentifierPart($this$isValidES5Identifier.charAt(idx))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static final Set<String> getSPECIAL_KEYWORDS() {
        return SPECIAL_KEYWORDS;
    }

    @NotNull
    public static final Set<String> getRESERVED_KEYWORDS() {
        return RESERVED_KEYWORDS;
    }

    static {
        String[] stringArray = new String[]{"await", "break", "case", "catch", "continue", "debugger", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "import", "super", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield", "null", "true", "false", "eval", "arguments"};
        RESERVED_KEYWORDS = SetsKt.plus(SPECIAL_KEYWORDS, (Iterable)SetsKt.setOf(stringArray));
    }
}

