/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.naming;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;
import org.jetbrains.kotlin.js.naming.EncodeSignatureKt;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011J!\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u001f\u0010\n\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\rR\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion;", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "Lorg/jetbrains/kotlin/js/naming/SuggestedName;", "suggest", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/js/naming/SuggestedName;", "generate", "generateDefault", "", "getSuggestedName", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Ljava/lang/String;", "", "cache", "Ljava/util/Map;", "Companion"})
public class NameSuggestion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<DeclarationDescriptor, SuggestedName> cache;

    @Nullable
    public final SuggestedName suggest(@NotNull DeclarationDescriptor descriptor2, @NotNull BindingContext bindingContext) {
        SuggestedName suggestedName;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Map<DeclarationDescriptor, SuggestedName> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        SuggestedName value$iv = $this$getOrPut$iv.get(descriptor2);
        if (value$iv == null) {
            boolean bl = false;
            DeclarationDescriptor declarationDescriptor = descriptor2.getOriginal();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getOriginal(...)");
            SuggestedName answer$iv = this.generate(declarationDescriptor, bindingContext);
            $this$getOrPut$iv.put(descriptor2, answer$iv);
            suggestedName = answer$iv;
        } else {
            suggestedName = value$iv;
        }
        return suggestedName;
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedName generate(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        DeclarationDescriptor declarationDescriptor;
        if (AnnotationsUtils.isNativeObject(descriptor2) && DescriptorUtils.isCompanionObject(descriptor2)) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor2);
            return this.suggest(declarationDescriptor2, bindingContext);
        }
        if (descriptor2 instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor2).isSuspend() && (declarationDescriptor = ((FunctionDescriptor)descriptor2).getInitialSignatureDescriptor()) != null) {
            DeclarationDescriptor it = declarationDescriptor;
            boolean bl = false;
            return NameSuggestion.generate$suggest(this, bindingContext, it);
        }
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            List<String> list = CollectionsKt.listOf(descriptor2.getName().asString());
            DeclarationDescriptor declarationDescriptor3 = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor3);
            return new SuggestedName(list, true, descriptor2, declarationDescriptor3);
        }
        declarationDescriptor = descriptor2;
        if (declarationDescriptor instanceof ModuleDescriptor) {
            return null;
        }
        if (declarationDescriptor instanceof PackageFragmentDescriptor) {
            SuggestedName suggestedName;
            if (!((PackageFragmentDescriptor)descriptor2).getFqName().isRoot()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = ((PackageFragmentDescriptor)descriptor2).getFqName().pathSegments();
                boolean $i$f$map = false;
                Iterable bl = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    Name name = (Name)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(p0.asString());
                }
                DeclarationDescriptor declarationDescriptor4 = ((PackageFragmentDescriptor)descriptor2).getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor5 = descriptor2;
                boolean bl3 = true;
                List list = (List)destination$iv$iv;
                suggestedName = new SuggestedName(list, bl3, declarationDescriptor5, declarationDescriptor4);
            } else {
                suggestedName = null;
            }
            return suggestedName;
        }
        if (declarationDescriptor instanceof FakeCallableDescriptorForObject) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((FakeCallableDescriptorForObject)descriptor2).getReferencedObject());
        }
        if (declarationDescriptor instanceof TypeAliasConstructorDescriptor) {
            return NameSuggestion.generate$suggest(this, bindingContext, ((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor());
        }
        if (declarationDescriptor instanceof ConstructorDescriptor) {
            if (((ConstructorDescriptor)descriptor2).isPrimary() || AnnotationsUtils.isNativeObject(descriptor2)) {
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(classifierDescriptorWithTypeParameters, "getContainingDeclaration(...)");
                return NameSuggestion.generate$suggest(this, bindingContext, classifierDescriptorWithTypeParameters);
            }
        } else if (declarationDescriptor instanceof CallableDescriptor && DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2)) {
            String ownName;
            String string2 = AnnotationsUtils.getNameForAnnotatedObject(descriptor2, bindingContext);
            if (string2 == null) {
                string2 = this.getSuggestedName(descriptor2);
            }
            String name = ownName = string2;
            DeclarationDescriptor declarationDescriptor6 = ((CallableDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor6, "getContainingDeclaration(...)");
            DeclarationDescriptor scope2 = declarationDescriptor6;
            if (descriptor2 instanceof FunctionDescriptor) {
                DeclarationDescriptor declarationDescriptor7 = ((FunctionDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor7, "getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor7;
                String liftedName = ownName;
                boolean hasInline = false;
                while (container instanceof FunctionDescriptor) {
                    if (((FunctionDescriptor)container).isInline() && NameSuggestion.Companion.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)container).isPublicAPI()) {
                        hasInline = true;
                    }
                    liftedName = this.getSuggestedName(container) + '$' + liftedName;
                    Intrinsics.checkNotNullExpressionValue(((FunctionDescriptor)container).getContainingDeclaration(), "getContainingDeclaration(...)");
                }
                if (hasInline) {
                    scope2 = container;
                    name = liftedName;
                }
            }
            return new SuggestedName(CollectionsKt.listOf(name), false, descriptor2, scope2);
        }
        return this.generateDefault(descriptor2, bindingContext);
    }

    private final SuggestedName generateDefault(DeclarationDescriptor descriptor2, BindingContext bindingContext) {
        String string2;
        List parts = new ArrayList();
        DeclarationDescriptor current = descriptor2;
        if (current instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)current).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            CallableDescriptor callableDescriptor = NameSuggestion.Companion.getOverridden((CallableDescriptor)current);
            Intrinsics.checkNotNull(callableDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
            CallableMemberDescriptor overridden = (CallableMemberDescriptor)callableDescriptor;
            if (!ModalityUtilsKt.isOverridableOrOverrides(overridden)) {
                current = overridden;
            }
        }
        DeclarationDescriptor fixedDescriptor = current;
        Collection collection = parts;
        if (fixedDescriptor instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)current).getContainingDeclaration();
            Intrinsics.checkNotNull(classifierDescriptorWithTypeParameters);
            current = classifierDescriptorWithTypeParameters;
            string2 = this.getSuggestedName(current) + "_init";
        } else {
            string2 = this.getSuggestedName(fixedDescriptor);
        }
        Object object = string2;
        collection.add(object);
        if (current.getContainingDeclaration() instanceof FunctionDescriptor && !(current instanceof TypeParameterDescriptor)) {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
            SuggestedName suggestedName = this.suggest((FunctionDescriptor)declarationDescriptor, bindingContext);
            Intrinsics.checkNotNull(suggestedName);
            SuggestedName outerFunctionName = suggestedName;
            ((Collection)parts).add(CollectionsKt.single(outerFunctionName.getNames()));
            current = outerFunctionName.getScope();
        } else {
            DeclarationDescriptor declarationDescriptor = current.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor);
            current = declarationDescriptor;
        }
        if (current instanceof PropertyDescriptor) {
            DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)current).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            current = declarationDescriptor;
        }
        CollectionsKt.reverse(parts);
        String unmangledName = CollectionsKt.joinToString$default(parts, "$", null, null, 0, null, null, 62, null);
        object = NameSuggestion.Companion.mangleNameIfNecessary(unmangledName, fixedDescriptor, bindingContext);
        String id = ((Companion.NameAndStability)object).component1();
        boolean stable = ((Companion.NameAndStability)object).component2();
        return new SuggestedName(CollectionsKt.listOf(id), stable, fixedDescriptor, current);
    }

    private final String getSuggestedName(DeclarationDescriptor descriptor2) {
        String string2;
        Name name = descriptor2.getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        Name name2 = name;
        if (name2.isSpecial()) {
            DeclarationDescriptor declarationDescriptor = descriptor2;
            if (declarationDescriptor instanceof PropertyGetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("get_");
                PropertyDescriptor propertyDescriptor = ((PropertyGetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
                string2 = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else if (declarationDescriptor instanceof PropertySetterDescriptor) {
                StringBuilder stringBuilder = new StringBuilder().append("set_");
                PropertyDescriptor propertyDescriptor = ((PropertySetterDescriptor)descriptor2).getCorrespondingProperty();
                Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getCorrespondingProperty(...)");
                string2 = stringBuilder.append(this.getSuggestedName(propertyDescriptor)).toString();
            } else {
                string2 = "f";
            }
        } else {
            String string3 = name2.asString();
            Intrinsics.checkNotNull(string3);
            string2 = string3;
        }
        return string2;
    }

    private static final SuggestedName generate$suggest(NameSuggestion this$0, BindingContext $bindingContext, DeclarationDescriptor d) {
        return this$0.suggest(d, $bindingContext);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001aR\u0018\u0010!\u001a\u00020\u001e*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 "}, d2={"Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion;", "", "<init>", "()V", "", "baseName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "mangleNameIfNecessary", "(Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getOverridden", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "mangleRegularNameIfNecessary", "(Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/js/naming/NameSuggestion$Companion$NameAndStability;", "getPrivateMangledName", "(Ljava/lang/String;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/lang/String;", "suggestedName", "forCalculateId", "getInternalMangledName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "getStableMangledName", "mangledId", "(Ljava/lang/String;)Ljava/lang/String;", "name", "sanitizeName", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "getOwnEffectiveVisibility", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "ownEffectiveVisibility", "NameAndStability"})
    public static final class Companion {
        private Companion() {
        }

        private final NameAndStability mangleNameIfNecessary(String baseName, DeclarationDescriptor descriptor2, BindingContext bindingContext) {
            DeclarationDescriptor overriddenDescriptor = descriptor2 instanceof CallableDescriptor ? (DeclarationDescriptor)SequencesKt.last(SequencesKt.generateSequence(descriptor2, Companion::mangleNameIfNecessary$lambda$0)) : descriptor2;
            String nativeName = AnnotationsUtils.getNameForAnnotatedObject(overriddenDescriptor, bindingContext);
            if (nativeName != null) {
                return new NameAndStability(nativeName, true);
            }
            if (overriddenDescriptor instanceof FunctionDescriptor) {
                String string2 = DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor).asString();
                if (Intrinsics.areEqual(string2, "kotlin.CharSequence.get")) {
                    return new NameAndStability("charCodeAt", true);
                }
                if (Intrinsics.areEqual(string2, "kotlin.Any.equals")) {
                    return new NameAndStability("equals", true);
                }
                DeclarationDescriptor declarationDescriptor = ((FunctionDescriptor)overriddenDescriptor).getContainingDeclaration();
                Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
                DeclarationDescriptor container = declarationDescriptor;
                if (container instanceof ClassDescriptor) {
                    SimpleType simpleType2 = ((ClassDescriptor)container).getDefaultType();
                    Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
                    if (ReflectionTypes.Companion.isNumberedKPropertyOrKMutablePropertyType(simpleType2)) {
                        String name;
                        String string3 = ((FunctionDescriptor)overriddenDescriptor).getName().asString();
                        Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
                        String string4 = name = string3;
                        if (Intrinsics.areEqual(string4, "get") || Intrinsics.areEqual(string4, "set")) {
                            return new NameAndStability(name, true);
                        }
                    }
                }
            } else if (overriddenDescriptor instanceof PropertyDescriptor && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(overriddenDescriptor).asString(), "kotlin.reflect.KCallable.name")) {
                return new NameAndStability("callableName", true);
            }
            return this.mangleRegularNameIfNecessary(baseName, overriddenDescriptor);
        }

        private final CallableDescriptor getOverridden(CallableDescriptor descriptor2) {
            return SequencesKt.last(SequencesKt.generateSequence(descriptor2, Companion::getOverridden$lambda$1));
        }

        private final NameAndStability mangleRegularNameIfNecessary(String baseName, DeclarationDescriptor descriptor2) {
            NameAndStability nameAndStability;
            DeclarationDescriptor containingDeclaration;
            if (descriptor2 instanceof ClassOrPackageFragmentDescriptor) {
                return new NameAndStability(baseName, !DescriptorUtils.isDescriptorWithLocalVisibility(descriptor2));
            }
            if (!(descriptor2 instanceof CallableMemberDescriptor)) {
                return org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            DescriptorVisibility effectiveVisibility = this.getOwnEffectiveVisibility((DeclarationDescriptorWithVisibility)descriptor2);
            DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            DeclarationDescriptor declarationDescriptor2 = containingDeclaration = declarationDescriptor;
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                nameAndStability = effectiveVisibility.isPublicAPI() ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.INTERNAL) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName));
            } else if (declarationDescriptor2 instanceof ClassDescriptor) {
                nameAndStability = descriptor2 instanceof FunctionDescriptor && DescriptorUtilsKt.isEnumValueOfMethod((FunctionDescriptor)descriptor2) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.PUBLIC) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (ModalityUtilsKt.isOverridableOrOverrides((CallableMemberDescriptor)descriptor2) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.PROTECTED) && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) && ((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledAndStable(baseName, descriptor2) : (Intrinsics.areEqual(effectiveVisibility, DescriptorVisibilities.INTERNAL) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledInternal(baseName, descriptor2) : (((ClassDescriptor)containingDeclaration).getVisibility().isPublicAPI() && !ModalityUtilsKt.isFinalClass((ClassDescriptor)containingDeclaration) ? org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$mangledPrivate(baseName, descriptor2) : org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName))))));
            } else {
                boolean bl = containingDeclaration instanceof CallableMemberDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl2 = false;
                    String string2 = "containingDeclaration for descriptor have unsupported type for mangling, descriptor: " + descriptor2 + ", containingDeclaration: " + containingDeclaration;
                    throw new AssertionError((Object)string2);
                }
                nameAndStability = org.jetbrains.kotlin.js.naming.NameSuggestion$Companion.mangleRegularNameIfNecessary$regularAndUnstable(baseName);
            }
            return nameAndStability;
        }

        @NotNull
        public final String getPrivateMangledName(@NotNull String baseName, @NotNull CallableDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter(baseName, "baseName");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            String ownerName = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            return this.getStableMangledName(this.sanitizeName(baseName), ownerName + '.' + baseName + ':' + EncodeSignatureKt.encodeSignature(descriptor2));
        }

        @NotNull
        public final String getInternalMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter(suggestedName, "suggestedName");
            Intrinsics.checkNotNullParameter(forCalculateId, "forCalculateId");
            String suffix = '_' + this.mangledId("internal:" + forCalculateId) + '$';
            return suggestedName + suffix;
        }

        @NotNull
        public final String getStableMangledName(@NotNull String suggestedName, @NotNull String forCalculateId) {
            Intrinsics.checkNotNullParameter(suggestedName, "suggestedName");
            Intrinsics.checkNotNullParameter(forCalculateId, "forCalculateId");
            String suffix = ((CharSequence)forCalculateId).length() == 0 ? "" : '_' + this.mangledId(forCalculateId) + '$';
            return suggestedName + suffix;
        }

        private final String mangledId(String forCalculateId) {
            String string2;
            int absHashCode = Math.abs(forCalculateId.hashCode());
            if (absHashCode != 0) {
                String string3 = Integer.toString(absHashCode, CharsKt.checkRadix(36));
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
            } else {
                string2 = "";
            }
            return string2;
        }

        private final DescriptorVisibility getOwnEffectiveVisibility(DeclarationDescriptorWithVisibility $this$ownEffectiveVisibility) {
            DescriptorVisibility descriptorVisibility = $this$ownEffectiveVisibility.getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "getVisibility(...)");
            return EffectiveVisibilityUtilsKt.toDescriptorVisibility(EffectiveVisibilityUtilsKt.effectiveVisibility(descriptorVisibility, $this$ownEffectiveVisibility, true));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String sanitizeName(@NotNull String name) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(name, "name");
            if (((CharSequence)name).length() == 0) {
                return "_";
            }
            char it = StringsKt.first(name);
            boolean $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = false;
            char first2 = IdentifierPolicyKt.isES5IdentifierStart(it) ? it : (char)'_';
            CharSequence charSequence = StringsKt.drop(name, 1);
            StringBuilder stringBuilder = new StringBuilder().append(first2);
            boolean $i$f$map = false;
            void $i$a$-let-NameSuggestion$Companion$sanitizeName$first$22 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
                char it2;
                char item$iv$iv;
                char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Character.valueOf(IdentifierPolicyKt.isES5IdentifierPart(it2) ? it2 : (char)'_'));
            }
            return stringBuilder.append(CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null)).toString();
        }

        private static final CallableDescriptor mangleNameIfNecessary$lambda$0(CallableDescriptor it) {
            Intrinsics.checkNotNullParameter(it, "it");
            Collection<? extends CallableDescriptor> collection = it.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            CallableDescriptor callableDescriptor = (CallableDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
            return callableDescriptor != null ? callableDescriptor.getOriginal() : null;
        }

        private static final CallableDescriptor getOverridden$lambda$1(CallableDescriptor it) {
            Intrinsics.checkNotNullParameter(it, "it");
            Collection<? extends CallableDescriptor> collection = it.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            CallableDescriptor callableDescriptor = (CallableDescriptor)CollectionsKt.firstOrNull((Iterable)collection);
            return callableDescriptor != null ? callableDescriptor.getOriginal() : null;
        }

        private static final NameAndStability mangleRegularNameIfNecessary$regularAndUnstable(String $baseName) {
            return new NameAndStability($baseName, false);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledAndStable(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getStableMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledInternal(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getInternalMangledName($baseName, EncodeSignatureKt.encodeSignature((CallableDescriptor)$descriptor)), true);
        }

        private static final NameAndStability mangleRegularNameIfNecessary$mangledPrivate(String $baseName, DeclarationDescriptor $descriptor) {
            return new NameAndStability(Companion.getPrivateMangledName($baseName, (CallableDescriptor)$descriptor), false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class NameAndStability {
            @NotNull
            private final String name;
            private final boolean stable;

            public NameAndStability(@NotNull String name, boolean stable) {
                Intrinsics.checkNotNullParameter(name, "name");
                this.name = name;
                this.stable = stable;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            public final boolean component2() {
                return this.stable;
            }

            @NotNull
            public String toString() {
                return "NameAndStability(name=" + this.name + ", stable=" + this.stable + ')';
            }

            public int hashCode() {
                int result2 = this.name.hashCode();
                result2 = result2 * 31 + Boolean.hashCode(this.stable);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NameAndStability)) {
                    return false;
                }
                NameAndStability nameAndStability = (NameAndStability)other;
                if (!Intrinsics.areEqual(this.name, nameAndStability.name)) {
                    return false;
                }
                return this.stable == nameAndStability.stable;
            }
        }
    }
}

