/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

public abstract class AbstractNativeAnnotationsChecker
implements DeclarationChecker {
    @NotNull
    private final PredefinedAnnotation requiredAnnotation;

    public AbstractNativeAnnotationsChecker(@NotNull PredefinedAnnotation requiredAnnotation) {
        Intrinsics.checkNotNullParameter((Object)requiredAnnotation, "requiredAnnotation");
        this.requiredAnnotation = requiredAnnotation;
    }

    public void additionalCheck(@NotNull KtNamedFunction declaration, @NotNull FunctionDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(this.requiredAnnotation.getFqName());
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
        if (!(declaration instanceof KtNamedFunction) || !(descriptor2 instanceof FunctionDescriptor)) {
            return;
        }
        boolean isMember = !DescriptorUtils.isTopLevelDeclaration(descriptor2) && !Intrinsics.areEqual(((FunctionDescriptor)descriptor2).getVisibility(), DescriptorVisibilities.LOCAL);
        boolean isExtension = DescriptorUtils.isExtension((CallableDescriptor)descriptor2);
        if (isMember && (isExtension || !AnnotationsUtils.isNativeObject(descriptor2)) || !isMember && !isExtension) {
            context.getTrace().report(ErrorsJs.NATIVE_ANNOTATIONS_ALLOWED_ONLY_ON_MEMBER_OR_EXTENSION_FUN.on((KtElement)((PsiElement)declaration), annotationDescriptor2.getType()));
        }
        this.additionalCheck((KtNamedFunction)declaration, (FunctionDescriptor)descriptor2, context.getTrace());
    }
}

