/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.naming.JsNameSuggestion;
import org.jetbrains.kotlin.js.naming.SuggestedName;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/js/naming/JsNameSuggestion;", "nameSuggestion", "Lorg/jetbrains/kotlin/js/naming/JsNameSuggestion;", "Companion"})
public final class JsBuiltinNameClashChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsNameSuggestion nameSuggestion;
    @NotNull
    public static final Set<String> PROHIBITED_STATIC_NAMES;
    @NotNull
    public static final Set<String> PROHIBITED_MEMBER_NAMES;

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            return;
        }
        if (!(descriptor2.getContainingDeclaration() instanceof ClassDescriptor)) {
            return;
        }
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        SuggestedName suggestedName = this.nameSuggestion.suggest(descriptor2, bindingContext);
        Intrinsics.checkNotNull(suggestedName);
        SuggestedName suggestedName2 = suggestedName;
        if (!suggestedName2.getStable()) {
            return;
        }
        String simpleName2 = CollectionsKt.single(suggestedName2.getNames());
        if (descriptor2 instanceof ClassDescriptor) {
            if (PROHIBITED_STATIC_NAMES.contains(simpleName2)) {
                context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Function." + simpleName2));
            }
        } else if (descriptor2 instanceof CallableMemberDescriptor && PROHIBITED_MEMBER_NAMES.contains(simpleName2)) {
            context.getTrace().report(ErrorsJs.JS_BUILTIN_NAME_CLASH.on((KtElement)((PsiElement)declaration), "Object.prototype." + simpleName2));
        }
    }

    static {
        String[] stringArray = new String[]{"prototype", "length", "$metadata$"};
        PROHIBITED_STATIC_NAMES = SetsKt.setOf(stringArray);
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf("constructor");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0007"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsBuiltinNameClashChecker$Companion;", "", "<init>", "()V", "", "", "PROHIBITED_STATIC_NAMES", "Ljava/util/Set;", "PROHIBITED_MEMBER_NAMES"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

