/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsRootScope;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCodeErrorReporter;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ+\u0010\t\u001a\u00020\b2\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "Companion"})
public final class JsCallChecker
implements CallChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private static final DescriptorPredicate JS_PATTERN;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        if (context.isAnnotationContext() || !Companion.isJsCall(resolvedCall2)) {
            return;
        }
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNullExpressionValue(ktElement, "getCallElement(...)");
        KtElement expression = ktElement;
        if (!(expression instanceof KtCallExpression)) {
            return;
        }
        KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression).getValueArgumentList();
        List<KtValueArgument> arguments2 = ktValueArgumentList != null ? ktValueArgumentList.getArguments() : null;
        List<KtValueArgument> list = arguments2;
        if (list == null || (list = CollectionsKt.firstOrNull(list)) == null || (list = ((KtValueArgument)((Object)list)).getArgumentExpression()) == null) {
            return;
        }
        List<KtValueArgument> argument = list;
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.getTrace(), "JsCallChecker");
        Intrinsics.checkNotNullExpressionValue(temporaryBindingTrace, "create(...)");
        TemporaryBindingTrace trace = temporaryBindingTrace;
        CompileTimeConstant<?> evaluationResult = this.constantExpressionEvaluator.evaluateExpression((KtExpression)((Object)argument), trace, TypeUtils.NO_EXPECTED_TYPE);
        String code = Companion.extractStringValue(evaluationResult);
        if (code == null) {
            context.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_SHOULD_BE_CONSTANT.on((KtExpression)((PsiElement)((Object)argument))));
            return;
        }
        argument.accept(new KtVisitor(trace, context){
            final /* synthetic */ TemporaryBindingTrace $trace;
            final /* synthetic */ CallCheckerContext $context;
            {
                this.$trace = $trace;
                this.$context = $context;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                element.acceptChildren(this);
            }

            public Void visitSimpleNameExpression(KtSimpleNameExpression expression, Void data2) {
                VariableDescriptor variableAccessing;
                Intrinsics.checkNotNullParameter(expression, "expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression, this.$trace.getBindingContext());
                CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                VariableDescriptor variableDescriptor = variableAccessing = callableDescriptor instanceof VariableDescriptor ? (VariableDescriptor)callableDescriptor : null;
                boolean bl = variableDescriptor != null ? !variableDescriptor.isConst() : false;
                if (bl) {
                    this.$context.getTrace().report(ErrorsJs.JSCODE_ARGUMENT_NON_CONST_EXPRESSION.on((KtExpression)((PsiElement)expression)));
                }
                return (Void)super.visitSimpleNameExpression(expression, data2);
            }
        });
        trace.commit();
        JsCodeErrorReporter errorReporter = new JsCodeErrorReporter((KtExpression)((Object)argument), code, context.getTrace());
        try {
            List<JsStatement> statements;
            JsFunctionScope parserScope = new JsFunctionScope(new JsRootScope(new JsProgram()), "<js fun>");
            ErrorReporter errorReporter2 = errorReporter;
            JsScope jsScope = parserScope;
            CodePosition codePosition = new CodePosition(0, 0);
            Object object = reportOn.getContainingFile();
            if (object == null || (object = object.getName()) == null) {
                object = "<unknown file>";
            }
            if ((statements = ParserUtilsKt.parseExpressionOrStatement(code, errorReporter2, jsScope, codePosition, (String)object)) == null || statements.isEmpty()) {
                context.getTrace().report(ErrorsJs.JSCODE_NO_JAVASCRIPT_PRODUCED.on((KtExpression)((PsiElement)((Object)argument))));
            }
        }
        catch (AbortParsingException abortParsingException) {
            // empty catch block
        }
        context.getTrace().record(BindingContextSlicesJsKt.LEXICAL_SCOPE_FOR_JS, resolvedCall2, context.getScope());
    }

    static {
        DescriptorPredicate descriptorPredicate = PatternBuilder.pattern("kotlin.js.js(String)");
        Intrinsics.checkNotNullExpressionValue(descriptorPredicate, "pattern(...)");
        JS_PATTERN = descriptorPredicate;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\b\u001a\u00020\u0007\"\n\b\u0000\u0010\u0005*\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsCallChecker$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "F", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "", "isJsCall", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Z", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "compileTimeConstant", "", "extractStringValue", "(Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;", "JS_PATTERN", "Lorg/jetbrains/kotlin/js/patterns/DescriptorPredicate;"})
    public static final class Companion {
        private Companion() {
        }

        public final <F extends CallableDescriptor> boolean isJsCall(@NotNull ResolvedCall<F> $this$isJsCall) {
            Intrinsics.checkNotNullParameter($this$isJsCall, "<this>");
            F f = $this$isJsCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(f, "getResultingDescriptor(...)");
            F descriptor2 = f;
            return descriptor2 instanceof SimpleFunctionDescriptor && JS_PATTERN.test(descriptor2);
        }

        @Nullable
        public final String extractStringValue(@Nullable CompileTimeConstant<?> compileTimeConstant) {
            TypedCompileTimeConstant typedCompileTimeConstant = compileTimeConstant instanceof TypedCompileTimeConstant ? (TypedCompileTimeConstant)compileTimeConstant : null;
            ConstantValue constantValue = typedCompileTimeConstant != null ? typedCompileTimeConstant.getConstantValue() : null;
            StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
            return stringValue != null ? (String)stringValue.getValue() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

