/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.google.gwt.dev.js.parserExceptions.AbortParsingException;
import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.CodePositionKt;
import com.google.gwt.dev.js.rhino.ErrorReporter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallCheckerKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallData;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsCallDataWithCode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;

public final class JsCodeErrorReporter
implements ErrorReporter {
    @NotNull
    private final KtExpression nodeToReport;
    @NotNull
    private final String code;
    @NotNull
    private final BindingTrace trace;

    public JsCodeErrorReporter(@NotNull KtExpression nodeToReport, @NotNull String code, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(nodeToReport, "nodeToReport");
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.nodeToReport = nodeToReport;
        this.code = code;
        this.trace = trace;
    }

    @Override
    public void warning(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(startPosition, "startPosition");
        Intrinsics.checkNotNullParameter(endPosition, "endPosition");
        DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_WARNING;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, "JSCODE_WARNING");
        this.report(diagnosticFactory1, message, startPosition, endPosition);
    }

    @Override
    public void error(@NotNull String message, @NotNull CodePosition startPosition, @NotNull CodePosition endPosition) {
        Intrinsics.checkNotNullParameter(message, "message");
        Intrinsics.checkNotNullParameter(startPosition, "startPosition");
        Intrinsics.checkNotNullParameter(endPosition, "endPosition");
        DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory1 = ErrorsJs.JSCODE_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, "JSCODE_ERROR");
        this.report(diagnosticFactory1, message, startPosition, endPosition);
        throw new AbortParsingException();
    }

    private final void report(DiagnosticFactory1<KtExpression, JsCallData> diagnosticFactory, String message, CodePosition startPosition, CodePosition endPosition) {
        JsCallData jsCallData;
        TextRange reportRange;
        if (JsCallCheckerKt.access$isConstantStringLiteral(this.nodeToReport)) {
            reportRange = new TextRange(this.getAbsoluteOffset(startPosition), this.getAbsoluteOffset(endPosition));
            jsCallData = new JsCallData(reportRange, message);
        } else {
            reportRange = this.nodeToReport.getTextRange();
            TextRange codeRange = new TextRange(CodePositionKt.offsetOf(this.code, startPosition), CodePositionKt.offsetOf(this.code, endPosition));
            Intrinsics.checkNotNull(reportRange);
            jsCallData = new JsCallDataWithCode(reportRange, message, this.code, codeRange);
        }
        JsCallData data2 = jsCallData;
        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic = diagnosticFactory.on((KtExpression)((PsiElement)this.nodeToReport), data2);
        Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
        ParametrizedDiagnostic<KtExpression> parametrizedDiagnostic2 = parametrizedDiagnostic;
        this.trace.report(parametrizedDiagnostic2);
    }

    private final int getAbsoluteOffset(CodePosition $this$absoluteOffset) {
        int quotesLength = this.nodeToReport.getFirstChild().getTextLength();
        return this.nodeToReport.getTextOffset() + quotesLength + CodePositionKt.offsetOf(this.code, $this$absoluteOffset);
    }
}

