/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExternalInheritorOnlyChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V"})
public final class JsExternalInheritorOnlyChecker
implements DeclarationChecker {
    @NotNull
    public static final JsExternalInheritorOnlyChecker INSTANCE = new JsExternalInheritorOnlyChecker();

    private JsExternalInheritorOnlyChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (descriptor2 instanceof ClassDescriptor && !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor2)) {
            Sequence<ClassifierDescriptor> $this$forEach$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
            boolean $i$f$forEach = false;
            Iterator<ClassifierDescriptor> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                ClassifierDescriptor element$iv;
                ClassifierDescriptor parent2 = element$iv = iterator2.next();
                boolean bl = false;
                if (!(parent2 instanceof ClassDescriptor) || !AnnotationsUtils.isJsExternalInheritorsOnly((ClassDescriptor)parent2)) continue;
                context.getTrace().report(ErrorsJs.JS_EXTERNAL_INHERITORS_ONLY.on(declaration, parent2, descriptor2));
            }
        }
    }
}

