/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.resolve.BindingContextSlicesJsKt;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.serialization.js.ModuleKind;

public final class JsModuleCheckUtilKt {
    public static final void checkJsModuleUsage(@NotNull BindingContext bindingContext, @NotNull DiagnosticSink diagnosticSink, @NotNull DeclarationDescriptor container, @NotNull DeclarationDescriptor callee, @NotNull PsiElement reportOn) {
        boolean callToNonModule;
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(diagnosticSink, "diagnosticSink");
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(callee, "callee");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        ModuleDescriptor moduleDescriptor = DescriptorUtils.getContainingModule(container);
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getContainingModule(...)");
        ModuleDescriptor module2 = moduleDescriptor;
        ModuleKind moduleKind = (ModuleKind)((Object)bindingContext.get(BindingContextSlicesJsKt.MODULE_KIND, module2));
        if (moduleKind == null) {
            return;
        }
        ModuleKind moduleKind2 = moduleKind;
        DeclarationDescriptor calleeRootContainer = JsModuleCheckUtilKt.findRoot(callee);
        boolean callToModule = AnnotationsUtils.getModuleName(calleeRootContainer) != null || AnnotationsUtils.getFileModuleName(bindingContext, calleeRootContainer) != null;
        boolean bl = callToNonModule = AnnotationsUtils.isNonModule(calleeRootContainer) || AnnotationsUtils.isFromNonModuleFile(bindingContext, calleeRootContainer);
        if (moduleKind2 == ModuleKind.UMD) {
            if (!callToNonModule && callToModule || callToNonModule && !callToModule) {
                diagnosticSink.report(ErrorsJs.CALL_FROM_UMD_MUST_BE_JS_MODULE_AND_JS_NON_MODULE.on(reportOn));
            }
        } else if (moduleKind2 == ModuleKind.PLAIN) {
            if (!callToNonModule && callToModule) {
                diagnosticSink.report(ErrorsJs.CALL_TO_JS_MODULE_WITHOUT_MODULE_SYSTEM.on(reportOn, JsModuleCheckUtilKt.normalizeDescriptor(callee)));
            }
        } else if (!callToModule && callToNonModule) {
            diagnosticSink.report(ErrorsJs.CALL_TO_JS_NON_MODULE_WITH_MODULE_SYSTEM.on(reportOn, JsModuleCheckUtilKt.normalizeDescriptor(callee)));
        }
    }

    private static final DeclarationDescriptor normalizeDescriptor(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof FakeCallableDescriptorForObject) {
            return ((FakeCallableDescriptorForObject)descriptor2).getClassDescriptor();
        }
        return descriptor2;
    }

    private static final DeclarationDescriptor findRoot(DeclarationDescriptor callee) {
        return SequencesKt.last(SequencesKt.takeWhile(SequencesKt.generateSequence(callee, JsModuleCheckUtilKt::findRoot$lambda$0), JsModuleCheckUtilKt::findRoot$lambda$1));
    }

    private static final DeclarationDescriptor findRoot$lambda$0(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getContainingDeclaration();
    }

    private static final boolean findRoot$lambda$1(DeclarationDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !(it instanceof PackageFragmentDescriptor);
    }
}

