/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ClassLiteralChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleClassLiteralChecker;", "Lorg/jetbrains/kotlin/types/expressions/ClassLiteralChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)V"})
public final class JsModuleClassLiteralChecker
implements ClassLiteralChecker {
    @NotNull
    public static final JsModuleClassLiteralChecker INSTANCE = new JsModuleClassLiteralChecker();

    private JsModuleClassLiteralChecker() {
    }

    @Override
    public void check(@NotNull KtClassLiteralExpression expression, @NotNull KotlinType type2, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context, "context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        BindingContext bindingContext = context.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, bindingTrace, context.scope.getOwnerDescriptor(), descriptor2, expression);
    }
}

