/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiExpressionInformation;
import org.jetbrains.kotlin.resolve.calls.checkers.RttiOperation;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.ClassLiteralChecker;

public final class JsNativeRttiChecker
implements RttiExpressionChecker,
ClassLiteralChecker {
    @Override
    public void check(@NotNull RttiExpressionInformation rttiInformation, @NotNull PsiElement reportOn, @NotNull BindingTrace trace) {
        ClassifierDescriptor targetDescriptor;
        Intrinsics.checkNotNullParameter(rttiInformation, "rttiInformation");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(trace, "trace");
        KotlinType sourceType = rttiInformation.getSourceType();
        KotlinType targetType = rttiInformation.getTargetType();
        Object object = targetType;
        ClassifierDescriptor classifierDescriptor = object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : (targetDescriptor = null);
        if (sourceType != null && targetDescriptor != null && AnnotationsUtils.isNativeInterface(targetDescriptor)) {
            switch (WhenMappings.$EnumSwitchMapping$0[rttiInformation.getOperation().ordinal()]) {
                case 1: 
                case 2: {
                    trace.report(ErrorsJs.CANNOT_CHECK_FOR_EXTERNAL_INTERFACE.on(reportOn, targetType));
                    break;
                }
                case 3: 
                case 4: {
                    trace.report(ErrorsJs.UNCHECKED_CAST_TO_EXTERNAL_INTERFACE.on(reportOn, sourceType, targetType));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Override
    public void check(@NotNull KtClassLiteralExpression expression, @NotNull KotlinType type2, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context, "context");
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor descriptor2 = classDescriptor;
        if (AnnotationsUtils.isNativeInterface(descriptor2)) {
            context.trace.report(ErrorsJs.EXTERNAL_INTERFACE_AS_CLASS_LITERAL.on(expression));
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RttiOperation.values().length];
            try {
                nArray[RttiOperation.IS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RttiOperation.NOT_IS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RttiOperation.AS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RttiOperation.SAFE_AS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

