/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0019\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser;", "Lcom/intellij/lang/PsiParser;", "<init>", "()V", "Lcom/intellij/psi/tree/IElementType;", "root", "Lcom/intellij/lang/PsiBuilder;", "builder", "Lcom/intellij/lang/ASTNode;", "parse", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/lang/PsiBuilder;)Lcom/intellij/lang/ASTNode;", "", "parseQualifiedName", "(Lcom/intellij/lang/PsiBuilder;)V", "tokenType", "", "isName", "(Lcom/intellij/psi/tree/IElementType;)Z", "Companion"})
public final class KDocLinkParser
implements PsiParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder2) {
        Intrinsics.checkNotNullParameter(root, "root");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        PsiBuilder.Marker marker = builder2.mark();
        Intrinsics.checkNotNullExpressionValue(marker, "mark(...)");
        PsiBuilder.Marker rootMarker = marker;
        boolean hasLBracket = Intrinsics.areEqual(builder2.getTokenType(), KtTokens.LBRACKET);
        if (hasLBracket) {
            builder2.advanceLexer();
        }
        this.parseQualifiedName(builder2);
        if (hasLBracket) {
            if (!builder2.eof() && !Intrinsics.areEqual(builder2.getTokenType(), KtTokens.RBRACKET)) {
                builder2.error("Closing bracket expected");
                while (!builder2.eof() && !Intrinsics.areEqual(builder2.getTokenType(), KtTokens.RBRACKET)) {
                    builder2.advanceLexer();
                }
            }
            if (Intrinsics.areEqual(builder2.getTokenType(), KtTokens.RBRACKET)) {
                builder2.advanceLexer();
            }
        } else if (!builder2.eof()) {
            builder2.error("Expression expected");
            while (!builder2.eof()) {
                builder2.advanceLexer();
            }
        }
        rootMarker.done(root);
        ASTNode aSTNode = builder2.getTreeBuilt();
        Intrinsics.checkNotNullExpressionValue(aSTNode, "getTreeBuilt(...)");
        return aSTNode;
    }

    private final void parseQualifiedName(PsiBuilder builder2) {
        PsiBuilder.Marker marker = builder2.mark();
        Intrinsics.checkNotNullExpressionValue(marker, "mark(...)");
        PsiBuilder.Marker marker2 = marker;
        while (true) {
            if (!this.isName(builder2.getTokenType())) {
                marker2.drop();
                builder2.error("Identifier expected");
                break;
            }
            builder2.advanceLexer();
            marker2.done(KDocElementTypes.KDOC_NAME);
            if (!Intrinsics.areEqual(builder2.getTokenType(), KtTokens.DOT)) break;
            Intrinsics.checkNotNullExpressionValue(marker2.precede(), "precede(...)");
            builder2.advanceLexer();
        }
    }

    private final boolean isName(IElementType tokenType) {
        return Intrinsics.areEqual(tokenType, KtTokens.IDENTIFIER) || KtTokens.KEYWORDS.contains(tokenType);
    }

    @NotNull
    public static final ASTNode parseMarkdownLink(@NotNull IElementType root, @NotNull ASTNode chameleon) {
        return Companion.parseMarkdownLink(root, chameleon);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/kdoc/parser/KDocLinkParser$Companion;", "", "<init>", "()V", "Lcom/intellij/psi/tree/IElementType;", "root", "Lcom/intellij/lang/ASTNode;", "chameleon", "parseMarkdownLink", "(Lcom/intellij/psi/tree/IElementType;Lcom/intellij/lang/ASTNode;)Lcom/intellij/lang/ASTNode;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ASTNode parseMarkdownLink(@NotNull IElementType root, @NotNull ASTNode chameleon) {
            Intrinsics.checkNotNullParameter(root, "root");
            Intrinsics.checkNotNullParameter(chameleon, "chameleon");
            PsiElement parentElement = chameleon.getTreeParent().getPsi();
            Project project = parentElement.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            Project project2 = project;
            PsiBuilder psiBuilder = PsiBuilderFactory.getInstance().createBuilder(project2, chameleon, (Lexer)new KotlinLexer(), root.getLanguage(), (CharSequence)chameleon.getText());
            Intrinsics.checkNotNullExpressionValue(psiBuilder, "createBuilder(...)");
            PsiBuilder builder2 = psiBuilder;
            KDocLinkParser parser = new KDocLinkParser();
            ASTNode aSTNode = parser.parse(root, builder2).getFirstChildNode();
            Intrinsics.checkNotNullExpressionValue(aSTNode, "getFirstChildNode(...)");
            return aSTNode;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

