/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.Language;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0011\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u001cH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u001e\u0010!"}, d2={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocImpl;", "Lcom/intellij/psi/impl/source/tree/LazyParseablePsiElement;", "Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "", "buffer", "<init>", "(Ljava/lang/CharSequence;)V", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "", "toString", "()Ljava/lang/String;", "Lcom/intellij/psi/tree/IElementType;", "getTokenType", "()Lcom/intellij/psi/tree/IElementType;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "getOwner", "()Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "getDefaultSection", "()Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "", "getAllSections", "()Ljava/util/List;", "name", "findSectionByName", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;", "tag", "findSectionByTag", "(Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;)Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "subjectName", "(Lorg/jetbrains/kotlin/kdoc/parser/KDocKnownTag;Ljava/lang/String;)Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;"})
public final class KDocImpl
extends LazyParseablePsiElement
implements KDoc {
    public KDocImpl(@Nullable CharSequence buffer) {
        super(KDocTokens.KDOC, buffer);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        KotlinLanguage kotlinLanguage = KotlinLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(kotlinLanguage, "INSTANCE");
        return kotlinLanguage;
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = this.getNode().getElementType().toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    @Override
    @NotNull
    public IElementType getTokenType() {
        IElementType iElementType = KtTokens.DOC_COMMENT;
        Intrinsics.checkNotNullExpressionValue(iElementType, "DOC_COMMENT");
        return iElementType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KtDeclaration getOwner() {
        void $this$getParentOfType$iv;
        PsiElement psiElement = this;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclaration.class, strict$iv);
    }

    @Override
    @NotNull
    public KDocSection getDefaultSection() {
        PsiElement $this$getChildOfType$iv = this;
        boolean $i$f$getChildOfType = false;
        KDocSection kDocSection = PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KDocSection.class);
        Intrinsics.checkNotNull(kDocSection);
        return kDocSection;
    }

    @Override
    @NotNull
    public List<KDocSection> getAllSections() {
        PsiElement $this$getChildrenOfType$iv = this;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KDocSection.class);
        if (psiElementArray == null) {
            psiElementArray = new KDocSection[0];
        }
        return ArraysKt.toList(psiElementArray);
    }

    @Override
    @Nullable
    public KDocSection findSectionByName(@NotNull String name) {
        PsiElement psiElement;
        block2: {
            Intrinsics.checkNotNullParameter(name, "name");
            PsiElement $this$getChildrenOfType$iv = this;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KDocSection.class);
            if (psiElementArray == null) {
                psiElementArray = new KDocSection[0];
            }
            PsiElement[] $this$firstOrNull$iv = psiElementArray;
            boolean $i$f$firstOrNull = false;
            for (PsiElement element$iv : $this$firstOrNull$iv) {
                KDocSection it = (KDocSection)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), name)) continue;
                psiElement = element$iv;
                break block2;
            }
            psiElement = null;
        }
        return (KDocSection)psiElement;
    }

    @Override
    @Nullable
    public KDocSection findSectionByTag(@NotNull KDocKnownTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, "tag");
        return this.findSectionByName(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(tag.name()));
    }

    @Override
    @Nullable
    public KDocSection findSectionByTag(@NotNull KDocKnownTag tag, @NotNull String subjectName) {
        PsiElement psiElement;
        block2: {
            Intrinsics.checkNotNullParameter((Object)tag, "tag");
            Intrinsics.checkNotNullParameter(subjectName, "subjectName");
            PsiElement $this$getChildrenOfType$iv = this;
            boolean $i$f$getChildrenOfType = false;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KDocSection.class);
            if (psiElementArray == null) {
                psiElementArray = new KDocSection[0];
            }
            PsiElement[] $this$firstOrNull$iv = psiElementArray;
            boolean $i$f$firstOrNull = false;
            for (PsiElement element$iv : $this$firstOrNull$iv) {
                KDocSection it = (KDocSection)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getName(), CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(tag.name())) && Intrinsics.areEqual(it.getSubjectName(), subjectName))) continue;
                psiElement = element$iv;
                break block2;
            }
            psiElement = null;
        }
        return (KDocSection)psiElement;
    }
}

