/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElementImpl;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\f\u001a\u0004\u0018\u00010\u0000H\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "Lorg/jetbrains/kotlin/psi/KtElementImpl;", "Lcom/intellij/lang/ASTNode;", "node", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "getContainingDoc", "()Lorg/jetbrains/kotlin/kdoc/psi/api/KDoc;", "Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "getContainingSection", "()Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocSection;", "getQualifier", "()Lorg/jetbrains/kotlin/kdoc/psi/impl/KDocName;", "Lcom/intellij/openapi/util/TextRange;", "getNameTextRange", "()Lcom/intellij/openapi/util/TextRange;", "", "getNameText", "()Ljava/lang/String;", "", "getQualifiedName", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/name/FqName;", "getQualifiedNameAsFqName", "()Lorg/jetbrains/kotlin/name/FqName;"})
public final class KDocName
extends KtElementImpl {
    public KDocName(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    @NotNull
    public final KDoc getContainingDoc() {
        KDoc kdoc;
        PsiElement $this$getStrictParentOfType$iv = this;
        boolean $i$f$getStrictParentOfType = false;
        KDoc kDoc = kdoc = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KDoc.class, true);
        if (kDoc == null) {
            throw new IllegalStateException("KDocName must be inside a KDoc");
        }
        return kDoc;
    }

    @NotNull
    public final KDocSection getContainingSection() {
        KDocSection kdoc;
        PsiElement $this$getStrictParentOfType$iv = this;
        boolean $i$f$getStrictParentOfType = false;
        KDocSection kDocSection = kdoc = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KDocSection.class, true);
        if (kDocSection == null) {
            throw new IllegalStateException("KDocName must be inside a KDocSection");
        }
        return kDocSection;
    }

    @Nullable
    public final KDocName getQualifier() {
        PsiElement $this$getChildOfType$iv = this;
        boolean $i$f$getChildOfType = false;
        return PsiTreeUtil.getChildOfType($this$getChildOfType$iv, KDocName.class);
    }

    @NotNull
    public final TextRange getNameTextRange() {
        ASTNode dot = this.getNode().findChildByType(KtTokens.DOT);
        TextRange textRange = this.getTextRange();
        ASTNode aSTNode = dot;
        int nameStart = aSTNode != null ? aSTNode.getTextRange().getEndOffset() - textRange.getStartOffset() : 0;
        return new TextRange(nameStart, textRange.getLength());
    }

    @NotNull
    public final String getNameText() {
        String string2 = this.getNameTextRange().substring(this.getText());
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }

    @NotNull
    public final List<String> getQualifiedName() {
        KDocName qualifier = this.getQualifier();
        List<String> nameAsList = CollectionsKt.listOf(this.getNameText());
        KDocName kDocName = qualifier;
        return kDocName != null ? CollectionsKt.plus((Collection)kDocName.getQualifiedName(), (Iterable)nameAsList) : nameAsList;
    }

    @NotNull
    public final FqName getQualifiedNameAsFqName() {
        return FqName.Companion.fromSegments(this.getQualifiedName());
    }
}

