/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b!\n\u0002\u0010 \n\u0002\b\f\b\u0086\b\u0018\u0000 ~2\u00020\u0001:\u0001~B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\fB\u000f\u0012\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\u0019\u0010\u0011\u001a\u0006*\u00020\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001b\u0010\u0016\u001a\u00020\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u000bJ\u0011\u0010\u001b\u001a\u0006*\u00020\u001a0\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u001eJ\u0010\u0010!\u001a\u00020\u0002H\u00c1\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u001a\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\r\u001a\u00020\u0002H\u00c7\u0001\u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0000\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010(\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0004\u00a2\u0006\u0004\b(\u0010\u000bJ\r\u0010*\u001a\u00020)\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020)\u00a2\u0006\u0004\b,\u0010+J\u000f\u0010-\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b-\u0010.J\r\u0010/\u001a\u00020\u0015\u00a2\u0006\u0004\b/\u00100J\r\u00101\u001a\u00020\u0015\u00a2\u0006\u0004\b1\u00100J\u001a\u00103\u001a\u00020)2\b\u00102\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b3\u00104J!\u00107\u001a\u00020\u00152\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001505\u00a2\u0006\u0004\b7\u00108J\u000f\u0010:\u001a\u000209H\u0016\u00a2\u0006\u0004\b:\u0010;J-\u0010B\u001a\u00020A2\b\b\u0002\u0010=\u001a\u00020<2\b\b\u0002\u0010?\u001a\u00020>2\b\b\u0002\u0010@\u001a\u00020>H\u0007\u00a2\u0006\u0004\bB\u0010CJ\u0011\u0010D\u001a\u0006*\u00020\u00020\u0002\u00a2\u0006\u0004\bD\u0010 J\u0011\u0010F\u001a\u0006*\u00020E0E\u00a2\u0006\u0004\bF\u0010GJ!\u0010I\u001a\u00020\u00152\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001505\u00a2\u0006\u0004\bI\u00108J!\u0010J\u001a\u00020\u00152\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001505\u00a2\u0006\u0004\bJ\u00108J\u000f\u0010L\u001a\u00020KH\u0007\u00a2\u0006\u0004\bL\u0010MJ\u0011\u0010N\u001a\u0006*\u00020\u000f0\u000f\u00a2\u0006\u0004\bN\u0010OJ\u0015\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00040PH\u0007\u00a2\u0006\u0004\bQ\u0010RJ\u0015\u0010S\u001a\u00020)2\u0006\u0010$\u001a\u00020\u0000\u00a2\u0006\u0004\bS\u0010TJ\u0015\u0010V\u001a\u00020)2\u0006\u0010U\u001a\u00020\u0000\u00a2\u0006\u0004\bV\u0010TJ\u000f\u0010W\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\bW\u0010XJ\u0019\u0010Y\u001a\u0006*\u00020\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\bY\u0010\u0012J\u001b\u0010Z\u001a\u00020\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013\u00a2\u0006\u0004\bZ\u0010\u0017J\u0015\u0010[\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0004\u00a2\u0006\u0004\b[\u0010\u000bR\u0011\u0010]\u001a\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b\\\u0010.R\u0011\u0010_\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b^\u0010XR\u0011\u0010a\u001a\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b`\u0010.R\u001b\u0010e\u001a\u00020\u00048GX\u0087\u0084\u0002\u00a2\u0006\f\n\u0004\bb\u0010c\u001a\u0004\bd\u0010XR\u0011\u0010g\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bf\u0010+R\u0011\u0010i\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\bh\u0010XR\u0011\u0010l\u001a\u00020\u00018G\u00a2\u0006\u0006\u001a\u0004\bj\u0010kR\u0011\u0010m\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bm\u0010+R\u0011\u0010n\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bn\u0010+R\u0011\u0010o\u001a\u00020)8F\u00a2\u0006\u0006\u001a\u0004\bo\u0010+R\u001a\u0010\r\u001a\u00020\u00028\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\r\u0010p\u001a\u0004\bq\u0010 R\u0017\u0010t\u001a\b\u0012\u0004\u0012\u00020\u00000r8G\u00a2\u0006\u0006\u001a\u0004\bs\u0010RR\u0017\u0010v\u001a\b\u0012\u0004\u0012\u00020\u00000r8G\u00a2\u0006\u0006\u001a\u0004\bu\u0010RR\u0011\u0010\u001d\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\bw\u0010XR\u0017\u0010y\u001a\b\u0012\u0004\u0012\u00020\u00040r8G\u00a2\u0006\u0006\u001a\u0004\bx\u0010RR\u0011\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\bz\u0010XR\u0011\u0010|\u001a\u00020\u00008G\u00a2\u0006\u0006\u001a\u0004\b{\u0010.R\u0011\u0010\n\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b}\u0010X"}, d2={"Lorg/jetbrains/kotlin/konan/file/File;", "", "Ljava/nio/file/Path;", "parent", "", "child", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "(Lorg/jetbrains/kotlin/konan/file/File;Lorg/jetbrains/kotlin/konan/file/File;)V", "path", "(Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "javaPath", "(Ljava/nio/file/Path;)V", "", "bytes", "appendBytes", "([B)Ljava/nio/file/Path;", "", "lines", "", "appendLines", "(Ljava/lang/Iterable;)V", "text", "appendText", "Ljava/io/BufferedReader;", "bufferedReader", "()Ljava/io/BufferedReader;", "name", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/konan/file/File;", "component1$kotlin_util_io", "()Ljava/nio/file/Path;", "component1", "copy", "(Ljava/nio/file/Path;)Lorg/jetbrains/kotlin/konan/file/File;", "destination", "copyTo", "(Lorg/jetbrains/kotlin/konan/file/File;)V", "target", "createAsSymlink", "", "createNew", "()Z", "delete", "deleteOnExit", "()Lorg/jetbrains/kotlin/konan/file/File;", "deleteOnExitRecursively", "()V", "deleteRecursively", "other", "equals", "(Ljava/lang/Object;)Z", "Lkotlin/Function1;", "action", "forEachLine", "(Lkotlin/jvm/functions/Function1;)V", "", "hashCode", "()I", "Ljava/nio/channels/FileChannel$MapMode;", "mode", "", "start", "size", "Ljava/nio/MappedByteBuffer;", "map", "(Ljava/nio/channels/FileChannel$MapMode;JJ)Ljava/nio/MappedByteBuffer;", "mkdirs", "Ljava/io/OutputStream;", "outputStream", "()Ljava/io/OutputStream;", "task", "postorder", "preorder", "Ljava/io/PrintWriter;", "printWriter", "()Ljava/io/PrintWriter;", "readBytes", "()[B", "", "readStrings", "()Ljava/util/List;", "renameTo", "(Lorg/jetbrains/kotlin/konan/file/File;)Z", "another", "startsWith", "toString", "()Ljava/lang/String;", "writeBytes", "writeLines", "writeText", "getAbsoluteFile", "absoluteFile", "getAbsolutePath", "absolutePath", "getCanonicalFile", "canonicalFile", "canonicalPath$delegate", "Lkotlin/Lazy;", "getCanonicalPath", "canonicalPath", "getExists", "exists", "getExtension", "extension", "getFileKey", "()Ljava/lang/Object;", "fileKey", "isAbsolute", "isDirectory", "isFile", "Ljava/nio/file/Path;", "getJavaPath$kotlin_util_io", "", "getListFiles", "listFiles", "getListFilesOrEmpty", "listFilesOrEmpty", "getName", "getNameSegments", "nameSegments", "getParent", "getParentFile", "parentFile", "getPath", "Companion"})
public final class File {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Path javaPath;
    @NotNull
    private final Lazy canonicalPath$delegate;
    private static final String pathSeparator = java.io.File.pathSeparator;
    private static final String separator = java.io.File.separator;
    private static final char separatorChar = java.io.File.separatorChar;

    public File(@NotNull Path javaPath) {
        Intrinsics.checkNotNullParameter(javaPath, "javaPath");
        this.javaPath = javaPath;
        this.canonicalPath$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ File this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final String invoke() {
                return this.this$0.getJavaPath$kotlin_util_io().toFile().getCanonicalPath();
            }
        });
    }

    @NotNull
    public final Path getJavaPath$kotlin_util_io() {
        return this.javaPath;
    }

    public File(@NotNull Path parent2, @NotNull String child) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(child, "child");
        Path path = parent2.resolve(child);
        Intrinsics.checkNotNullExpressionValue(path, "parent.resolve(child)");
        this(path);
    }

    public File(@NotNull File parent2, @NotNull String child) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(child, "child");
        Path path = parent2.javaPath.resolve(child);
        Intrinsics.checkNotNullExpressionValue(path, "parent.javaPath.resolve(child)");
        this(path);
    }

    public File(@NotNull File parent2, @NotNull File child) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(child, "child");
        Path path = parent2.javaPath.resolve(child.javaPath);
        Intrinsics.checkNotNullExpressionValue(path, "parent.javaPath.resolve(child.javaPath)");
        this(path);
    }

    public File(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue(path2, "get(path)");
        this(path2);
    }

    public File(@NotNull String parent2, @NotNull String child) {
        Intrinsics.checkNotNullParameter(parent2, "parent");
        Intrinsics.checkNotNullParameter(child, "child");
        String[] stringArray = new String[]{child};
        Path path = Paths.get(parent2, stringArray);
        Intrinsics.checkNotNullExpressionValue(path, "get(parent, child)");
        this(path);
    }

    @NotNull
    public final String getPath() {
        return ((Object)this.javaPath).toString();
    }

    @NotNull
    public final String getAbsolutePath() {
        return ((Object)this.javaPath.toAbsolutePath()).toString();
    }

    @NotNull
    public final File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    @NotNull
    public final String getCanonicalPath() {
        Lazy lazy = this.canonicalPath$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-canonicalPath>(...)");
        return (String)t;
    }

    @NotNull
    public final File getCanonicalFile() {
        return new File(this.getCanonicalPath());
    }

    @NotNull
    public final String getName() {
        String string2 = ((Object)this.javaPath.getFileName()).toString();
        String string3 = separator;
        Intrinsics.checkNotNullExpressionValue(string3, "separator");
        return UtilKt.removeSuffixIfPresent(string2, string3);
    }

    @NotNull
    public final String getExtension() {
        return StringsKt.substringAfterLast(this.getName(), '.', "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getNameSegments() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.javaPath;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)it.getFileName()).toString());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getParent() {
        return ((Object)this.javaPath.getParent()).toString();
    }

    @NotNull
    public final File getParentFile() {
        Path path = this.javaPath.getParent();
        Intrinsics.checkNotNullExpressionValue(path, "javaPath.parent");
        return new File(path);
    }

    public final boolean getExists() {
        return Files.exists(this.javaPath, new LinkOption[0]);
    }

    public final boolean isDirectory() {
        return Files.isDirectory(this.javaPath, new LinkOption[0]);
    }

    public final boolean isFile() {
        return Files.isRegularFile(this.javaPath, new LinkOption[0]);
    }

    public final boolean isAbsolute() {
        return this.javaPath.isAbsolute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getListFiles() {
        Iterable stream;
        AutoCloseable $this$use$iv = Files.newDirectoryStream(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            void $this$mapTo$iv$iv;
            stream = (DirectoryStream)$this$use$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(stream, "stream");
            Iterable $this$map$iv = stream;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                Path path = (Path)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                boolean $i$f$_get_listFiles_$lambda$1$stub_for_inlining = false;
                collection.add(new File((Path)p0));
            }
            stream = (List)destination$iv$iv;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
        return stream;
    }

    @NotNull
    public final List<File> getListFilesOrEmpty() {
        return this.getExists() ? this.getListFiles() : CollectionsKt.emptyList();
    }

    @NotNull
    public final Object getFileKey() {
        Object key = Files.readAttributes(this.javaPath, BasicFileAttributes.class, new LinkOption[0]).fileKey();
        if (key == null) {
            key = this.getCanonicalPath();
        }
        Object object = key;
        Intrinsics.checkNotNullExpressionValue(object, "key");
        return object;
    }

    @NotNull
    public final File child(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new File(this, name);
    }

    public final boolean startsWith(@NotNull File another) {
        Intrinsics.checkNotNullParameter(another, "another");
        return this.javaPath.startsWith(another.javaPath);
    }

    public final void copyTo(@NotNull File destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
        Files.copy(this.javaPath, destination.javaPath, copyOptionArray);
    }

    public final boolean renameTo(@NotNull File destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        return this.javaPath.toFile().renameTo(destination.javaPath.toFile());
    }

    public final Path mkdirs() {
        return Files.createDirectories(this.javaPath, new FileAttribute[0]);
    }

    public final boolean delete() {
        return Files.deleteIfExists(this.javaPath);
    }

    public final void deleteRecursively() {
        this.postorder(deleteRecursively.1.INSTANCE);
    }

    public final void deleteOnExitRecursively() {
        this.preorder(deleteOnExitRecursively.1.INSTANCE);
    }

    public final void preorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkNotNullParameter(task, "task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1<Path, Unit> $task;
            {
                this.$task = $task;
            }

            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                Path path = file2;
                Intrinsics.checkNotNull(path);
                this.$task.invoke(path);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir2, BasicFileAttributes attrs) {
                Path path = dir2;
                Intrinsics.checkNotNull(path);
                this.$task.invoke(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public final void postorder(@NotNull Function1<? super Path, Unit> task) {
        Intrinsics.checkNotNullParameter(task, "task");
        if (!this.getExists()) {
            return;
        }
        Files.walkFileTree(this.javaPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(task){
            final /* synthetic */ Function1<Path, Unit> $task;
            {
                this.$task = $task;
            }

            public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) {
                Path path = file2;
                Intrinsics.checkNotNull(path);
                this.$task.invoke(path);
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult postVisitDirectory(Path dir2, IOException exc) {
                Path path = dir2;
                Intrinsics.checkNotNull(path);
                this.$task.invoke(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    @NotNull
    public final MappedByteBuffer map(@NotNull FileChannel.MapMode mode, long start, long size) {
        MappedByteBuffer mappedByteBuffer;
        long l;
        Intrinsics.checkNotNullParameter(mode, "mode");
        RandomAccessFile file2 = new RandomAccessFile(this.getPath(), Intrinsics.areEqual(mode, FileChannel.MapMode.READ_ONLY) ? "r" : "rw");
        if (Intrinsics.areEqual(mode, FileChannel.MapMode.READ_ONLY)) {
            l = file2.length();
        } else {
            boolean bl;
            long l2;
            long it = l2 = size;
            boolean bl2 = false;
            boolean bl3 = bl = size != -1L;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            l = l2;
        }
        long fileSize = l;
        FileChannel channel = file2.getChannel();
        MappedByteBuffer it = mappedByteBuffer = channel.map(mode, start, fileSize);
        boolean bl = false;
        channel.close();
        MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
        Intrinsics.checkNotNullExpressionValue(mappedByteBuffer2, "channel.map(mode, start,\u2026.also { channel.close() }");
        return mappedByteBuffer2;
    }

    public static /* synthetic */ MappedByteBuffer map$default(File file2, FileChannel.MapMode mapMode, long l, long l2, int n, Object object) {
        if ((n & 1) != 0) {
            FileChannel.MapMode mapMode2 = FileChannel.MapMode.READ_ONLY;
            Intrinsics.checkNotNullExpressionValue(mapMode2, "READ_ONLY");
            mapMode = mapMode2;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = -1L;
        }
        return file2.map(mapMode, l, l2);
    }

    @NotNull
    public final File deleteOnExit() {
        this.javaPath.toFile().deleteOnExit();
        return this;
    }

    public final boolean createNew() {
        return this.javaPath.toFile().createNewFile();
    }

    public final byte[] readBytes() {
        return Files.readAllBytes(this.javaPath);
    }

    public final Path writeBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        return Files.write(this.javaPath, bytes, new OpenOption[0]);
    }

    public final Path appendBytes(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        return Files.write(this.javaPath, bytes, openOptionArray);
    }

    public final void writeLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        Files.write(this.javaPath, lines, new OpenOption[0]);
    }

    public final void writeText(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.writeLines((Iterable<String>)CollectionsKt.listOf(text));
    }

    public final void appendLines(@NotNull Iterable<String> lines) {
        Intrinsics.checkNotNullParameter(lines, "lines");
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.APPEND};
        Files.write(this.javaPath, lines, openOptionArray);
    }

    public final void appendText(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.appendLines((Iterable<String>)CollectionsKt.listOf(text));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachLine(@NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(action, "action");
        AutoCloseable $this$use$iv = Files.lines(this.javaPath);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            Object lines = (Stream)$this$use$iv;
            boolean bl = false;
            lines.forEach(new Consumer(action){
                final /* synthetic */ Function1<String, Unit> $action;
                {
                    this.$action = $action;
                }

                public final void accept(String it) {
                    Intrinsics.checkNotNullExpressionValue(it, "it");
                    this.$action.invoke(it);
                }
            });
            lines = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    AutoCloseable autoCloseable = $this$use$iv;
                    if (autoCloseable != null) {
                        autoCloseable.close();
                    }
                }
                throw throwable;
            }
        }
        AutoCloseable autoCloseable = $this$use$iv;
        if (autoCloseable != null) {
            autoCloseable.close();
        }
    }

    public final void createAsSymlink(@NotNull String target) {
        Intrinsics.checkNotNullParameter(target, "target");
        Path targetPath = Paths.get(target, new String[0]);
        if (Files.isSymbolicLink(this.javaPath) && Intrinsics.areEqual(Files.readSymbolicLink(this.javaPath), targetPath)) {
            return;
        }
        Files.createSymbolicLink(this.javaPath, targetPath, new FileAttribute[0]);
    }

    @NotNull
    public String toString() {
        return this.getPath();
    }

    public final BufferedReader bufferedReader() {
        return Files.newBufferedReader(this.javaPath);
    }

    public final OutputStream outputStream() {
        return Files.newOutputStream(this.javaPath, new OpenOption[0]);
    }

    @NotNull
    public final PrintWriter printWriter() {
        java.io.File file2 = this.javaPath.toFile();
        Intrinsics.checkNotNullExpressionValue(file2, "javaPath.toFile()");
        java.io.File file3 = file2;
        Charset charset = Charsets.UTF_8;
        java.io.File file4 = file3;
        int n = 8192;
        Object object = file4;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((java.io.File)object), charset);
        return new PrintWriter(object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n));
    }

    @NotNull
    public final List<String> readStrings() {
        List list;
        List list2 = list = (List)new ArrayList();
        boolean bl = false;
        this.forEachLine((Function1<? super String, Unit>)new Function1<String, Unit>((List<String>)list2){
            final /* synthetic */ List<String> $list;
            {
                this.$list = $list;
                super(1);
            }

            public final void invoke(String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.$list.add(it);
            }
        });
        return list;
    }

    public boolean equals(@Nullable Object other) {
        File file2 = other instanceof File ? (File)other : null;
        if (file2 == null) {
            return false;
        }
        File otherFile = file2;
        return Intrinsics.areEqual(otherFile.javaPath.toAbsolutePath(), this.javaPath.toAbsolutePath());
    }

    public int hashCode() {
        return ((Object)this.javaPath.toAbsolutePath()).hashCode();
    }

    @NotNull
    public final Path component1$kotlin_util_io() {
        return this.javaPath;
    }

    @NotNull
    public final File copy(@NotNull Path javaPath) {
        Intrinsics.checkNotNullParameter(javaPath, "javaPath");
        return new File(javaPath);
    }

    public static /* synthetic */ File copy$default(File file2, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = file2.javaPath;
        }
        return file2.copy(path);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\f\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0007\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u0006*\u00020\b0\b8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u0006*\u00020\b0\b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0015\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/konan/file/File$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/konan/file/File;", "getJavaHome", "()Lorg/jetbrains/kotlin/konan/file/File;", "javaHome", "", "pathSeparator", "Ljava/lang/String;", "getPathSeparator", "()Ljava/lang/String;", "separator", "getSeparator", "", "separatorChar", "C", "getSeparatorChar", "()C", "getUserDir", "userDir", "getUserHome", "userHome"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getUserDir() {
            String string2 = System.getProperty("user.dir");
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(\"user.dir\")");
            return new File(string2);
        }

        @NotNull
        public final File getUserHome() {
            String string2 = System.getProperty("user.home");
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(\"user.home\")");
            return new File(string2);
        }

        @NotNull
        public final File getJavaHome() {
            String string2 = System.getProperty("java.home");
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(\"java.home\")");
            return new File(string2);
        }

        public final String getPathSeparator() {
            return pathSeparator;
        }

        public final String getSeparator() {
            return separator;
        }

        public final char getSeparatorChar() {
            return separatorChar;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

