/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.library.BaseKotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;
import org.jetbrains.kotlin.library.KotlinLibrarySearchPathResolver;
import org.jetbrains.kotlin.library.LenientUnresolvedLibrary;
import org.jetbrains.kotlin.library.RequiredUnresolvedLibrary;
import org.jetbrains.kotlin.library.SearchPathResolver;
import org.jetbrains.kotlin.library.SearchPathResolverKt;
import org.jetbrains.kotlin.library.UnresolvedLibrary;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001JB-\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010.\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010/\u001a\u00020\t2\u0006\u00100\u001a\u00020\t2\u0006\u00101\u001a\u00020\tH\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u000e032\u0006\u00104\u001a\u00020\u0006H\u0002J \u00105\u001a\b\u0012\u0004\u0012\u00028\u0000032\u0006\u00106\u001a\u00020\u000e2\b\b\u0002\u00107\u001a\u00020\u0006H\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020\tH&J\u001d\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00028\u00002\u0006\u0010=\u001a\u00020$H\u0016\u00a2\u0006\u0002\u0010>J\u0016\u0010?\u001a\b\u0012\u0004\u0012\u00020\u000e032\u0006\u0010@\u001a\u00020\u0006H\u0016J\u0015\u0010A\u001a\u00028\u00002\u0006\u0010@\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010BJ\u001f\u0010A\u001a\u0004\u0018\u00018\u00002\u0006\u0010=\u001a\u00020C2\u0006\u0010D\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010EJ\u001d\u0010A\u001a\u00028\u00002\u0006\u0010=\u001a\u00020F2\u0006\u0010D\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010GJ\u001f\u0010H\u001a\u0004\u0018\u00018\u00002\u0006\u0010=\u001a\u00020$2\u0006\u0010D\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010IR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R'\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0010R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R>\u0010\"\u001a2\u0012\u0004\u0012\u00020$\u0012\u000e\u0012\f0%R\b\u0012\u0004\u0012\u00028\u00000\u00000#j\u0018\u0012\u0004\u0012\u00020$\u0012\u000e\u0012\f0%R\b\u0012\u0004\u0012\u00028\u00000\u0000`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\u0019\u001a\u0004\b)\u0010\u0013R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010+\u001a\u00020\u000e*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;", "L", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/SearchPathResolver;", "directLibs", "", "", "distributionKlib", "skipCurrentDir", "", "logger", "Lorg/jetbrains/kotlin/util/Logger;", "(Ljava/util/List;Ljava/lang/String;ZLorg/jetbrains/kotlin/util/Logger;)V", "currentDirHead", "Lorg/jetbrains/kotlin/konan/file/File;", "getCurrentDirHead", "()Lorg/jetbrains/kotlin/konan/file/File;", "defaultRoots", "getDefaultRoots", "()Ljava/util/List;", "directLibraryUniqueNames", "", "getDirectLibraryUniqueNames", "()Ljava/util/Map;", "directLibraryUniqueNames$delegate", "Lkotlin/Lazy;", "distHead", "getDistHead", "distPlatformHead", "getDistPlatformHead", "getDistributionKlib", "()Ljava/lang/String;", "getLogger", "()Lorg/jetbrains/kotlin/util/Logger;", "resolvedLibraries", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/library/UnresolvedLibrary;", "Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver$ResolvedLibrary;", "Lkotlin/collections/HashMap;", "searchRoots", "Lorg/jetbrains/kotlin/library/SearchPathResolver$SearchRoot;", "getSearchRoots", "searchRoots$delegate", "klib", "getKlib", "(Lorg/jetbrains/kotlin/konan/file/File;)Lorg/jetbrains/kotlin/konan/file/File;", "defaultLinks", "noStdLib", "noDefaultLibs", "noEndorsedLibs", "directLibsSequence", "Lkotlin/sequences/Sequence;", "givenName", "getDefaultLibrariesFromDir", "directory", "prefix", "libraryComponentBuilder", "file", "isDefault", "libraryMatch", "candidate", "unresolved", "(Lorg/jetbrains/kotlin/library/KotlinLibrary;Lorg/jetbrains/kotlin/library/UnresolvedLibrary;)Z", "resolutionSequence", "givenPath", "resolve", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/LenientUnresolvedLibrary;", "isDefaultLink", "(Lorg/jetbrains/kotlin/library/LenientUnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "Lorg/jetbrains/kotlin/library/RequiredUnresolvedLibrary;", "(Lorg/jetbrains/kotlin/library/RequiredUnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "resolveOrNull", "(Lorg/jetbrains/kotlin/library/UnresolvedLibrary;Z)Lorg/jetbrains/kotlin/library/KotlinLibrary;", "ResolvedLibrary", "kotlin-util-klib"})
public abstract class KotlinLibrarySearchPathResolver<L extends KotlinLibrary>
implements SearchPathResolver<L> {
    @Nullable
    private final String distributionKlib;
    private final boolean skipCurrentDir;
    @NotNull
    private final Logger logger;
    @Nullable
    private final File distPlatformHead;
    @NotNull
    private final Lazy directLibraryUniqueNames$delegate;
    @NotNull
    private final Lazy searchRoots$delegate;
    @NotNull
    private final HashMap<UnresolvedLibrary, ResolvedLibrary> resolvedLibraries;

    public KotlinLibrarySearchPathResolver(@NotNull List<String> directLibs, @Nullable String distributionKlib, boolean skipCurrentDir, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(directLibs, "directLibs");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.distributionKlib = distributionKlib;
        this.skipCurrentDir = skipCurrentDir;
        this.logger = logger;
        this.directLibraryUniqueNames$delegate = LazyKt.lazy((Function0)new Function0<HashMap<String, File>>(directLibs, this){
            final /* synthetic */ List<String> $directLibs;
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.$directLibs = $directLibs;
                this.this$0 = $receiver;
                super(0);
            }

            public final HashMap<String, File> invoke() {
                HashMap<String, File> hashMap = new HashMap<String, File>();
                List<String> list = this.$directLibs;
                KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                HashMap<String, File> $this$invoke_u24lambda_u240 = hashMap;
                boolean bl = false;
                for (String directLib : list) {
                    File absolutePath;
                    Object object;
                    if (SearchPathResolver.SearchRoot.Companion.lookUpByAbsolutePath(new File(directLib)) == null || (object = (KotlinLibrary)CollectionsKt.singleOrNull(kotlinLibrarySearchPathResolver.libraryComponentBuilder(absolutePath, false))) == null || (object = KotlinLibraryKt.getUniqueName((BaseKotlinLibrary)object)) == null) continue;
                    Object uniqueName = object;
                    ((Map)$this$invoke_u24lambda_u240).put(uniqueName, absolutePath);
                }
                return hashMap;
            }
        });
        this.searchRoots$delegate = LazyKt.lazy((Function0)new Function0<List<? extends SearchPathResolver.SearchRoot>>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<SearchPathResolver.SearchRoot> invoke() {
                SearchPathResolver.SearchRoot searchRoot;
                SearchPathResolver.SearchRoot searchRoot2;
                SearchPathResolver.SearchRoot searchRoot3;
                File it;
                List searchRoots2 = new ArrayList<E>();
                Collection collection = searchRoots2;
                File file2 = KotlinLibrarySearchPathResolver.access$getCurrentDirHead(this.this$0);
                if (file2 != null) {
                    it = file2;
                    boolean bl = false;
                    searchRoot3 = new SearchPathResolver.SearchRoot(it, true);
                } else {
                    searchRoot3 = null;
                }
                collection.add(searchRoot3);
                collection = searchRoots2;
                File file3 = KotlinLibrarySearchPathResolver.access$getDistHead(this.this$0);
                if (file3 != null) {
                    it = file3;
                    boolean bl = false;
                    searchRoot2 = new SearchPathResolver.SearchRoot(it, false, 2, null);
                } else {
                    searchRoot2 = null;
                }
                collection.add(searchRoot2);
                collection = searchRoots2;
                File file4 = this.this$0.getDistPlatformHead();
                if (file4 != null) {
                    it = file4;
                    boolean bl = false;
                    searchRoot = new SearchPathResolver.SearchRoot(it, false, 2, null);
                } else {
                    searchRoot = null;
                }
                collection.add(searchRoot);
                return CollectionsKt.filterNotNull(searchRoots2);
            }
        });
        this.resolvedLibraries = new HashMap();
    }

    @Nullable
    public final String getDistributionKlib() {
        return this.distributionKlib;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    private final File getDistHead() {
        Object object = this.distributionKlib;
        return object != null && (object = FileKt.File((String)object)) != null ? ((File)object).child("common") : null;
    }

    @Nullable
    public File getDistPlatformHead() {
        return this.distPlatformHead;
    }

    private final File getCurrentDirHead() {
        return !this.skipCurrentDir ? File.Companion.getUserDir() : null;
    }

    @NotNull
    public abstract List<L> libraryComponentBuilder(@NotNull File var1, boolean var2);

    private final Map<String, File> getDirectLibraryUniqueNames() {
        Lazy lazy = this.directLibraryUniqueNames$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    @NotNull
    public List<SearchPathResolver.SearchRoot> getSearchRoots() {
        Lazy lazy = this.searchRoots$delegate;
        return (List)lazy.getValue();
    }

    private final Sequence<File> directLibsSequence(String givenName) {
        return SequencesKt.generateSequence((Function0)new Function0<File>(this, givenName){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            final /* synthetic */ String $givenName;
            {
                this.this$0 = $receiver;
                this.$givenName = $givenName;
                super(0);
            }

            public final File invoke() {
                return (File)KotlinLibrarySearchPathResolver.access$getDirectLibraryUniqueNames(this.this$0).get(this.$givenName);
            }
        });
    }

    @Override
    @NotNull
    public Sequence<File> resolutionSequence(@NotNull String givenPath) {
        Sequence<File> sequence2;
        Intrinsics.checkNotNullParameter(givenPath, "givenPath");
        File given = SearchPathResolverKt.access$validFileOrNull(givenPath);
        if (given == null) {
            sequence2 = this.directLibsSequence(givenPath);
        } else if (given.isAbsolute()) {
            File[] fileArray = new File[]{SearchPathResolver.SearchRoot.Companion.lookUpByAbsolutePath(given)};
            sequence2 = SequencesKt.sequenceOf(fileArray);
        } else {
            Sequence repoLibs2 = SequencesKt.map(CollectionsKt.asSequence((Iterable)this.getSearchRoots()), (Function1)new Function1<SearchPathResolver.SearchRoot, File>(given){
                final /* synthetic */ File $given;
                {
                    this.$given = $given;
                    super(1);
                }

                public final File invoke(SearchPathResolver.SearchRoot searchRoot) {
                    File file2;
                    Intrinsics.checkNotNullParameter(searchRoot, "searchRoot");
                    SearchPathResolver.LookupResult lookupResult = searchRoot.lookUp(this.$given);
                    if (lookupResult instanceof SearchPathResolver.LookupResult.Found) {
                        file2 = ((SearchPathResolver.LookupResult.Found)lookupResult).getLibrary();
                    } else if (Intrinsics.areEqual(lookupResult, SearchPathResolver.LookupResult.NotFound.INSTANCE)) {
                        file2 = null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return file2;
                }
            });
            sequence2 = SequencesKt.plus(this.directLibsSequence(givenPath), repoLibs2);
        }
        Sequence<File> sequence3 = sequence2;
        return SequencesKt.filterNotNull(sequence3);
    }

    private final L resolveOrNull(UnresolvedLibrary unresolved, boolean isDefaultLink) {
        Object object;
        Map $this$getOrPut$iv = this.resolvedLibraries;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(unresolved);
        if (value$iv == null) {
            ResolvedLibrary resolvedLibrary;
            boolean bl = false;
            String givenPath = unresolved.getPath();
            try {
                KotlinLibrary p0 = (KotlinLibrary)SequencesKt.firstOrNull(SequencesKt.filterNotNull(SequencesKt.map(SequencesKt.flatMap(this.resolutionSequence(givenPath), new Function1<File, Sequence<? extends L>>(this, isDefaultLink){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ boolean $isDefaultLink;
                    {
                        this.this$0 = $receiver;
                        this.$isDefaultLink = $isDefaultLink;
                        super(1);
                    }

                    public final Sequence<L> invoke(File it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return CollectionsKt.asSequence((Iterable)this.this$0.libraryComponentBuilder(it, this.$isDefaultLink));
                    }
                }), new Function1<L, L>(this, unresolved){
                    final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
                    final /* synthetic */ UnresolvedLibrary $unresolved;
                    {
                        this.this$0 = $receiver;
                        this.$unresolved = $unresolved;
                        super(1);
                    }

                    public final L invoke(L it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        L l = it;
                        KotlinLibrarySearchPathResolver<L> kotlinLibrarySearchPathResolver = this.this$0;
                        UnresolvedLibrary unresolvedLibrary = this.$unresolved;
                        L it2 = l;
                        boolean bl = false;
                        return (L)(kotlinLibrarySearchPathResolver.libraryMatch(it2, unresolvedLibrary) ? l : null);
                    }
                })));
                boolean bl2 = false;
                boolean $i$f$resolveOrNull$lambda$0$stub_for_inlining = false;
                resolvedLibrary = new ResolvedLibrary(this, p0);
            }
            catch (Throwable e) {
                this.getLogger().error("KLIB resolver: Failed to resolve Kotlin library: " + givenPath + ", due to " + e.getMessage());
                throw e;
            }
            ResolvedLibrary answer$iv = resolvedLibrary;
            $this$getOrPut$iv.put(unresolved, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((ResolvedLibrary)object).getLibrary();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public L resolve(@NotNull LenientUnresolvedLibrary unresolved, boolean isDefaultLink) {
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        L l = this.resolveOrNull(unresolved, isDefaultLink);
        if (l == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KotlinLibrarySearchPathResolver $this$resolve_u24lambda_u242 = this;
            boolean bl = false;
            Iterable iterable = $this$resolve_u24lambda_u242.getSearchRoots();
            StringBuilder stringBuilder = new StringBuilder().append("KLIB resolver: Could not find \"").append(unresolved.getPath()).append("\" in ");
            Logger logger = $this$resolve_u24lambda_u242.getLogger();
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SearchPathResolver.SearchRoot searchRoot = (SearchPathResolver.SearchRoot)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getSearchRootPath().getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            logger.warning(stringBuilder.append(collection).toString());
            l = null;
        }
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public L resolve(@NotNull RequiredUnresolvedLibrary unresolved, boolean isDefaultLink) {
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        L l = this.resolveOrNull(unresolved, isDefaultLink);
        if (l == null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            KotlinLibrarySearchPathResolver $this$resolve_u24lambda_u244 = this;
            boolean bl = false;
            Iterable iterable = $this$resolve_u24lambda_u244.getSearchRoots();
            StringBuilder stringBuilder = new StringBuilder().append("KLIB resolver: Could not find \"").append(unresolved.getPath()).append("\" in ");
            Logger logger = $this$resolve_u24lambda_u244.getLogger();
            boolean $i$f$map = false;
            void var9_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SearchPathResolver.SearchRoot searchRoot = (SearchPathResolver.SearchRoot)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getSearchRootPath().getAbsolutePath());
            }
            collection = (List)destination$iv$iv;
            logger.fatal(stringBuilder.append(collection).toString());
            throw new KotlinNothingValueException();
        }
        return l;
    }

    @Override
    public boolean libraryMatch(@NotNull L candidate, @NotNull UnresolvedLibrary unresolved) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(unresolved, "unresolved");
        return true;
    }

    @Override
    @NotNull
    public L resolve(@NotNull String givenPath) {
        Intrinsics.checkNotNullParameter(givenPath, "givenPath");
        return this.resolve(new RequiredUnresolvedLibrary(givenPath), false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> getDefaultRoots() {
        void $this$filterTo$iv$iv;
        File[] fileArray = new File[]{this.getDistHead(), this.getDistPlatformHead()};
        Iterable $this$filter$iv = CollectionsKt.listOfNotNull(fileArray);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.getExists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Sequence<L> getDefaultLibrariesFromDir(File directory, String prefix) {
        return directory.getExists() ? SequencesKt.map(SequencesKt.map(SequencesKt.filterNot(SequencesKt.filterNot(SequencesKt.filter(CollectionsKt.asSequence((Iterable)directory.getListFiles()), (Function1)new Function1<File, Boolean>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
                super(1);
            }

            public final Boolean invoke(File it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return StringsKt.startsWith$default(it.getName(), this.$prefix, false, 2, null);
            }
        }), getDefaultLibrariesFromDir.2.INSTANCE), getDefaultLibrariesFromDir.3.INSTANCE), getDefaultLibrariesFromDir.4.INSTANCE), new Function1<RequiredUnresolvedLibrary, L>(this){
            final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final L invoke(RequiredUnresolvedLibrary it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.resolve(it, true);
            }
        }) : SequencesKt.emptySequence();
    }

    static /* synthetic */ Sequence getDefaultLibrariesFromDir$default(KotlinLibrarySearchPathResolver kotlinLibrarySearchPathResolver, File file2, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getDefaultLibrariesFromDir");
        }
        if ((n & 2) != 0) {
            string2 = "org.jetbrains.kotlin";
        }
        return kotlinLibrarySearchPathResolver.getDefaultLibrariesFromDir(file2, string2);
    }

    @Override
    @NotNull
    public List<L> defaultLinks(boolean noStdLib, boolean noDefaultLibs, boolean noEndorsedLibs) {
        List result2;
        block4: {
            File it;
            result2 = new ArrayList();
            if (!noStdLib) {
                result2.add(this.resolve(new RequiredUnresolvedLibrary("stdlib"), true));
            }
            if (!noEndorsedLibs) {
                File file2 = this.getDistHead();
                if (file2 != null) {
                    it = file2;
                    boolean bl = false;
                    CollectionsKt.addAll((Collection)result2, KotlinLibrarySearchPathResolver.getDefaultLibrariesFromDir$default(this, it, null, 2, null));
                }
            }
            if (noDefaultLibs) break block4;
            File file3 = this.getDistPlatformHead();
            if (file3 != null) {
                it = file3;
                boolean bl = false;
                CollectionsKt.addAll((Collection)result2, KotlinLibrarySearchPathResolver.getDefaultLibrariesFromDir$default(this, it, null, 2, null));
            }
        }
        return result2;
    }

    public static final /* synthetic */ Map access$getDirectLibraryUniqueNames(KotlinLibrarySearchPathResolver $this) {
        return $this.getDirectLibraryUniqueNames();
    }

    public static final /* synthetic */ File access$getCurrentDirHead(KotlinLibrarySearchPathResolver $this) {
        return $this.getCurrentDirHead();
    }

    public static final /* synthetic */ File access$getDistHead(KotlinLibrarySearchPathResolver $this) {
        return $this.getDistHead();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00018\u00008\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0002\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007"}, d2={"Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver$ResolvedLibrary;", "", "library", "<init>", "(Lorg/jetbrains/kotlin/library/KotlinLibrarySearchPathResolver;Lorg/jetbrains/kotlin/library/KotlinLibrary;)V", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getLibrary", "()Lorg/jetbrains/kotlin/library/KotlinLibrary;"})
    private static final class ResolvedLibrary {
        @Nullable
        private final L library;
        final /* synthetic */ KotlinLibrarySearchPathResolver<L> this$0;

        public ResolvedLibrary(L library) {
            this.this$0 = this$0;
            this.library = library;
        }

        @Nullable
        public final L getLibrary() {
            return this.library;
        }
    }
}

