/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.konan.file.ZipFileSystemInPlaceAccessor;
import org.jetbrains.kotlin.library.KotlinLibraryLayout;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutImpl;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0003B%\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u000f\u001a\u00028\u0001\"\u0004\b\u0001\u0010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J'\u0010\u0011\u001a\u00028\u0001\"\u0004\b\u0001\u0010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r\u00a2\u0006\u0004\b\u0011\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0018\u001a\u00020\u00178\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/library/impl/BaseLibraryAccess;", "Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "L", "", "Lorg/jetbrains/kotlin/konan/file/File;", "klib", "", "component", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "zipAccessor", "<init>", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;)V", "T", "Lkotlin/Function1;", "action", "inPlace", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "realFiles", "Lorg/jetbrains/kotlin/konan/file/File;", "getKlib", "()Lorg/jetbrains/kotlin/konan/file/File;", "klibZipAccessor", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "layout", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "getLayout", "()Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;"})
public class BaseLibraryAccess<L extends KotlinLibraryLayout> {
    @NotNull
    private final File klib;
    @NotNull
    private final KotlinLibraryLayoutImpl layout;
    @NotNull
    private final ZipFileSystemAccessor klibZipAccessor;

    public BaseLibraryAccess(@NotNull File klib, @Nullable String component, @Nullable ZipFileSystemAccessor zipAccessor) {
        Intrinsics.checkNotNullParameter(klib, "klib");
        this.klib = klib;
        this.layout = new KotlinLibraryLayoutImpl(this.klib, component);
        ZipFileSystemAccessor zipFileSystemAccessor = zipAccessor;
        if (zipFileSystemAccessor == null) {
            zipFileSystemAccessor = ZipFileSystemInPlaceAccessor.INSTANCE;
        }
        this.klibZipAccessor = zipFileSystemAccessor;
    }

    public /* synthetic */ BaseLibraryAccess(File file2, String string2, ZipFileSystemAccessor zipFileSystemAccessor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            zipFileSystemAccessor = null;
        }
        this(file2, string2, zipFileSystemAccessor);
    }

    @NotNull
    public final File getKlib() {
        return this.klib;
    }

    @NotNull
    public KotlinLibraryLayoutImpl getLayout() {
        return this.layout;
    }

    public final <T> T realFiles(@NotNull Function1<? super L, ? extends T> action) {
        T t;
        Intrinsics.checkNotNullParameter(action, "action");
        if (this.getLayout().isZipped()) {
            KotlinLibraryLayout kotlinLibraryLayout = this.getLayout().getExtractingToTemp();
            Intrinsics.checkNotNull(kotlinLibraryLayout, "null cannot be cast to non-null type L of org.jetbrains.kotlin.library.impl.BaseLibraryAccess");
            t = action.invoke(kotlinLibraryLayout);
        } else {
            KotlinLibraryLayoutImpl kotlinLibraryLayoutImpl = this.getLayout();
            Intrinsics.checkNotNull(kotlinLibraryLayoutImpl, "null cannot be cast to non-null type L of org.jetbrains.kotlin.library.impl.BaseLibraryAccess");
            t = action.invoke((KotlinLibraryLayout)kotlinLibraryLayoutImpl);
        }
        return t;
    }

    public final <T> T inPlace(@NotNull Function1<? super L, ? extends T> action) {
        T t;
        Intrinsics.checkNotNullParameter(action, "action");
        if (this.getLayout().isZipped()) {
            t = this.klibZipAccessor.withZipFileSystem(this.getLayout().getKlib(), new Function1<FileSystem, T>(action, this){
                final /* synthetic */ Function1<L, T> $action;
                final /* synthetic */ BaseLibraryAccess<L> this$0;
                {
                    this.$action = $action;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final T invoke(FileSystem zipFileSystem) {
                    Intrinsics.checkNotNullParameter(zipFileSystem, "zipFileSystem");
                    KotlinLibraryLayout kotlinLibraryLayout = this.this$0.getLayout().directlyFromZip(zipFileSystem);
                    Intrinsics.checkNotNull(kotlinLibraryLayout, "null cannot be cast to non-null type L of org.jetbrains.kotlin.library.impl.BaseLibraryAccess");
                    return this.$action.invoke(kotlinLibraryLayout);
                }
            });
        } else {
            KotlinLibraryLayoutImpl kotlinLibraryLayoutImpl = this.getLayout();
            Intrinsics.checkNotNull(kotlinLibraryLayoutImpl, "null cannot be cast to non-null type L of org.jetbrains.kotlin.library.impl.BaseLibraryAccess");
            t = action.invoke((KotlinLibraryLayout)kotlinLibraryLayoutImpl);
        }
        return t;
    }
}

