/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.nio.file.FileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.library.KotlinLibraryLayout;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutImpl;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\t\u001a\u0004\u0018\u00010\b8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\r8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\b8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0013\u0010\f"}, d2={"Lorg/jetbrains/kotlin/library/impl/FromZipBaseLibraryImpl;", "Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "zipped", "Ljava/nio/file/FileSystem;", "zipFileSystem", "<init>", "(Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;Ljava/nio/file/FileSystem;)V", "", "component", "Ljava/lang/String;", "getComponent", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/konan/file/File;", "libFile", "Lorg/jetbrains/kotlin/konan/file/File;", "getLibFile", "()Lorg/jetbrains/kotlin/konan/file/File;", "libraryName", "getLibraryName"})
public class FromZipBaseLibraryImpl
implements KotlinLibraryLayout {
    @NotNull
    private final String libraryName;
    @NotNull
    private final File libFile;
    @Nullable
    private final String component;

    public FromZipBaseLibraryImpl(@NotNull KotlinLibraryLayoutImpl zipped, @NotNull FileSystem zipFileSystem) {
        Intrinsics.checkNotNullParameter(zipped, "zipped");
        Intrinsics.checkNotNullParameter(zipFileSystem, "zipFileSystem");
        this.libraryName = zipped.getLibraryName();
        this.libFile = ZipUtilKt.file(zipFileSystem, zipped.getLibFile());
        this.component = zipped.getComponent();
    }

    @Override
    @NotNull
    public String getLibraryName() {
        return this.libraryName;
    }

    @Override
    @NotNull
    public File getLibFile() {
        return this.libFile;
    }

    @Override
    @Nullable
    public String getComponent() {
        return this.component;
    }
}

