/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.ReadBuffer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u0011R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u00138\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrMultiArrayReader;", "", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "buffer", "<init>", "(Lorg/jetbrains/kotlin/library/impl/ReadBuffer;)V", "", "position", "", "readOffsets", "(I)[I", "id", "", "tableItemBytes", "(I)[B", "row", "column", "(II)[B", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "", "indexIndexToOffset", "Ljava/util/Map;", "indexToOffset", "[I"})
public abstract class IrMultiArrayReader {
    @NotNull
    private final ReadBuffer buffer;
    @NotNull
    private final int[] indexToOffset;
    @NotNull
    private final Map<Integer, int[]> indexIndexToOffset;

    public IrMultiArrayReader(@NotNull ReadBuffer buffer) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        this.buffer = buffer;
        this.indexIndexToOffset = new LinkedHashMap();
        this.indexToOffset = this.readOffsets(0);
    }

    private final int[] readOffsets(int position) {
        this.buffer.setPosition(position);
        int count2 = this.buffer.getInt();
        int[] result2 = new int[count2 + 1];
        result2[0] = 4 * (count2 + 1);
        for (int i = 0; i < count2; ++i) {
            int size = this.buffer.getInt();
            result2[i + 1] = result2[i] + size;
        }
        return result2;
    }

    @NotNull
    public final byte[] tableItemBytes(int id) {
        int offset = this.indexToOffset[id];
        int size = this.indexToOffset[id + 1] - offset;
        byte[] result2 = new byte[size];
        this.buffer.setPosition(offset);
        this.buffer.get(result2, 0, size);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] tableItemBytes(int row, int column) {
        Object object;
        void $this$getOrPut$iv;
        int rowOffset = this.indexToOffset[row];
        Map<Integer, int[]> map2 = this.indexIndexToOffset;
        Integer key$iv = row;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            int[] answer$iv = this.readOffsets(rowOffset);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        int[] columnOffsets = (int[])object;
        int dataOffset = columnOffsets[column];
        int dataSize = columnOffsets[column + 1] - dataOffset;
        byte[] result2 = new byte[dataSize];
        this.buffer.setPosition(rowOffset + dataOffset);
        this.buffer.get(result2, 0, dataSize);
        return result2;
    }
}

