/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.ReadBuffer;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00028\u0000H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\rR,\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/library/impl/IrTableReader;", "K", "", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "buffer", "Lkotlin/Function1;", "keyReader", "<init>", "(Lorg/jetbrains/kotlin/library/impl/ReadBuffer;Lkotlin/jvm/functions/Function1;)V", "id", "", "tableItemBytes", "(Ljava/lang/Object;)[B", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "", "Lkotlin/Pair;", "", "indexToOffset", "Ljava/util/Map;"})
public abstract class IrTableReader<K> {
    @NotNull
    private final ReadBuffer buffer;
    @NotNull
    private final Map<K, Pair<Integer, Integer>> indexToOffset;

    public IrTableReader(@NotNull ReadBuffer buffer, @NotNull Function1<? super ReadBuffer, ? extends K> keyReader) {
        Intrinsics.checkNotNullParameter(buffer, "buffer");
        Intrinsics.checkNotNullParameter(keyReader, "keyReader");
        this.buffer = buffer;
        this.indexToOffset = new LinkedHashMap();
        int count2 = this.buffer.getInt();
        for (int i = 0; i < count2; ++i) {
            K key = keyReader.invoke(this.buffer);
            int offset = this.buffer.getInt();
            int size = this.buffer.getInt();
            this.indexToOffset.put(key, TuplesKt.to(offset, size));
        }
    }

    @NotNull
    public final byte[] tableItemBytes(K id) {
        Pair<Integer, Integer> pair = this.indexToOffset.get(id);
        if (pair == null) {
            throw new IllegalStateException(("No coordinates found for " + id).toString());
        }
        Pair<Integer, Integer> coordinates = pair;
        int offset = ((Number)coordinates.getFirst()).intValue();
        int size = ((Number)coordinates.getSecond()).intValue();
        byte[] result2 = new byte[size];
        this.buffer.setPosition(offset);
        this.buffer.get(result2, 0, size);
        return result2;
    }
}

