/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.nio.file.FileSystem;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.library.KotlinLibraryLayout;
import org.jetbrains.kotlin.library.impl.ExtractingBaseLibraryImpl;
import org.jetbrains.kotlin.library.impl.FromZipBaseLibraryImpl;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutImplKt;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0013\u001a\u00020\u00018WX\u0097\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0015\u001a\u00020\u00148\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0015\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0018\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001e\u001a\u00020\u00048WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/library/impl/KotlinLibraryLayoutImpl;", "Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "Lorg/jetbrains/kotlin/konan/file/File;", "klib", "", "component", "<init>", "(Lorg/jetbrains/kotlin/konan/file/File;Ljava/lang/String;)V", "Ljava/nio/file/FileSystem;", "zipFileSystem", "directlyFromZip", "(Ljava/nio/file/FileSystem;)Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "Ljava/lang/String;", "getComponent", "()Ljava/lang/String;", "extractingToTemp$delegate", "Lkotlin/Lazy;", "getExtractingToTemp", "()Lorg/jetbrains/kotlin/library/KotlinLibraryLayout;", "extractingToTemp", "", "isZipped", "Z", "()Z", "Lorg/jetbrains/kotlin/konan/file/File;", "getKlib", "()Lorg/jetbrains/kotlin/konan/file/File;", "libFile", "getLibFile", "getLibraryName", "libraryName"})
public class KotlinLibraryLayoutImpl
implements KotlinLibraryLayout {
    @NotNull
    private final File klib;
    @Nullable
    private final String component;
    private final boolean isZipped;
    @NotNull
    private final File libFile;
    @NotNull
    private final Lazy extractingToTemp$delegate;

    public KotlinLibraryLayoutImpl(@NotNull File klib, @Nullable String component) {
        Intrinsics.checkNotNullParameter(klib, "klib");
        this.klib = klib;
        this.component = component;
        this.isZipped = this.klib.isFile();
        if (this.isZipped) {
            KotlinLibraryLayoutImplKt.zippedKotlinLibraryChecks(this.klib);
        }
        this.libFile = this.isZipped ? new File("/") : this.klib;
        this.extractingToTemp$delegate = LazyKt.lazy((Function0)new Function0<ExtractingBaseLibraryImpl>(this){
            final /* synthetic */ KotlinLibraryLayoutImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ExtractingBaseLibraryImpl invoke() {
                return new ExtractingBaseLibraryImpl(this.this$0);
            }
        });
    }

    @NotNull
    public final File getKlib() {
        return this.klib;
    }

    @Override
    @Nullable
    public String getComponent() {
        return this.component;
    }

    public final boolean isZipped() {
        return this.isZipped;
    }

    @Override
    @NotNull
    public File getLibFile() {
        return this.libFile;
    }

    @Override
    @NotNull
    public String getLibraryName() {
        return this.isZipped ? UtilKt.removeSuffixIfPresent(this.klib.getPath(), ".klib") : this.getLibFile().getPath();
    }

    @NotNull
    public KotlinLibraryLayout getExtractingToTemp() {
        Lazy lazy = this.extractingToTemp$delegate;
        return (KotlinLibraryLayout)lazy.getValue();
    }

    @NotNull
    public KotlinLibraryLayout directlyFromZip(@NotNull FileSystem zipFileSystem) {
        Intrinsics.checkNotNullParameter(zipFileSystem, "zipFileSystem");
        return new FromZipBaseLibraryImpl(this, zipFileSystem);
    }
}

