/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.impl;

import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.impl.IrFileReadersKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H&\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00068&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000f8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0016\u001a\u00020\u00068&@&X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00068&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\u0082\u0001\u0001\u001a"}, d2={"Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "", "<init>", "()V", "", "result", "", "offset", "length", "", "get", "([BII)V", "getInt", "()I", "int", "", "getLong", "()J", "long", "getPosition", "setPosition", "(I)V", "position", "getSize", "size", "WeakFileBuffer", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer$WeakFileBuffer;"})
public abstract class ReadBuffer {
    private ReadBuffer() {
    }

    public abstract int getSize();

    public abstract void get(@NotNull byte[] var1, int var2, int var3);

    public abstract int getPosition();

    public abstract void setPosition(int var1);

    public abstract int getInt();

    public abstract long getLong();

    public /* synthetic */ ReadBuffer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR$\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0013R\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\"8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$"}, d2={"Lorg/jetbrains/kotlin/library/impl/ReadBuffer$WeakFileBuffer;", "Lorg/jetbrains/kotlin/library/impl/ReadBuffer;", "Ljava/io/File;", "file", "<init>", "(Ljava/io/File;)V", "Ljava/nio/ByteBuffer;", "ensureBuffer", "()Ljava/nio/ByteBuffer;", "", "result", "", "offset", "length", "", "get", "([BII)V", "Ljava/io/File;", "getInt", "()I", "int", "", "getLong", "()J", "long", "pos", "I", "value", "getPosition", "setPosition", "(I)V", "position", "getSize", "size", "Ljava/lang/ref/SoftReference;", "weakBuffer", "Ljava/lang/ref/SoftReference;"})
    public static final class WeakFileBuffer
    extends ReadBuffer {
        @NotNull
        private final File file;
        private int pos;
        @NotNull
        private SoftReference<ByteBuffer> weakBuffer;

        public WeakFileBuffer(@NotNull File file2) {
            Intrinsics.checkNotNullParameter(file2, "file");
            super(null);
            this.file = file2;
            this.weakBuffer = new SoftReference<Object>(null);
        }

        @Override
        public int getSize() {
            return (int)this.file.length();
        }

        @Override
        public void get(@NotNull byte[] result2, int offset, int length) {
            Intrinsics.checkNotNullParameter(result2, "result");
            ByteBuffer buf = this.ensureBuffer();
            this.pos += length;
            buf.get(result2, offset, length);
        }

        @Override
        public int getInt() {
            ByteBuffer buf = this.ensureBuffer();
            this.pos += 4;
            return buf.getInt();
        }

        @Override
        public long getLong() {
            ByteBuffer buf = this.ensureBuffer();
            this.pos += 8;
            return buf.getLong();
        }

        @Override
        public int getPosition() {
            boolean bl;
            int n;
            int it = n = this.pos;
            boolean bl2 = false;
            boolean bl3 = bl = it == this.ensureBuffer().position();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return n;
        }

        @Override
        public void setPosition(int value2) {
            ByteBuffer buf = this.ensureBuffer();
            this.pos = value2;
            buf.position(value2);
        }

        private final ByteBuffer ensureBuffer() {
            ByteBuffer tmpBuffer = this.weakBuffer.get();
            if (tmpBuffer == null) {
                tmpBuffer = IrFileReadersKt.getBuffer(FilesKt.readBytes(this.file));
                tmpBuffer.position(this.pos);
                this.weakBuffer = new SoftReference<ByteBuffer>(tmpBuffer);
            }
            return tmpBuffer;
        }
    }
}

