/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.light.classes.symbol.modifierLists;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.classes.ImplUtilsKt;
import org.jetbrains.kotlin.asJava.elements.KtLightAbstractAnnotation;
import org.jetbrains.kotlin.asJava.elements.KtLightElement;
import org.jetbrains.kotlin.asJava.elements.KtLightElementBase;
import org.jetbrains.kotlin.light.classes.symbol.SymbolLightUtilsKt;
import org.jetbrains.kotlin.light.classes.symbol.annotations.AnnotationsBox;
import org.jetbrains.kotlin.light.classes.symbol.modifierLists.ModifiersBox;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b0\u0018\u0000*\u0016\b\u0000\u0010\u0004 \u0001*\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u00052\u00020\u00062\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0001B!\b\u0004\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0019\u0010\u0019\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001a\u0010\"\u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010 H\u0096\u0002\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010*\u001a\u00020)2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010,\u001a\u00020)2\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b,\u0010+J\u0017\u0010-\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b/\u0010.J\u0015\u00102\u001a\b\u0012\u0004\u0012\u00020100H\u0017\u00a2\u0006\u0004\b2\u00103J\u0015\u00104\u001a\b\u0012\u0004\u0012\u00020100H\u0017\u00a2\u0006\u0004\b4\u00103J\u0019\u00106\u001a\u0004\u0018\u0001012\u0006\u00105\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b6\u00107J\u0017\u00108\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u001dH\u0016\u00a2\u0006\u0004\b8\u0010.J\u0017\u00109\u001a\u0002012\u0006\u00105\u001a\u00020\u001dH\u0017\u00a2\u0006\u0004\b9\u00107R\u001a\u0010\b\u001a\u00028\u00008\u0005X\u0085\u0004\u00a2\u0006\f\n\u0004\b\b\u0010:\u001a\u0004\b;\u0010\u0015R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010<R\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010=R\u0016\u0010@\u001a\u0004\u0018\u00010\u00078WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u001a\u0010E\u001a\b\u0012\u0004\u0012\u00020B0A8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u0082\u0001\u0002FG"}, d2={"Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/SymbolLightModifierList;", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lcom/intellij/psi/PsiModifierListOwner;", "T", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElementBase;", "Lcom/intellij/psi/PsiModifierList;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "owner", "Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/ModifiersBox;", "modifiersBox", "Lorg/jetbrains/kotlin/light/classes/symbol/annotations/AnnotationsBox;", "annotationsBox", "<init>", "(Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/ModifiersBox;Lorg/jetbrains/kotlin/light/classes/symbol/annotations/AnnotationsBox;)V", "Lcom/intellij/psi/PsiElementVisitor;", "visitor", "", "accept", "(Lcom/intellij/psi/PsiElementVisitor;)V", "getParent", "()Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "Lcom/intellij/psi/PsiElement;", "another", "", "isEquivalentTo", "(Lcom/intellij/psi/PsiElement;)Z", "isWritable", "()Z", "", "toString", "()Ljava/lang/String;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "name", "value", "", "setModifierProperty", "(Ljava/lang/String;Z)Ljava/lang/Void;", "checkSetModifierProperty", "hasExplicitModifier", "(Ljava/lang/String;)Z", "hasModifierProperty", "", "Lcom/intellij/psi/PsiAnnotation;", "getAnnotations", "()[Lcom/intellij/psi/PsiAnnotation;", "getApplicableAnnotations", "qualifiedName", "findAnnotation", "(Ljava/lang/String;)Lcom/intellij/psi/PsiAnnotation;", "hasAnnotation", "addAnnotation", "Lorg/jetbrains/kotlin/asJava/elements/KtLightElement;", "getOwner", "Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/ModifiersBox;", "Lorg/jetbrains/kotlin/light/classes/symbol/annotations/AnnotationsBox;", "getKotlinOrigin", "()Lorg/jetbrains/kotlin/psi/KtModifierList;", "kotlinOrigin", "", "Lorg/jetbrains/kotlin/asJava/elements/KtLightAbstractAnnotation;", "getGivenAnnotations", "()Ljava/util/List;", "givenAnnotations", "Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/SymbolLightClassModifierList;", "Lorg/jetbrains/kotlin/light/classes/symbol/modifierLists/SymbolLightMemberModifierList;"})
public abstract class SymbolLightModifierList<T extends KtLightElement<? extends KtModifierListOwner, ? extends PsiModifierListOwner>>
extends KtLightElementBase
implements PsiModifierList,
KtLightElement<KtModifierList, PsiModifierListOwner> {
    @NotNull
    private final T owner;
    @NotNull
    private final ModifiersBox modifiersBox;
    @NotNull
    private final AnnotationsBox annotationsBox;

    private SymbolLightModifierList(T owner, ModifiersBox modifiersBox, AnnotationsBox annotationsBox) {
        super((PsiElement)owner);
        this.owner = owner;
        this.modifiersBox = modifiersBox;
        this.annotationsBox = annotationsBox;
    }

    @NotNull
    protected final T getOwner() {
        return this.owner;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @Nullable
    public KtModifierList getKotlinOrigin() {
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.owner.getKotlinOrigin();
        return ktModifierListOwner != null ? ktModifierListOwner.getModifierList() : null;
    }

    @NotNull
    public T getParent() {
        return this.owner;
    }

    @Override
    public boolean isEquivalentTo(@Nullable PsiElement another) {
        return another instanceof SymbolLightModifierList && Intrinsics.areEqual(this.owner, ((SymbolLightModifierList)another).owner);
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        return "Light modifier list of " + this.owner;
    }

    @Override
    @NotNull
    public List<KtLightAbstractAnnotation> getGivenAnnotations() {
        SymbolLightUtilsKt.invalidAccess(this);
        throw new KotlinNothingValueException();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof SymbolLightModifierList && Intrinsics.areEqual(((SymbolLightModifierList)other).getKotlinOrigin(), this.getKotlinOrigin());
    }

    public int hashCode() {
        KtModifierList ktModifierList = this.getKotlinOrigin();
        return ktModifierList != null ? ktModifierList.hashCode() : 0;
    }

    @NotNull
    public Void setModifierProperty(@NotNull String name, boolean value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        ImplUtilsKt.cannotModify(this);
        throw new KotlinNothingValueException();
    }

    @NotNull
    public Void checkSetModifierProperty(@NotNull String name, boolean value2) {
        Intrinsics.checkNotNullParameter(name, "name");
        throw new IncorrectOperationException();
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.hasModifierProperty(name);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.modifiersBox.hasModifier(name);
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        return this.annotationsBox.annotationsArray(this);
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        return this.getAnnotations();
    }

    @Override
    @Nullable
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName2) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        return this.annotationsBox.findAnnotation(this, qualifiedName2);
    }

    @Override
    public boolean hasAnnotation(@NotNull String qualifiedName2) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        return this.annotationsBox.hasAnnotation(this, qualifiedName2);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull String qualifiedName2) {
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        throw new UnsupportedOperationException();
    }

    public /* synthetic */ SymbolLightModifierList(KtLightElement owner, ModifiersBox modifiersBox, AnnotationsBox annotationsBox, DefaultConstructorMarker $constructor_marker) {
        this(owner, modifiersBox, annotationsBox);
    }
}

