/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.SpecialGenericSignatures;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.ExternalOverridabilityCondition;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ)\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaIncompatibilityRulesOverridabilityCondition;", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition;", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "superDescriptor", "subDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "subClassDescriptor", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Result;", "isOverridable", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Result;", "", "isIncompatibleInAccordanceWithBuiltInOverridabilityRules", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Z", "Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Contract;", "getContract", "()Lorg/jetbrains/kotlin/resolve/ExternalOverridabilityCondition$Contract;", "Companion"})
public final class JavaIncompatibilityRulesOverridabilityCondition
implements ExternalOverridabilityCondition {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Result isOverridable(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, @Nullable ClassDescriptor subClassDescriptor) {
        Intrinsics.checkNotNullParameter(superDescriptor, "superDescriptor");
        Intrinsics.checkNotNullParameter(subDescriptor, "subDescriptor");
        if (this.isIncompatibleInAccordanceWithBuiltInOverridabilityRules(superDescriptor, subDescriptor, subClassDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        if (Companion.doesJavaOverrideHaveIncompatibleValueParameterKinds(superDescriptor, subDescriptor)) {
            return ExternalOverridabilityCondition.Result.INCOMPATIBLE;
        }
        return ExternalOverridabilityCondition.Result.UNKNOWN;
    }

    private final boolean isIncompatibleInAccordanceWithBuiltInOverridabilityRules(CallableDescriptor superDescriptor, CallableDescriptor subDescriptor, ClassDescriptor subClassDescriptor) {
        boolean isOneOfDescriptorsHidden;
        FunctionDescriptor functionDescriptor;
        if (!(superDescriptor instanceof CallableMemberDescriptor) || !(subDescriptor instanceof FunctionDescriptor) || KotlinBuiltIns.isBuiltIn(subDescriptor)) {
            return false;
        }
        Name name = ((FunctionDescriptor)subDescriptor).getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(name)) {
            Name name2 = ((FunctionDescriptor)subDescriptor).getName();
            Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
            if (!SpecialGenericSignatures.Companion.getSameAsRenamedInJvmBuiltin(name2)) {
                return false;
            }
        }
        CallableMemberDescriptor overriddenBuiltin = SpecialBuiltinMembers.getOverriddenSpecialBuiltin((CallableMemberDescriptor)superDescriptor);
        CallableDescriptor callableDescriptor = superDescriptor;
        FunctionDescriptor functionDescriptor2 = functionDescriptor = callableDescriptor instanceof FunctionDescriptor ? (FunctionDescriptor)callableDescriptor : null;
        boolean bl = isOneOfDescriptorsHidden = !(functionDescriptor != null ? ((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash() == functionDescriptor.isHiddenToOvercomeSignatureClash() : false);
        if (isOneOfDescriptorsHidden && (overriddenBuiltin == null || !((FunctionDescriptor)subDescriptor).isHiddenToOvercomeSignatureClash())) {
            return true;
        }
        if (!(subClassDescriptor instanceof JavaClassDescriptor) || ((FunctionDescriptor)subDescriptor).getInitialSignatureDescriptor() != null) {
            return false;
        }
        if (overriddenBuiltin == null || SpecialBuiltinMembers.hasRealKotlinSuperClassWithOverrideOf(subClassDescriptor, overriddenBuiltin)) {
            return false;
        }
        if (overriddenBuiltin instanceof FunctionDescriptor && superDescriptor instanceof FunctionDescriptor && BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)overriddenBuiltin) != null) {
            String string2 = MethodSignatureMappingKt.computeJvmDescriptor$default((FunctionDescriptor)subDescriptor, false, false, 2, null);
            FunctionDescriptor functionDescriptor3 = ((FunctionDescriptor)superDescriptor).getOriginal();
            Intrinsics.checkNotNullExpressionValue(functionDescriptor3, "getOriginal(...)");
            if (Intrinsics.areEqual(string2, MethodSignatureMappingKt.computeJvmDescriptor$default(functionDescriptor3, false, false, 2, null))) {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    public ExternalOverridabilityCondition.Contract getContract() {
        return ExternalOverridabilityCondition.Contract.CONFLICTS_ONLY;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/load/java/JavaIncompatibilityRulesOverridabilityCondition$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "superDescriptor", "subDescriptor", "", "doesJavaOverrideHaveIncompatibleValueParameterKinds", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "f", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "mapValueParameterType", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "isPrimitiveCompareTo", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean doesJavaOverrideHaveIncompatibleValueParameterKinds(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
            boolean bl;
            Intrinsics.checkNotNullParameter(superDescriptor, "superDescriptor");
            Intrinsics.checkNotNullParameter(subDescriptor, "subDescriptor");
            if (!(subDescriptor instanceof JavaMethodDescriptor) || !(superDescriptor instanceof FunctionDescriptor)) {
                return false;
            }
            boolean bl2 = bl = ((JavaMethodDescriptor)subDescriptor).getValueParameters().size() == ((FunctionDescriptor)superDescriptor).getValueParameters().size();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "External overridability condition with CONFLICTS_ONLY should not be run with different value parameters size";
                throw new AssertionError((Object)string2);
            }
            List<ValueParameterDescriptor> list = ((JavaMethodDescriptor)subDescriptor).getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            Iterable iterable = list;
            List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)superDescriptor).getOriginal().getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
            for (Pair pair : CollectionsKt.zip(iterable, (Iterable)list2)) {
                ValueParameterDescriptor subParameter = (ValueParameterDescriptor)pair.component1();
                ValueParameterDescriptor superParameter = (ValueParameterDescriptor)pair.component2();
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)subDescriptor;
                Intrinsics.checkNotNull(subParameter);
                boolean isSubPrimitive = this.mapValueParameterType(functionDescriptor, subParameter) instanceof JvmType.Primitive;
                FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)superDescriptor;
                Intrinsics.checkNotNull(superParameter);
                boolean isSuperPrimitive = this.mapValueParameterType(functionDescriptor2, superParameter) instanceof JvmType.Primitive;
                if (isSubPrimitive == isSuperPrimitive) continue;
                return true;
            }
            return false;
        }

        private final JvmType mapValueParameterType(FunctionDescriptor f, ValueParameterDescriptor valueParameterDescriptor) {
            JvmType jvmType;
            if (MethodSignatureMappingKt.forceSingleValueParameterBoxing(f) || this.isPrimitiveCompareTo(f)) {
                KotlinType kotlinType = valueParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                jvmType = MethodSignatureMappingKt.mapToJvmType(TypeUtilsKt.makeNullable(kotlinType));
            } else {
                KotlinType kotlinType = valueParameterDescriptor.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType);
            }
            return jvmType;
        }

        private final boolean isPrimitiveCompareTo(FunctionDescriptor f) {
            if (f.getValueParameters().size() != 1) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = f.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return false;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            List<ValueParameterDescriptor> list = f.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            ClassifierDescriptor classifierDescriptor = CollectionsKt.single(list).getType().getConstructor().getDeclarationDescriptor();
            ClassDescriptor classDescriptor3 = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
            if (classDescriptor3 == null) {
                return false;
            }
            ClassDescriptor parameterClass = classDescriptor3;
            return KotlinBuiltIns.isPrimitiveClass(classDescriptor2) && Intrinsics.areEqual(DescriptorUtilsKt.getFqNameSafe(classDescriptor2), DescriptorUtilsKt.getFqNameSafe(parameterClass));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

