/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.BuiltinSpecialProperties;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\u001a\u0019\u0010\u0002\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a!\u0010\u0006\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u0006\u0010\u0001\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u0006\u0010\u000b\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\f\u0010\n\u001a7\u0010\u0011\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u0006\u0010\u000b\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0013\u0010\n\u001a\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00000\b2\u0006\u0010\u0014\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0015\u0010\n\u001a\u0017\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/name/Name;", "methodName", "propertyNameByGetMethodName", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/name/Name;", "", "withIsPrefix", "propertyNameBySetMethodName", "(Lorg/jetbrains/kotlin/name/Name;Z)Lorg/jetbrains/kotlin/name/Name;", "", "propertyNamesBySetMethodName", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;", "name", "propertyNamesByAccessorName", "", "prefix", "removePrefix", "addPrefix", "propertyNameFromAccessorMethodName", "(Lorg/jetbrains/kotlin/name/Name;Ljava/lang/String;ZLjava/lang/String;)Lorg/jetbrains/kotlin/name/Name;", "getPropertyNamesCandidatesByAccessorName", "propertyName", "possibleGetMethodNames", "getMethodName", "setMethodName"})
public final class PropertiesConventionUtilKt {
    @Nullable
    public static final Name propertyNameByGetMethodName(@NotNull Name methodName) {
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Name name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "get", false, null, 12, null);
        if (name == null) {
            name = PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "is", false, null, 8, null);
        }
        return name;
    }

    @Nullable
    public static final Name propertyNameBySetMethodName(@NotNull Name methodName, boolean withIsPrefix) {
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName$default(methodName, "set", false, withIsPrefix ? "is" : null, 4, null);
    }

    @NotNull
    public static final List<Name> propertyNamesBySetMethodName(@NotNull Name methodName) {
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Name[] nameArray = new Name[]{PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, false), PropertiesConventionUtilKt.propertyNameBySetMethodName(methodName, true)};
        return CollectionsKt.listOfNotNull(nameArray);
    }

    @NotNull
    public static final List<Name> propertyNamesByAccessorName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        Name[] nameArray = new Name[]{PropertiesConventionUtilKt.propertyNameByGetMethodName(name), PropertiesConventionUtilKt.propertyNameBySetMethodName(name, true), PropertiesConventionUtilKt.propertyNameBySetMethodName(name, false)};
        return CollectionsKt.listOfNotNull(nameArray);
    }

    private static final Name propertyNameFromAccessorMethodName(Name methodName, String prefix, boolean removePrefix, String addPrefix) {
        if (methodName.isSpecial()) {
            return null;
        }
        String string2 = methodName.getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
        String identifier = string2;
        if (!StringsKt.startsWith$default(identifier, prefix, false, 2, null)) {
            return null;
        }
        if (identifier.length() == prefix.length()) {
            return null;
        }
        char c = identifier.charAt(prefix.length());
        boolean bl = 'a' <= c ? c < '{' : false;
        if (bl) {
            return null;
        }
        if (addPrefix != null) {
            if (_Assertions.ENABLED && !removePrefix) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            return Name.identifier(addPrefix + StringsKt.removePrefix(identifier, (CharSequence)prefix));
        }
        if (!removePrefix) {
            return methodName;
        }
        String name = CapitalizeDecapitalizeKt.decapitalizeSmartForCompiler(StringsKt.removePrefix(identifier, (CharSequence)prefix), true);
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        return Name.identifier(name);
    }

    static /* synthetic */ Name propertyNameFromAccessorMethodName$default(Name name, String string2, boolean bl, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        return PropertiesConventionUtilKt.propertyNameFromAccessorMethodName(name, string2, bl, string3);
    }

    @NotNull
    public static final List<Name> getPropertyNamesCandidatesByAccessorName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String nameAsString = string2;
        if (JvmAbi.isGetterName(nameAsString)) {
            return CollectionsKt.listOfNotNull(PropertiesConventionUtilKt.propertyNameByGetMethodName(name));
        }
        if (JvmAbi.isSetterName(nameAsString)) {
            return PropertiesConventionUtilKt.propertyNamesBySetMethodName(name);
        }
        return BuiltinSpecialProperties.INSTANCE.getPropertyNameCandidatesBySpecialGetterName(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Name> possibleGetMethodNames(@NotNull Name propertyName) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String identifier;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter(propertyName, "propertyName");
                if (propertyName.isSpecial()) {
                    return CollectionsKt.emptyList();
                }
                String string2 = propertyName.getIdentifier();
                Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
                identifier = string2;
                if (((CharSequence)identifier).length() == 0) {
                    return CollectionsKt.emptyList();
                }
                char firstChar = identifier.charAt(0);
                if (!Character.isJavaIdentifierStart(firstChar)) break block8;
                boolean bl = 'A' <= firstChar ? firstChar < '[' : false;
                if (!bl) break block9;
            }
            return CollectionsKt.emptyList();
        }
        ArrayList<Name> result2 = new ArrayList<Name>(3);
        if (JvmAbi.startsWithIsPrefix(identifier)) {
            result2.add(propertyName);
        }
        String capitalize1 = CapitalizeDecapitalizeKt.capitalizeAsciiOnly(identifier);
        String capitalize2 = CapitalizeDecapitalizeKt.capitalizeFirstWord(identifier, true);
        result2.add(Name.identifier("get" + capitalize1));
        if (!Intrinsics.areEqual(capitalize2, capitalize1)) {
            result2.add(Name.identifier("get" + capitalize2));
        }
        Iterable iterable = result2;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Name it = (Name)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(PropertiesConventionUtilKt.propertyNameByGetMethodName(it), propertyName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Name setMethodName(@NotNull Name getMethodName) {
        String string2;
        Intrinsics.checkNotNullParameter(getMethodName, "getMethodName");
        String string3 = getMethodName.getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string3, "getIdentifier(...)");
        String identifier = string3;
        if (StringsKt.startsWith$default(identifier, "get", false, 2, null)) {
            string2 = "get";
        } else if (StringsKt.startsWith$default(identifier, "is", false, 2, null)) {
            string2 = "is";
        } else {
            throw new IllegalArgumentException();
        }
        String prefix = string2;
        Name name = Name.identifier("set" + StringsKt.removePrefix(identifier, (CharSequence)prefix));
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        return name;
    }
}

