/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaStaticClassScope;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DescriptorWithContainerSource;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a9\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00002\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0015\u0010\f\u001a\u0004\u0018\u00010\u000b*\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u000f*\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0011\u0010\u0013\u001a\u00020\u0012*\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"", "Lorg/jetbrains/kotlin/types/KotlinType;", "newValueParameterTypes", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "oldValueParameters", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "newOwner", "", "copyValueParameters", "(Ljava/util/Collection;Ljava/util/Collection;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Ljava/util/List;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "getParentJavaStaticClassScope", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Lorg/jetbrains/kotlin/load/java/lazy/descriptors/LazyJavaStaticClassScope;", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DescriptorWithContainerSource;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getImplClassNameForDeserialized", "(Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DescriptorWithContainerSource;)Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "", "isFromJvmPackagePart", "(Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DescriptorWithContainerSource;)Z"})
public final class UtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> copyValueParameters(@NotNull Collection<? extends KotlinType> newValueParameterTypes, @NotNull Collection<? extends ValueParameterDescriptor> oldValueParameters, @NotNull CallableDescriptor newOwner) {
        void $this$mapTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(newValueParameterTypes, "newValueParameterTypes");
        Intrinsics.checkNotNullParameter(oldValueParameters, "oldValueParameters");
        Intrinsics.checkNotNullParameter(newOwner, "newOwner");
        boolean bl2 = bl = newValueParameterTypes.size() == oldValueParameters.size();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-UtilKt$copyValueParameters$22 = false;
            String $i$a$-assert-UtilKt$copyValueParameters$22 = "Different value parameters sizes: Enhanced = " + newValueParameterTypes.size() + ", Old = " + oldValueParameters.size();
            throw new AssertionError((Object)$i$a$-assert-UtilKt$copyValueParameters$22);
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)newValueParameterTypes, (Iterable)oldValueParameters);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            KotlinType newParameterType = (KotlinType)pair.component1();
            ValueParameterDescriptor oldParameter = (ValueParameterDescriptor)pair.component2();
            int n = oldParameter.getIndex();
            Annotations annotations2 = oldParameter.getAnnotations();
            Name name = oldParameter.getName();
            Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
            boolean bl4 = oldParameter.declaresDefaultValue();
            boolean bl5 = oldParameter.isCrossinline();
            boolean bl6 = oldParameter.isNoinline();
            KotlinType kotlinType = oldParameter.getVarargElementType() != null ? DescriptorUtilsKt.getModule(newOwner).getBuiltIns().getArrayElementType(newParameterType) : null;
            SourceElement sourceElement = oldParameter.getSource();
            Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
            collection.add(new ValueParameterDescriptorImpl(newOwner, null, n, annotations2, name, newParameterType, bl4, bl5, bl6, kotlinType, sourceElement));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final LazyJavaStaticClassScope getParentJavaStaticClassScope(@NotNull ClassDescriptor $this$getParentJavaStaticClassScope) {
        Intrinsics.checkNotNullParameter($this$getParentJavaStaticClassScope, "<this>");
        ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny($this$getParentJavaStaticClassScope);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor superClassDescriptor = classDescriptor;
        MemberScope memberScope2 = superClassDescriptor.getStaticScope();
        LazyJavaStaticClassScope lazyJavaStaticClassScope = memberScope2 instanceof LazyJavaStaticClassScope ? (LazyJavaStaticClassScope)memberScope2 : null;
        if (lazyJavaStaticClassScope == null) {
            lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(superClassDescriptor);
        }
        return lazyJavaStaticClassScope;
    }

    @Nullable
    public static final JvmClassName getImplClassNameForDeserialized(@NotNull DescriptorWithContainerSource $this$getImplClassNameForDeserialized) {
        Intrinsics.checkNotNullParameter($this$getImplClassNameForDeserialized, "<this>");
        DeserializedContainerSource deserializedContainerSource = $this$getImplClassNameForDeserialized.getContainerSource();
        JvmPackagePartSource jvmPackagePartSource = deserializedContainerSource instanceof JvmPackagePartSource ? (JvmPackagePartSource)deserializedContainerSource : null;
        return jvmPackagePartSource != null ? jvmPackagePartSource.getClassName() : null;
    }

    public static final boolean isFromJvmPackagePart(@NotNull DescriptorWithContainerSource $this$isFromJvmPackagePart) {
        Intrinsics.checkNotNullParameter($this$isFromJvmPackagePart, "<this>");
        return $this$isFromJvmPackagePart.getContainerSource() instanceof JvmPackagePartSource;
    }
}

