/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.MutableJavaAnnotationOwner;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryClassSignatureParser;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaAnnotation;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaAnnotationVisitor;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaMethod;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaMethodBase;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.TypeReference;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\"\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0014\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ)\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017H\u0017\u00a2\u0006\u0004\b\u001f\u0010 J3\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0017H\u0017\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010'R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010(R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010)R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010*R\u0014\u0010\n\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010*R\u0016\u0010+\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010*R\u0016\u0010,\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010*R\u0016\u0010-\u001a\u00020\b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010*R \u0010/\u001a\b\u0012\u0004\u0012\u00020\b0.8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/AnnotationsAndParameterCollectorMethodVisitor;", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryJavaMethodBase;", "member", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "signatureParser", "", "parametersToSkipNumber", "parametersCountInMethodDesc", "<init>", "(Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryJavaMethodBase;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;II)V", "Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "visitAnnotationDefault", "()Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "", "name", "access", "", "visitParameter", "(Ljava/lang/String;I)V", "desc", "", "visible", "visitAnnotation", "(Ljava/lang/String;Z)Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "parameterCount", "visitAnnotableParameterCount", "(IZ)V", "parameter", "visitParameterAnnotation", "(ILjava/lang/String;Z)Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "typeRef", "Lorg/jetbrains/org/objectweb/asm/TypePath;", "typePath", "descriptor", "visitTypeAnnotation", "(ILorg/jetbrains/org/objectweb/asm/TypePath;Ljava/lang/String;Z)Lorg/jetbrains/org/objectweb/asm/AnnotationVisitor;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryJavaMethodBase;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "I", "parameterIndex", "visibleAnnotableParameterCount", "invisibleAnnotableParameterCount", "", "freshlySupportedPositions", "Ljava/util/Set;", "getFreshlySupportedPositions", "()Ljava/util/Set;"})
public final class AnnotationsAndParameterCollectorMethodVisitor
extends MethodVisitor {
    @NotNull
    private final BinaryJavaMethodBase member;
    @NotNull
    private final ClassifierResolutionContext context;
    @NotNull
    private final BinaryClassSignatureParser signatureParser;
    private final int parametersToSkipNumber;
    private final int parametersCountInMethodDesc;
    private int parameterIndex;
    private int visibleAnnotableParameterCount;
    private int invisibleAnnotableParameterCount;
    @NotNull
    private final Set<Integer> freshlySupportedPositions;

    public AnnotationsAndParameterCollectorMethodVisitor(@NotNull BinaryJavaMethodBase member, @NotNull ClassifierResolutionContext context, @NotNull BinaryClassSignatureParser signatureParser, int parametersToSkipNumber, int parametersCountInMethodDesc) {
        Intrinsics.checkNotNullParameter(member, "member");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(signatureParser, "signatureParser");
        super(589824);
        this.member = member;
        this.context = context;
        this.signatureParser = signatureParser;
        this.parametersToSkipNumber = parametersToSkipNumber;
        this.visibleAnnotableParameterCount = this.parametersCountInMethodDesc = parametersCountInMethodDesc;
        this.invisibleAnnotableParameterCount = this.parametersCountInMethodDesc;
        Integer[] integerArray = new Integer[]{1, 18};
        this.freshlySupportedPositions = SetsKt.setOf(integerArray);
    }

    @NotNull
    public final Set<Integer> getFreshlySupportedPositions() {
        return this.freshlySupportedPositions;
    }

    @Override
    @NotNull
    public AnnotationVisitor visitAnnotationDefault() {
        return new BinaryJavaAnnotationVisitor(this.context, this.signatureParser, arg_0 -> AnnotationsAndParameterCollectorMethodVisitor.visitAnnotationDefault$lambda$0(this, arg_0));
    }

    @Override
    public void visitParameter(@Nullable String name, int access) {
        int index2;
        if (name != null && (index2 = this.parameterIndex - this.parametersToSkipNumber) >= 0) {
            BinaryJavaValueParameter binaryJavaValueParameter = CollectionsKt.getOrNull(this.member.getValueParameters(), index2);
            if (binaryJavaValueParameter == null) {
                throw new IllegalStateException(("No parameter with index " + this.parameterIndex + '-' + this.parametersToSkipNumber + " (name=" + name + " access=" + access + ") in method " + this.member.getContainingClass().getFqName() + '.' + this.member.getName()).toString());
            }
            BinaryJavaValueParameter parameter = binaryJavaValueParameter;
            Name name2 = Name.identifier(name);
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
            parameter.updateName$resolution_common_jvm(name2);
        }
        int n = this.parameterIndex;
        this.parameterIndex = n + 1;
    }

    @Override
    @NotNull
    public AnnotationVisitor visitAnnotation(@NotNull String desc, boolean visible) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        return BinaryJavaAnnotation.Companion.addAnnotation$default(BinaryJavaAnnotation.Companion, this.member, desc, this.context, this.signatureParser, false, 16, null);
    }

    @Override
    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        if (visible) {
            this.visibleAnnotableParameterCount = parameterCount;
        } else {
            this.invisibleAnnotableParameterCount = parameterCount;
        }
    }

    @Override
    @Nullable
    public AnnotationVisitor visitParameterAnnotation(int parameter, @NotNull String desc, boolean visible) {
        Intrinsics.checkNotNullParameter(desc, "desc");
        int absoluteParameterIndex = parameter + this.parametersCountInMethodDesc - (visible ? this.visibleAnnotableParameterCount : this.invisibleAnnotableParameterCount);
        int index2 = absoluteParameterIndex - this.parametersToSkipNumber;
        if (index2 < 0) {
            return null;
        }
        return BinaryJavaAnnotation.Companion.addAnnotation$default(BinaryJavaAnnotation.Companion, this.member.getValueParameters().get(index2), desc, this.context, this.signatureParser, false, 16, null);
    }

    @Override
    @Nullable
    public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, @NotNull String descriptor2, boolean visible) {
        Pair<JavaAnnotationOwner, Boolean> pair;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        TypeReference typeReference = new TypeReference(typeRef);
        switch (typeReference.getSort()) {
            case 20: {
                BinaryJavaMethodBase binaryJavaMethodBase = this.member;
                JavaAnnotationOwner javaAnnotationOwner = binaryJavaMethodBase instanceof BinaryJavaMethod ? (BinaryJavaMethod)binaryJavaMethodBase : null;
                if (javaAnnotationOwner == null || (javaAnnotationOwner = javaAnnotationOwner.getReturnType()) == null) {
                    return null;
                }
                pair = AnnotationsAndParameterCollectorMethodVisitor.visitTypeAnnotation$getTargetType(typePath, this, typeReference, (JavaType)javaAnnotationOwner);
                break;
            }
            case 1: {
                pair = TuplesKt.to(this.member.getTypeParameters().get(typeReference.getTypeParameterIndex()), true);
                break;
            }
            case 22: {
                pair = AnnotationsAndParameterCollectorMethodVisitor.visitTypeAnnotation$getTargetType(typePath, this, typeReference, this.member.getValueParameters().get(typeReference.getFormalParameterIndex()).getType());
                break;
            }
            case 18: {
                pair = AnnotationsAndParameterCollectorMethodVisitor.visitTypeAnnotation$getTargetType(typePath, this, typeReference, BinaryJavaAnnotation.Companion.computeTypeParameterBound$resolution_common_jvm(this.member.getTypeParameters(), typeReference));
                break;
            }
            default: {
                return null;
            }
        }
        Pair<JavaTypeParameter, Boolean> pair2 = pair;
        JavaAnnotationOwner annotationOwner = pair2.component1();
        boolean isFreshlySupportedAnnotation = pair2.component2();
        if (!(annotationOwner instanceof MutableJavaAnnotationOwner)) {
            return null;
        }
        return BinaryJavaAnnotation.Companion.addAnnotation((MutableJavaAnnotationOwner)annotationOwner, descriptor2, this.context, this.signatureParser, isFreshlySupportedAnnotation);
    }

    private static final Unit visitAnnotationDefault$lambda$0(AnnotationsAndParameterCollectorMethodVisitor this$0, JavaAnnotationArgument it) {
        block0: {
            Intrinsics.checkNotNullParameter(it, "it");
            BinaryJavaMethodBase binaryJavaMethodBase = this$0.member;
            BinaryJavaMethod binaryJavaMethod = binaryJavaMethodBase instanceof BinaryJavaMethod ? (BinaryJavaMethod)binaryJavaMethodBase : null;
            if (binaryJavaMethod == null) break block0;
            binaryJavaMethod.setAnnotationParameterDefaultValue$resolution_common_jvm(it);
        }
        return Unit.INSTANCE;
    }

    private static final Pair<JavaType, Boolean> visitTypeAnnotation$getTargetType(TypePath $typePath, AnnotationsAndParameterCollectorMethodVisitor this$0, TypeReference typeReference, JavaType baseType) {
        return $typePath != null ? TuplesKt.to(BinaryJavaAnnotation.Companion.computeTargetType$resolution_common_jvm(baseType, $typePath), true) : TuplesKt.to(baseType, this$0.freshlySupportedPositions.contains(typeReference.getSort()));
    }
}

