/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import com.intellij.util.containers.Interner;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaArrayType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaWildcardType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.PlatformUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002*+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u001f\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u0015J\u001f\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001f\u0010 J!\u0010!\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b!\u0010\u0015J!\u0010$\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010#\u001a\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020'0&8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "", "<init>", "()V", "Ljava/text/CharacterIterator;", "signature", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "context", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "parseTypeParametersDeclaration", "(Ljava/text/CharacterIterator;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;)Ljava/util/List;", "parseTypeParameter", "(Ljava/text/CharacterIterator;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;)Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "parseClassifierRefSignature", "(Ljava/text/CharacterIterator;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;)Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "parseTypeVariableRefSignature", "parseParameterizedClassRefSignature", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "parseClassOrTypeVariableElement", "(Ljava/text/CharacterIterator;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;)Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "parseVariance", "(Ljava/text/CharacterIterator;)Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "", "parseDimensions", "(Ljava/text/CharacterIterator;)I", "parseTypeString", "Lorg/jetbrains/org/objectweb/asm/Type;", "type", "mapAsmType", "(Lorg/jetbrains/org/objectweb/asm/Type;Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;)Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "parseTypeWithoutVarianceAndArray", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "primitiveType", "parsePrimitiveType", "(Ljava/text/CharacterIterator;Lorg/jetbrains/kotlin/builtins/PrimitiveType;)Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "Lcom/intellij/util/containers/Interner;", "", "canonicalNameInterner", "Lcom/intellij/util/containers/Interner;", "JavaSignatureVariance", "ClsFormatException"})
public final class BinaryClassSignatureParser {
    @NotNull
    private final Interner<String> canonicalNameInterner = PlatformUtilsKt.createStringInterner();

    @NotNull
    public final List<JavaTypeParameter> parseTypeParametersDeclaration(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context, "context");
        if (signature2.current() != '<') {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ArrayList<JavaTypeParameter> typeParameters2 = new ArrayList<JavaTypeParameter>();
        signature2.next();
        while (signature2.current() != '>') {
            typeParameters2.add(this.parseTypeParameter(signature2, context));
        }
        signature2.next();
        return CollectionsKt.compact(typeParameters2);
    }

    private final JavaTypeParameter parseTypeParameter(CharacterIterator signature2, ClassifierResolutionContext context) {
        StringBuilder name = new StringBuilder();
        while (signature2.current() != ':' && signature2.current() != '\uffff') {
            name.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        String string2 = name.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String parameterName = string2;
        List bounds = new SmartList();
        boolean hasImplicitObjectBound = false;
        while (signature2.current() == ':') {
            signature2.next();
            if (signature2.current() == ':') {
                hasImplicitObjectBound = true;
                continue;
            }
            JavaClassifierType javaClassifierType = this.parseClassifierRefSignature(signature2, context);
            if (javaClassifierType == null) continue;
            bounds.add(javaClassifierType);
        }
        Name name2 = Name.identifier(parameterName);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        return new BinaryJavaTypeParameter(name2, bounds, hasImplicitObjectBound);
    }

    @Nullable
    public final JavaClassifierType parseClassifierRefSignature(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context) {
        JavaClassifierType javaClassifierType;
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context, "context");
        switch (signature2.current()) {
            case 'L': {
                javaClassifierType = this.parseParameterizedClassRefSignature(signature2, context);
                break;
            }
            case 'T': {
                javaClassifierType = this.parseTypeVariableRefSignature(signature2, context);
                break;
            }
            default: {
                javaClassifierType = null;
            }
        }
        return javaClassifierType;
    }

    private final JavaClassifierType parseTypeVariableRefSignature(CharacterIterator signature2, ClassifierResolutionContext context) {
        StringBuilder id = new StringBuilder();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '>' && signature2.current() != '\uffff') {
            id.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        String string2 = this.canonicalNameInterner.intern(id.toString());
        Intrinsics.checkNotNullExpressionValue(string2, "intern(...)");
        String parameterName = string2;
        return new PlainJavaClassifierType(() -> BinaryClassSignatureParser.parseTypeVariableRefSignature$lambda$0(context, parameterName), kotlin.collections.CollectionsKt.emptyList());
    }

    private final JavaClassifierType parseParameterizedClassRefSignature(CharacterIterator signature2, ClassifierResolutionContext context) {
        StringBuilder canonicalName = new StringBuilder();
        SmartList<List> argumentGroups = new SmartList<List>();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '\uffff') {
            char c = signature2.current();
            if (c == '<') {
                List group = new ArrayList();
                signature2.next();
                do {
                    group.add(this.parseClassOrTypeVariableElement(signature2, context));
                } while (signature2.current() != '>');
                argumentGroups.add(group);
            } else if (c != ' ') {
                canonicalName.append(c);
            }
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        signature2.next();
        String string2 = canonicalName.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        String string3 = this.canonicalNameInterner.intern(StringsKt.replace$default(string2, '.', '$', false, 4, null));
        Intrinsics.checkNotNullExpressionValue(string3, "intern(...)");
        String internalName = string3;
        return new PlainJavaClassifierType(() -> BinaryClassSignatureParser.parseParameterizedClassRefSignature$lambda$1(context, internalName), CollectionsKt.compact((ArrayList)AddToStdlibKt.flattenTo(kotlin.collections.CollectionsKt.reversed((Iterable)argumentGroups), (Collection)new ArrayList())));
    }

    private final JavaType parseClassOrTypeVariableElement(CharacterIterator signature2, ClassifierResolutionContext context) {
        JavaSignatureVariance variance = this.parseVariance(signature2);
        if (variance == JavaSignatureVariance.STAR) {
            return new PlainJavaWildcardType(null, true);
        }
        JavaType type2 = this.parseTypeString(signature2, context);
        if (variance == JavaSignatureVariance.NO_VARIANCE) {
            return type2;
        }
        return new PlainJavaWildcardType(type2, variance == JavaSignatureVariance.PLUS);
    }

    private final JavaSignatureVariance parseVariance(CharacterIterator signature2) {
        JavaSignatureVariance variance;
        boolean advance = true;
        switch (signature2.current()) {
            case '+': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.PLUS;
                break;
            }
            case '-': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.MINUS;
                break;
            }
            case '*': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.STAR;
                break;
            }
            case '.': 
            case '=': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.NO_VARIANCE;
                break;
            }
            default: {
                advance = false;
                JavaSignatureVariance javaSignatureVariance = variance = JavaSignatureVariance.NO_VARIANCE;
            }
        }
        if (advance) {
            signature2.next();
        }
        return variance;
    }

    private final int parseDimensions(CharacterIterator signature2) {
        int dimensions = 0;
        while (signature2.current() == '[') {
            ++dimensions;
            signature2.next();
        }
        return dimensions;
    }

    @NotNull
    public final JavaType parseTypeString(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context, "context");
        int dimensions = this.parseDimensions(signature2);
        JavaType javaType = this.parseTypeWithoutVarianceAndArray(signature2, context);
        if (javaType == null) {
            throw new ClsFormatException(null, null, 3, null);
        }
        JavaType type2 = javaType;
        Iterable $this$fold$iv = new IntRange(1, dimensions);
        boolean $i$f$fold = false;
        JavaType accumulator$iv = type2;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv = ((IntIterator)iterator2).nextInt();
            JavaType result2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new PlainJavaArrayType(result2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final JavaType mapAsmType(@NotNull Type type2, @NotNull ClassifierResolutionContext context) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context, "context");
        return this.parseTypeString(new StringCharacterIterator(type2.getDescriptor()), context);
    }

    private final JavaType parseTypeWithoutVarianceAndArray(CharacterIterator signature2, ClassifierResolutionContext context) {
        JavaType javaType;
        switch (signature2.current()) {
            case 'L': {
                javaType = this.parseParameterizedClassRefSignature(signature2, context);
                break;
            }
            case 'T': {
                javaType = this.parseTypeVariableRefSignature(signature2, context);
                break;
            }
            case 'B': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.BYTE);
                break;
            }
            case 'C': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.CHAR);
                break;
            }
            case 'D': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.DOUBLE);
                break;
            }
            case 'F': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.FLOAT);
                break;
            }
            case 'I': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.INT);
                break;
            }
            case 'J': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.LONG);
                break;
            }
            case 'Z': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.BOOLEAN);
                break;
            }
            case 'S': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.SHORT);
                break;
            }
            case 'V': {
                javaType = this.parsePrimitiveType(signature2, null);
                break;
            }
            default: {
                javaType = null;
            }
        }
        return javaType;
    }

    private final JavaType parsePrimitiveType(CharacterIterator signature2, PrimitiveType primitiveType) {
        signature2.next();
        return new PlainJavaPrimitiveType(primitiveType);
    }

    private static final ClassifierResolutionContext.Result parseTypeVariableRefSignature$lambda$0(ClassifierResolutionContext $context, String $parameterName) {
        return $context.resolveTypeParameter$resolution_common_jvm($parameterName);
    }

    private static final ClassifierResolutionContext.Result parseParameterizedClassRefSignature$lambda$1(ClassifierResolutionContext $context, String $internalName) {
        return $context.resolveByInternalName$resolution_common_jvm($internalName);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$ClsFormatException;", "", "", "message", "cause", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V"})
    public static final class ClsFormatException
    extends Throwable {
        public ClsFormatException(@Nullable String message, @Nullable Throwable cause) {
            super(message, cause);
        }

        public /* synthetic */ ClsFormatException(String string2, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(string2, throwable);
        }

        public ClsFormatException() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "", "<init>", "(Ljava/lang/String;I)V", "PLUS", "MINUS", "STAR", "NO_VARIANCE"})
    private static final class JavaSignatureVariance
    extends Enum<JavaSignatureVariance> {
        public static final /* enum */ JavaSignatureVariance PLUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance MINUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance STAR = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance NO_VARIANCE = new JavaSignatureVariance();
        private static final /* synthetic */ JavaSignatureVariance[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JavaSignatureVariance[] values() {
            return (JavaSignatureVariance[])$VALUES.clone();
        }

        public static JavaSignatureVariance valueOf(String value2) {
            return Enum.valueOf(JavaSignatureVariance.class, value2);
        }

        @NotNull
        public static EnumEntries<JavaSignatureVariance> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = javaSignatureVarianceArray = new JavaSignatureVariance[]{JavaSignatureVariance.PLUS, JavaSignatureVariance.MINUS, JavaSignatureVariance.STAR, JavaSignatureVariance.NO_VARIANCE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

