/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaClassifier;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.vavr.VavrAdaptersKt;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0002*+Bk\b\u0002\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000b\u0012\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fB#\b\u0016\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006\u00a2\u0006\u0004\b\u000e\u0010\u0010J%\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0016J\u001b\u0010\u0017\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0015\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b J\r\u0010!\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b%J\u0017\u0010&\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b)R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "", "classesByQName", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassIdToJavaClass;", "typeParameters", "Lio/vavr/collection/Map;", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "Lorg/jetbrains/kotlin/util/vavr/ImmutableMap;", "innerClasses", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "<init>", "(Lkotlin/jvm/functions/Function1;Lio/vavr/collection/Map;Lio/vavr/collection/Map;)V", "(Lkotlin/jvm/functions/Function1;)V", "addInnerClass", "", "innerInternalName", "outerInternalName", "simpleName", "addInnerClass$resolution_common_jvm", "addTypeParameters", "newTypeParameters", "", "addTypeParameters$resolution_common_jvm", "resolveClass", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "classId", "resolveTypeParameter", "name", "resolveTypeParameter$resolution_common_jvm", "copyForMember", "copyForMember$resolution_common_jvm", "mapInternalNameToClassId", "internalName", "mapInternalNameToClassId$resolution_common_jvm", "convertNestedClassInternalNameWithSimpleHeuristic", "convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm", "resolveByInternalName", "resolveByInternalName$resolution_common_jvm", "Result", "InnerClassInfo", "resolution.common.jvm"})
public final class ClassifierResolutionContext {
    @NotNull
    private final Function1<ClassId, JavaClass> classesByQName;
    @NotNull
    private Map<String, JavaTypeParameter> typeParameters;
    @NotNull
    private Map<String, InnerClassInfo> innerClasses;

    private ClassifierResolutionContext(Function1<? super ClassId, ? extends JavaClass> classesByQName, Map<String, JavaTypeParameter> typeParameters2, Map<String, InnerClassInfo> innerClasses) {
        this.classesByQName = classesByQName;
        this.typeParameters = typeParameters2;
        this.innerClasses = innerClasses;
    }

    public ClassifierResolutionContext(@NotNull Function1<? super ClassId, ? extends JavaClass> classesByQName) {
        Intrinsics.checkNotNullParameter(classesByQName, "classesByQName");
        HashMap hashMap = HashMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashMap, "empty(...)");
        Map map2 = hashMap;
        HashMap hashMap2 = HashMap.empty();
        Intrinsics.checkNotNullExpressionValue(hashMap2, "empty(...)");
        this(classesByQName, map2, hashMap2);
    }

    public final void addInnerClass$resolution_common_jvm(@NotNull String innerInternalName, @NotNull String outerInternalName, @NotNull String simpleName2) {
        Intrinsics.checkNotNullParameter(innerInternalName, "innerInternalName");
        Intrinsics.checkNotNullParameter(outerInternalName, "outerInternalName");
        Intrinsics.checkNotNullParameter(simpleName2, "simpleName");
        Map<String, InnerClassInfo> map2 = this.innerClasses.put(innerInternalName, new InnerClassInfo(outerInternalName, simpleName2));
        Intrinsics.checkNotNullExpressionValue(map2, "put(...)");
        this.innerClasses = map2;
    }

    /*
     * WARNING - void declaration
     */
    public final void addTypeParameters$resolution_common_jvm(@NotNull Collection<? extends JavaTypeParameter> newTypeParameters) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter(newTypeParameters, "newTypeParameters");
        if (newTypeParameters.isEmpty()) {
            return;
        }
        Iterable iterable = newTypeParameters;
        Map<String, JavaTypeParameter> map2 = this.typeParameters;
        ClassifierResolutionContext classifierResolutionContext = this;
        boolean $i$f$fold = false;
        Map<String, void> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void typeParameter;
            JavaTypeParameter javaTypeParameter = (JavaTypeParameter)element$iv;
            void acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(acc.put(typeParameter.getName().getIdentifier(), typeParameter), "put(...)");
        }
        classifierResolutionContext.typeParameters = accumulator$iv;
    }

    private final Result resolveClass(ClassId classId) {
        return new Result(this.classesByQName.invoke(classId), classId.asSingleFqName().asString());
    }

    @NotNull
    public final Result resolveTypeParameter$resolution_common_jvm(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new Result(VavrAdaptersKt.getOrNull(this.typeParameters, name), name);
    }

    @NotNull
    public final ClassifierResolutionContext copyForMember$resolution_common_jvm() {
        return new ClassifierResolutionContext(this.classesByQName, this.typeParameters, this.innerClasses);
    }

    @NotNull
    public final ClassId mapInternalNameToClassId$resolution_common_jvm(@NotNull String internalName) {
        InnerClassInfo innerClassInfo;
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        if (StringsKt.contains$default((CharSequence)internalName, '$', false, 2, null) && (innerClassInfo = VavrAdaptersKt.getOrNull(this.innerClasses, internalName)) != null && Name.isValidIdentifier(innerClassInfo.getSimpleName())) {
            ClassId outerClassId = this.mapInternalNameToClassId$resolution_common_jvm(innerClassInfo.getOuterInternalName());
            Name name = Name.identifier(innerClassInfo.getSimpleName());
            Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
            return outerClassId.createNestedClassId(name);
        }
        return ClassId.Companion.topLevel(new FqName(StringsKt.replace$default(internalName, '/', '.', false, 4, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassId convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm(@NotNull String internalName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        SmartList<Integer> splitPoints = new SmartList<Integer>();
        int n = ((CharSequence)internalName).length();
        for (int p = 0; p < n; ++p) {
            char c = internalName.charAt(p);
            if (c != '$' || p <= 0 || internalName.charAt(p - 1) == '/' || p >= internalName.length() - 1 || internalName.charAt(p + 1) == '$') continue;
            splitPoints.add(p);
        }
        if (splitPoints.isEmpty()) {
            return null;
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf(-1), (Iterable)splitPoints), (Iterable)CollectionsKt.plus((Collection)splitPoints, Integer.valueOf(internalName.length())));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Integer from = (Integer)pair.component1();
            Integer to = (Integer)pair.component2();
            int n2 = from + 1;
            Intrinsics.checkNotNull(to);
            String string2 = internalName.substring(n2, to);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            collection.add(string2);
        }
        List substrings = (List)destination$iv$iv;
        FqName outerFqName = new FqName(StringsKt.replace$default((String)substrings.get(0), '/', '.', false, 4, null));
        FqName packageFqName = outerFqName.parent();
        FqName relativeName = new FqName(outerFqName.shortName().asString() + '.' + CollectionsKt.joinToString$default(substrings.subList(1, substrings.size()), ".", null, null, 0, null, null, 62, null));
        return new ClassId(packageFqName, relativeName, false);
    }

    @NotNull
    public final Result resolveByInternalName$resolution_common_jvm(@NotNull String internalName) {
        ClassId realName;
        Result heuristicResult;
        ClassId heuristicName;
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        Result result2 = this.resolveClass(this.mapInternalNameToClassId$resolution_common_jvm(internalName));
        if (result2.getClassifier() == null && StringsKt.contains$default((CharSequence)internalName, '$', false, 2, null) && (heuristicName = this.convertNestedClassInternalNameWithSimpleHeuristic$resolution_common_jvm(internalName)) != null && (heuristicResult = this.resolveClass(heuristicName)).getClassifier() instanceof BinaryJavaClass && Intrinsics.areEqual(heuristicName, realName = ((BinaryJavaClass)heuristicResult.getClassifier()).getContext$resolution_common_jvm().mapInternalNameToClassId$resolution_common_jvm(internalName))) {
            return heuristicResult;
        }
        return result2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0007\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\n\u0010\t"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$InnerClassInfo;", "", "", "outerInternalName", "simpleName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Ljava/lang/String;", "getOuterInternalName", "()Ljava/lang/String;", "getSimpleName"})
    private static final class InnerClassInfo {
        @NotNull
        private final String outerInternalName;
        @NotNull
        private final String simpleName;

        public InnerClassInfo(@NotNull String outerInternalName, @NotNull String simpleName2) {
            Intrinsics.checkNotNullParameter(outerInternalName, "outerInternalName");
            Intrinsics.checkNotNullParameter(simpleName2, "simpleName");
            this.outerInternalName = outerInternalName;
            this.simpleName = simpleName2;
        }

        @NotNull
        public final String getOuterInternalName() {
            return this.outerInternalName;
        }

        @NotNull
        public final String getSimpleName() {
            return this.simpleName;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0013\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0004H\u00d7\u0001\u00a2\u0006\u0004\b\u0015\u0010\u000bR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\tR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "classifier", "", "qualifiedName", "<init>", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;Ljava/lang/String;)V", "component1", "()Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "component2", "()Ljava/lang/String;", "copy", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;Ljava/lang/String;)Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext$Result;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifier;", "getClassifier", "Ljava/lang/String;", "getQualifiedName"})
    public static final class Result {
        @Nullable
        private final JavaClassifier classifier;
        @NotNull
        private final String qualifiedName;

        public Result(@Nullable JavaClassifier classifier2, @NotNull String qualifiedName2) {
            Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
            this.classifier = classifier2;
            this.qualifiedName = qualifiedName2;
        }

        @Nullable
        public final JavaClassifier getClassifier() {
            return this.classifier;
        }

        @NotNull
        public final String getQualifiedName() {
            return this.qualifiedName;
        }

        @Nullable
        public final JavaClassifier component1() {
            return this.classifier;
        }

        @NotNull
        public final String component2() {
            return this.qualifiedName;
        }

        @NotNull
        public final Result copy(@Nullable JavaClassifier classifier2, @NotNull String qualifiedName2) {
            Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
            return new Result(classifier2, qualifiedName2);
        }

        public static /* synthetic */ Result copy$default(Result result2, JavaClassifier javaClassifier, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                javaClassifier = result2.classifier;
            }
            if ((n & 2) != 0) {
                string2 = result2.qualifiedName;
            }
            return result2.copy(javaClassifier, string2);
        }

        @NotNull
        public String toString() {
            return "Result(classifier=" + this.classifier + ", qualifiedName=" + this.qualifiedName + ')';
        }

        public int hashCode() {
            int result2 = this.classifier == null ? 0 : this.classifier.hashCode();
            result2 = result2 * 31 + this.qualifiedName.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.classifier, result2.classifier)) {
                return false;
            }
            return Intrinsics.areEqual(this.qualifiedName, result2.qualifiedName);
        }
    }
}

