/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.source;

import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSourceWithFixedPsi;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementTypeSource;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementTypeSourceWithFixedType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\"\b\b\u0000\u0010\u0005*\u00020\u00042\u0006\u0010\u0006\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\u000b*\u00020\n2\u0006\u0010\f\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ/\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\u000b*\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0007H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J7\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\u000b*\u00020\n2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00072\u0006\u0010\u0017\u001a\u00020\u0016H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J-\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00072\u0006\u0010\u001b\u001a\u00020\u0016H\u0017\u00a2\u0006\u0004\b\u001d\u0010\u0019J-\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001c0\r2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0\u00072\u0006\u0010\u001e\u001a\u00020\u0016H\u0017\u00a2\u0006\u0004\b\u001f\u0010\u0019J/\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\u000b*\u00020\n2\u000e\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u0007H\u0017\u00a2\u0006\u0004\b\"\u0010\u0013J/\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\u000b*\u00020\n2\u000e\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0\u0007H\u0017\u00a2\u0006\u0004\b%\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaFixedElementSourceFactory;", "Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementSourceFactory;", "<init>", "()V", "Lcom/intellij/psi/PsiElement;", "PSI", "psi", "Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementPsiSource;", "createPsiSource", "(Lcom/intellij/psi/PsiElement;)Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementPsiSource;", "Lcom/intellij/psi/PsiType;", "TYPE", "type", "Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementTypeSource;", "createTypeSource", "(Lcom/intellij/psi/PsiType;)Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementTypeSource;", "Lcom/intellij/psi/PsiVariable;", "psiVariableSource", "createVariableReturnTypeSource", "(Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementPsiSource;)Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementTypeSource;", "Lcom/intellij/psi/PsiTypeParameter;", "psiTypeParameterSource", "", "boundIndex", "createTypeParameterUpperBoundTypeSource", "(Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementPsiSource;I)Lorg/jetbrains/kotlin/load/java/structure/impl/source/JavaElementTypeSource;", "Lcom/intellij/psi/PsiClass;", "superTypeIndex", "Lcom/intellij/psi/PsiClassType;", "createSuperTypeSource", "permittedTypeIndex", "createPermittedTypeSource", "Lcom/intellij/psi/PsiExpression;", "psiExpressionSource", "createExpressionTypeSource", "Lcom/intellij/psi/PsiMethod;", "psiMethodSource", "createMethodReturnTypeSource"})
public final class JavaFixedElementSourceFactory
extends JavaElementSourceFactory {
    @Override
    @NotNull
    public <PSI extends PsiElement> JavaElementPsiSource<PSI> createPsiSource(@NotNull PSI psi) {
        Intrinsics.checkNotNullParameter(psi, "psi");
        return new JavaElementPsiSourceWithFixedPsi<PSI>(psi);
    }

    @Override
    @NotNull
    public <TYPE extends PsiType> JavaElementTypeSource<TYPE> createTypeSource(@NotNull TYPE type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return new JavaElementTypeSourceWithFixedType<TYPE>(type2, this);
    }

    @Override
    @NotNull
    public <TYPE extends PsiType> JavaElementTypeSource<TYPE> createVariableReturnTypeSource(@NotNull JavaElementPsiSource<? extends PsiVariable> psiVariableSource) {
        Intrinsics.checkNotNullParameter(psiVariableSource, "psiVariableSource");
        PsiType psiType = psiVariableSource.getPsi().getType();
        Intrinsics.checkNotNull(psiType, "null cannot be cast to non-null type TYPE of org.jetbrains.kotlin.load.java.structure.impl.source.JavaFixedElementSourceFactory.createVariableReturnTypeSource");
        return this.createTypeSource(psiType);
    }

    @Override
    @NotNull
    public <TYPE extends PsiType> JavaElementTypeSource<TYPE> createTypeParameterUpperBoundTypeSource(@NotNull JavaElementPsiSource<? extends PsiTypeParameter> psiTypeParameterSource, int boundIndex) {
        Intrinsics.checkNotNullParameter(psiTypeParameterSource, "psiTypeParameterSource");
        JvmReferenceType jvmReferenceType = psiTypeParameterSource.getPsi().getBounds()[boundIndex];
        Intrinsics.checkNotNull(jvmReferenceType, "null cannot be cast to non-null type TYPE of org.jetbrains.kotlin.load.java.structure.impl.source.JavaFixedElementSourceFactory.createTypeParameterUpperBoundTypeSource");
        return this.createTypeSource((PsiType)((Object)jvmReferenceType));
    }

    @Override
    @NotNull
    public JavaElementTypeSource<PsiClassType> createSuperTypeSource(@NotNull JavaElementPsiSource<? extends PsiClass> psiTypeParameterSource, int superTypeIndex) {
        Intrinsics.checkNotNullParameter(psiTypeParameterSource, "psiTypeParameterSource");
        PsiClassType psiClassType = psiTypeParameterSource.getPsi().getSuperTypes()[superTypeIndex];
        Intrinsics.checkNotNullExpressionValue(psiClassType, "get(...)");
        return this.createTypeSource((PsiType)psiClassType);
    }

    @Override
    @NotNull
    public JavaElementTypeSource<PsiClassType> createPermittedTypeSource(@NotNull JavaElementPsiSource<? extends PsiClass> psiTypeParameterSource, int permittedTypeIndex) {
        Intrinsics.checkNotNullParameter(psiTypeParameterSource, "psiTypeParameterSource");
        PsiClassType psiClassType = psiTypeParameterSource.getPsi().getPermitsListTypes()[permittedTypeIndex];
        Intrinsics.checkNotNullExpressionValue(psiClassType, "get(...)");
        return this.createTypeSource((PsiType)psiClassType);
    }

    @Override
    @NotNull
    public <TYPE extends PsiType> JavaElementTypeSource<TYPE> createExpressionTypeSource(@NotNull JavaElementPsiSource<? extends PsiExpression> psiExpressionSource) {
        Intrinsics.checkNotNullParameter(psiExpressionSource, "psiExpressionSource");
        PsiType psiType = psiExpressionSource.getPsi().getType();
        Intrinsics.checkNotNull(psiType, "null cannot be cast to non-null type TYPE of org.jetbrains.kotlin.load.java.structure.impl.source.JavaFixedElementSourceFactory.createExpressionTypeSource");
        return this.createTypeSource(psiType);
    }

    @Override
    @NotNull
    public <TYPE extends PsiType> JavaElementTypeSource<TYPE> createMethodReturnTypeSource(@NotNull JavaElementPsiSource<? extends PsiMethod> psiMethodSource) {
        Intrinsics.checkNotNullParameter(psiMethodSource, "psiMethodSource");
        PsiType psiType = psiMethodSource.getPsi().getReturnType();
        if (psiType == null) {
            throw new IllegalStateException(("Method is not a constructor and has no return type: " + psiMethodSource.getPsi().getName()).toString());
        }
        PsiType psiType2 = psiType;
        return this.createTypeSource(psiType2);
    }
}

