/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0019\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H'\u00a2\u0006\u0004\b\t\u0010\bJ!\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "<init>", "()V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lcom/intellij/openapi/vfs/VirtualFile;", "findVirtualFileWithHeader", "(Lorg/jetbrains/kotlin/name/ClassId;)Lcom/intellij/openapi/vfs/VirtualFile;", "findSourceOrBinaryVirtualFile", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "findKotlinClassOrContent", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;)Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "javaClass", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;)Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "jClass", "", "classFileName", "(Lorg/jetbrains/kotlin/load/java/structure/JavaClass;)Ljava/lang/String;", "SERVICE"})
public abstract class VirtualFileFinder
implements KotlinClassFinder {
    @NotNull
    public static final SERVICE SERVICE = new SERVICE(null);

    @Nullable
    public abstract VirtualFile findVirtualFileWithHeader(@NotNull ClassId var1);

    @Nullable
    public abstract VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId var1);

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, file2, metadataVersion, null, 4, null);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass, @NotNull MetadataVersion metadataVersion) {
        Intrinsics.checkNotNullParameter(javaClass, "javaClass");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Object object = javaClass instanceof VirtualFileBoundJavaClass ? (VirtualFileBoundJavaClass)javaClass : null;
        if (object == null || (object = object.getVirtualFile()) == null) {
            return null;
        }
        Object file2 = object;
        if (javaClass.getOuterClass() != null) {
            VirtualFile virtualFile = ((VirtualFile)file2).getParent();
            Intrinsics.checkNotNull(virtualFile);
            VirtualFile $this$sure$iv = virtualFile.findChild(this.classFileName(javaClass) + ".class");
            boolean $i$f$sure = false;
            VirtualFile virtualFile2 = $this$sure$iv;
            if (virtualFile2 == null) {
                boolean bl = false;
                String string2 = "Virtual file not found for " + javaClass;
                throw new AssertionError((Object)string2);
            }
            file2 = virtualFile2;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, (VirtualFile)file2, metadataVersion, null, 4, null);
    }

    private final String classFileName(JavaClass jClass) {
        String string2 = jClass.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        String simpleName2 = string2;
        JavaClass javaClass = jClass.getOuterClass();
        if (javaClass == null) {
            return simpleName2;
        }
        JavaClass outerClass = javaClass;
        return this.classFileName(outerClass) + '$' + simpleName2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\t\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder$SERVICE;", "", "<init>", "()V", "Lcom/intellij/openapi/project/Project;", "project", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "getInstance", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "(Lcom/intellij/openapi/project/Project;)Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;"})
    public static final class SERVICE {
        private SERVICE() {
        }

        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(module2, "module");
            return VirtualFileFinderFactory.SERVICE.getInstance(project).create(project, module2);
        }

        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter(project, "project");
            VirtualFileFinderFactory virtualFileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
            Intrinsics.checkNotNullExpressionValue(globalSearchScope, "allScope(...)");
            return virtualFileFinderFactory.create(globalSearchScope);
        }

        public /* synthetic */ SERVICE(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

