/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.FileBasedKotlinClass;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.PerformanceCounter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \"2\u00020\u0001:\u0001\"B1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0015\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0014\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0096\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0016\u0010!\u001a\u0004\u0018\u00010\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass;", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass;", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lorg/jetbrains/kotlin/name/ClassId;", "className", "", "classVersion", "Lorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;", "classHeader", "Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;", "innerClasses", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/name/ClassId;ILorg/jetbrains/kotlin/load/kotlin/header/KotlinClassHeader;Lorg/jetbrains/kotlin/load/kotlin/FileBasedKotlinClass$InnerClassesInfo;)V", "", "getFileContents", "()[B", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getLocation", "location", "getContainingLibrary", "containingLibrary", "Factory"})
public final class VirtualFileKotlinClass
extends FileBasedKotlinClass {
    @NotNull
    public static final Factory Factory = new Factory(null);
    @NotNull
    private final VirtualFile file;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final PerformanceCounter perfCounter;

    private VirtualFileKotlinClass(VirtualFile file2, ClassId className, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
        super(className, classVersion, classHeader, innerClasses);
        this.file = file2;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public String getLocation() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        return string2;
    }

    @Override
    @Nullable
    public String getContainingLibrary() {
        String string2 = this.file.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getPath(...)");
        String[] stringArray = new String[]{"!/"};
        return (String)CollectionsKt.firstOrNull(StringsKt.split$default((CharSequence)string2, stringArray, false, 0, 6, null));
    }

    @Override
    @NotNull
    protected byte[] getFileContents() {
        try {
            byte[] byArray = this.file.contentsToByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "contentsToByteArray(...)");
            return byArray;
        }
        catch (IOException e) {
            throw VirtualFileKotlinClass.Factory.logFileReadingErrorMessage(e, this.file);
        }
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof VirtualFileKotlinClass && Intrinsics.areEqual(((VirtualFileKotlinClass)other).file, this.file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file;
    }

    public /* synthetic */ VirtualFileKotlinClass(VirtualFile file2, ClassId className, int classVersion, KotlinClassHeader classHeader, FileBasedKotlinClass.InnerClassesInfo innerClasses, DefaultConstructorMarker $constructor_marker) {
        this(file2, className, classVersion, classHeader, innerClasses);
    }

    static {
        Logger logger = Logger.getInstance(VirtualFileKotlinClass.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        perfCounter = PerformanceCounter.Companion.create$default(PerformanceCounter.Companion, "Binary class from Kotlin file", false, 2, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0017\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00168\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClass$Factory;", "", "<init>", "()V", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersion", "", "fileContent", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "create$frontend_common_jvm", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;[B)Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "create", "", "e", "logFileReadingErrorMessage", "(Ljava/lang/Throwable;Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/Throwable;", "", "renderFileReadingErrorMessage", "(Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/lang/String;", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/kotlin/util/PerformanceCounter;", "perfCounter", "Lorg/jetbrains/kotlin/util/PerformanceCounter;"})
    public static final class Factory {
        private Factory() {
        }

        @Nullable
        public final KotlinClassFinder.Result create$frontend_common_jvm(@NotNull VirtualFile file2, @NotNull MetadataVersion metadataVersion, @Nullable byte[] fileContent) {
            Intrinsics.checkNotNullParameter(file2, "file");
            Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
            return perfCounter.time(() -> Factory.create$lambda$3(file2, fileContent, metadataVersion));
        }

        private final Throwable logFileReadingErrorMessage(Throwable e, VirtualFile file2) {
            String errorMessage2 = this.renderFileReadingErrorMessage(file2);
            LOG.warn(errorMessage2, e);
            return new IllegalStateException(errorMessage2, e);
        }

        private final String renderFileReadingErrorMessage(VirtualFile file2) {
            return "Could not read file: " + file2.getPath() + "; size in bytes: " + file2.getLength() + "; file type: " + file2.getFileType().getName();
        }

        private static final VirtualFileKotlinClass create$lambda$3$lambda$1(VirtualFile $file, ClassId name, Integer classVersion, KotlinClassHeader header, FileBasedKotlinClass.InnerClassesInfo innerClasses) {
            Intrinsics.checkNotNull(name);
            Intrinsics.checkNotNull(classVersion);
            int n = classVersion;
            Intrinsics.checkNotNull(header);
            Intrinsics.checkNotNull(innerClasses);
            return new VirtualFileKotlinClass($file, name, n, header, innerClasses, null);
        }

        private static final KotlinClassFinder.Result create$lambda$3(VirtualFile $file, byte[] $fileContent, MetadataVersion $metadataVersion) {
            boolean bl;
            boolean bl2 = bl = Intrinsics.areEqual($file.getExtension(), JavaClassFileType.INSTANCE.getDefaultExtension()) || Intrinsics.areEqual($file.getFileType(), JavaClassFileType.INSTANCE);
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22 = false;
                String $i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22 = "Trying to read binary data from a non-class file " + $file;
                throw new AssertionError((Object)$i$a$-assert-VirtualFileKotlinClass$Factory$create$1$22);
            }
            try {
                byte[] byteContent;
                byte[] byArray = $fileContent;
                if ($fileContent == null) {
                    byte[] byArray2 = $file.contentsToByteArray(false);
                    byArray = byArray2;
                    Intrinsics.checkNotNullExpressionValue(byArray2, "contentsToByteArray(...)");
                }
                if (!((byteContent = byArray).length == 0)) {
                    KotlinClassFinder.Result result2;
                    VirtualFileKotlinClass kotlinJvmBinaryClass;
                    VirtualFileKotlinClass virtualFileKotlinClass = kotlinJvmBinaryClass = FileBasedKotlinClass.create(byteContent, $metadataVersion, (arg_0, arg_1, arg_2, arg_3) -> Factory.create$lambda$3$lambda$1($file, arg_0, arg_1, arg_2, arg_3));
                    if (virtualFileKotlinClass != null) {
                        VirtualFileKotlinClass it = virtualFileKotlinClass;
                        boolean bl3 = false;
                        result2 = new KotlinClassFinder.Result.KotlinClass(it, byteContent);
                    } else {
                        result2 = new KotlinClassFinder.Result.ClassFileContent(byteContent);
                    }
                    return result2;
                }
            }
            catch (FileNotFoundException byteContent) {
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw Factory.logFileReadingErrorMessage(e, $file);
            }
            return null;
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

