/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.deserialization;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u000f\u0010\u0014\u001a\u00020\u0000H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0011R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0005\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "", "versionArray", "", "isStrictSemantics", "<init>", "([IZ)V", "", "numbers", "([I)V", "lastSupportedVersionWithThisLanguageVersion", "(Z)Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "isCompatibleWithCurrentCompilerVersion", "()Z", "metadataVersionFromLanguageVersion", "isCompatible", "(Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;)Z", "limitVersion", "isCompatibleInternal", "next", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "other", "newerThan", "Z", "Companion"})
public final class MetadataVersion
extends BinaryVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isStrictSemantics;
    @NotNull
    public static final MetadataVersion INSTANCE;
    @NotNull
    public static final MetadataVersion INSTANCE_NEXT;
    @NotNull
    public static final MetadataVersion INVALID_VERSION;

    public MetadataVersion(@NotNull int[] versionArray, boolean isStrictSemantics) {
        Intrinsics.checkNotNullParameter(versionArray, "versionArray");
        super(Arrays.copyOf(versionArray, versionArray.length));
        this.isStrictSemantics = isStrictSemantics;
    }

    public final boolean isStrictSemantics() {
        return this.isStrictSemantics;
    }

    public MetadataVersion(int ... numbers) {
        Intrinsics.checkNotNullParameter(numbers, "numbers");
        this(numbers, false);
    }

    @NotNull
    public final MetadataVersion lastSupportedVersionWithThisLanguageVersion(boolean isStrictSemantics) {
        MetadataVersion forwardCompatibility = isStrictSemantics ? INSTANCE : INSTANCE_NEXT;
        return forwardCompatibility.newerThan(this) ? forwardCompatibility : this;
    }

    @Override
    public boolean isCompatibleWithCurrentCompilerVersion() {
        return this.isCompatibleInternal(this.isStrictSemantics ? INSTANCE : INSTANCE_NEXT);
    }

    public final boolean isCompatible(@NotNull MetadataVersion metadataVersionFromLanguageVersion) {
        Intrinsics.checkNotNullParameter(metadataVersionFromLanguageVersion, "metadataVersionFromLanguageVersion");
        MetadataVersion limitVersion = metadataVersionFromLanguageVersion.lastSupportedVersionWithThisLanguageVersion(this.isStrictSemantics);
        return this.isCompatibleInternal(limitVersion);
    }

    private final boolean isCompatibleInternal(MetadataVersion limitVersion) {
        if (this.getMajor() == 1 && this.getMinor() == 0) {
            return false;
        }
        if (this.getMajor() == 0) {
            return false;
        }
        return !this.newerThan(limitVersion);
    }

    @NotNull
    public final MetadataVersion next() {
        MetadataVersion metadataVersion;
        if (this.getMajor() == 1 && this.getMinor() == 9) {
            int[] nArray = new int[]{2, 0, 0};
            MetadataVersion metadataVersion2 = new MetadataVersion(nArray);
            metadataVersion = metadataVersion2;
        } else {
            int[] nArray = new int[]{this.getMajor(), this.getMinor() + 1, 0};
            MetadataVersion metadataVersion3 = new MetadataVersion(nArray);
            metadataVersion = metadataVersion3;
        }
        return metadataVersion;
    }

    private final boolean newerThan(MetadataVersion other) {
        return this.getMajor() > other.getMajor() ? true : (this.getMajor() < other.getMajor() ? false : this.getMinor() > other.getMinor());
    }

    static {
        int[] nArray = new int[]{2, 1, 0};
        INSTANCE = new MetadataVersion(nArray);
        INSTANCE_NEXT = INSTANCE.next();
        INVALID_VERSION = new MetadataVersion(new int[0]);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "INSTANCE", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "INSTANCE_NEXT", "INVALID_VERSION"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

