/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirementTable;
import org.jetbrains.kotlin.protobuf.MessageLiteOrBuilder;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001f\u001eB3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\nH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\t\u001a\u0004\u0018\u00010\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u001c\u001a\u0004\b\u001d\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;", "version", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$VersionRequirement$VersionKind;", "kind", "Lkotlin/DeprecationLevel;", "level", "", "errorCode", "", "message", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;Lorg/jetbrains/kotlin/metadata/ProtoBuf$VersionRequirement$VersionKind;Lkotlin/DeprecationLevel;Ljava/lang/Integer;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$VersionRequirement$VersionKind;", "getKind", "()Lorg/jetbrains/kotlin/metadata/ProtoBuf$VersionRequirement$VersionKind;", "Lkotlin/DeprecationLevel;", "getLevel", "()Lkotlin/DeprecationLevel;", "Ljava/lang/Integer;", "getErrorCode", "()Ljava/lang/Integer;", "Ljava/lang/String;", "getMessage", "Companion", "Version"})
public final class VersionRequirement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Version version;
    @NotNull
    private final ProtoBuf.VersionRequirement.VersionKind kind;
    @NotNull
    private final DeprecationLevel level;
    @Nullable
    private final Integer errorCode;
    @Nullable
    private final String message;

    public VersionRequirement(@NotNull Version version, @NotNull ProtoBuf.VersionRequirement.VersionKind kind, @NotNull DeprecationLevel level, @Nullable Integer errorCode, @Nullable String message) {
        Intrinsics.checkNotNullParameter(version, "version");
        Intrinsics.checkNotNullParameter(kind, "kind");
        Intrinsics.checkNotNullParameter((Object)level, "level");
        this.version = version;
        this.kind = kind;
        this.level = level;
        this.errorCode = errorCode;
        this.message = message;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    @NotNull
    public final ProtoBuf.VersionRequirement.VersionKind getKind() {
        return this.kind;
    }

    @NotNull
    public final DeprecationLevel getLevel() {
        return this.level;
    }

    @Nullable
    public final Integer getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public String toString() {
        return "since " + this.version + ' ' + (Object)((Object)this.level) + (this.errorCode != null ? " error " + this.errorCode : "") + (this.message != null ? ": " + this.message : "");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/protobuf/MessageLiteOrBuilder;", "proto", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "nameResolver", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirementTable;", "table", "", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "create", "(Lorg/jetbrains/kotlin/protobuf/MessageLiteOrBuilder;Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirementTable;)Ljava/util/List;", "", "id", "(ILorg/jetbrains/kotlin/metadata/deserialization/NameResolver;Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirementTable;)Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<VersionRequirement> create(@NotNull MessageLiteOrBuilder proto, @NotNull NameResolver nameResolver, @NotNull VersionRequirementTable table) {
            void $this$mapNotNullTo$iv$iv;
            List<Integer> list;
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
            Intrinsics.checkNotNullParameter(table, "table");
            MessageLiteOrBuilder messageLiteOrBuilder = proto;
            if (messageLiteOrBuilder instanceof ProtoBuf.Class) {
                list = ((ProtoBuf.Class)proto).getVersionRequirementList();
            } else if (messageLiteOrBuilder instanceof ProtoBuf.Constructor) {
                list = ((ProtoBuf.Constructor)proto).getVersionRequirementList();
            } else if (messageLiteOrBuilder instanceof ProtoBuf.Function) {
                list = ((ProtoBuf.Function)proto).getVersionRequirementList();
            } else if (messageLiteOrBuilder instanceof ProtoBuf.Property) {
                list = ((ProtoBuf.Property)proto).getVersionRequirementList();
            } else if (messageLiteOrBuilder instanceof ProtoBuf.TypeAlias) {
                list = ((ProtoBuf.TypeAlias)proto).getVersionRequirementList();
            } else {
                throw new IllegalStateException("Unexpected declaration: " + proto.getClass());
            }
            List<Integer> ids = list;
            Intrinsics.checkNotNull(ids);
            Iterable $this$mapNotNull$iv = ids;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                VersionRequirement it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Integer id = (Integer)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(id);
                if (Companion.create(id, nameResolver, table) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public final VersionRequirement create(int id, @NotNull NameResolver nameResolver, @NotNull VersionRequirementTable table) {
            DeprecationLevel deprecationLevel;
            Intrinsics.checkNotNullParameter(nameResolver, "nameResolver");
            Intrinsics.checkNotNullParameter(table, "table");
            ProtoBuf.VersionRequirement versionRequirement = table.get(id);
            if (versionRequirement == null) {
                return null;
            }
            ProtoBuf.VersionRequirement info = versionRequirement;
            Version version = Version.Companion.decode(info.hasVersion() ? Integer.valueOf(info.getVersion()) : null, info.hasVersionFull() ? Integer.valueOf(info.getVersionFull()) : null);
            ProtoBuf.VersionRequirement.Level level = info.getLevel();
            Intrinsics.checkNotNull(level);
            switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                case 1: {
                    deprecationLevel = DeprecationLevel.WARNING;
                    break;
                }
                case 2: {
                    deprecationLevel = DeprecationLevel.ERROR;
                    break;
                }
                case 3: {
                    deprecationLevel = DeprecationLevel.HIDDEN;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            DeprecationLevel level2 = deprecationLevel;
            Integer errorCode = info.hasErrorCode() ? Integer.valueOf(info.getErrorCode()) : null;
            String message = info.hasMessage() ? nameResolver.getString(info.getMessage()) : null;
            ProtoBuf.VersionRequirement.VersionKind versionKind = info.getVersionKind();
            Intrinsics.checkNotNullExpressionValue(versionKind, "getVersionKind(...)");
            return new VersionRequirement(version, versionKind, level2, errorCode, message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ProtoBuf.VersionRequirement.Level.values().length];
                try {
                    nArray[ProtoBuf.VersionRequirement.Level.WARNING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.VersionRequirement.Level.ERROR.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ProtoBuf.VersionRequirement.Level.HIDDEN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0007\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u000f\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u0011\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0013J.\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c7\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001f\u0010\u0013R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b \u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;", "", "", "major", "minor", "patch", "<init>", "(III)V", "", "asString", "()Ljava/lang/String;", "Lkotlin/Function1;", "", "writeVersion", "writeVersionFull", "encode", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "toString", "component1", "()I", "component2", "component3", "copy", "(III)Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "I", "getMajor", "getMinor", "getPatch", "Companion"})
    public static final class Version {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int major;
        private final int minor;
        private final int patch;
        @NotNull
        public static final Version INFINITY = new Version(256, 256, 256);

        public Version(int major, int minor, int patch) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
        }

        public /* synthetic */ Version(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n4 & 4) != 0) {
                n3 = 0;
            }
            this(n, n2, n3);
        }

        public final int getMajor() {
            return this.major;
        }

        public final int getMinor() {
            return this.minor;
        }

        public final int getPatch() {
            return this.patch;
        }

        @NotNull
        public final String asString() {
            return this.patch == 0 ? "" + this.major + '.' + this.minor : "" + this.major + '.' + this.minor + '.' + this.patch;
        }

        public final void encode(@NotNull Function1<? super Integer, Unit> writeVersion, @NotNull Function1<? super Integer, Unit> writeVersionFull) {
            Intrinsics.checkNotNullParameter(writeVersion, "writeVersion");
            Intrinsics.checkNotNullParameter(writeVersionFull, "writeVersionFull");
            if (!Intrinsics.areEqual(this, INFINITY)) {
                if (this.major > 7 || this.minor > 15 || this.patch > 127) {
                    writeVersionFull.invoke((Integer)(this.major | this.minor << 8 | this.patch << 16));
                } else {
                    writeVersion.invoke((Integer)(this.major | this.minor << 3 | this.patch << 7));
                }
            }
        }

        @NotNull
        public String toString() {
            return this.asString();
        }

        public final int component1() {
            return this.major;
        }

        public final int component2() {
            return this.minor;
        }

        public final int component3() {
            return this.patch;
        }

        @NotNull
        public final Version copy(int major, int minor, int patch) {
            return new Version(major, minor, patch);
        }

        public static /* synthetic */ Version copy$default(Version version, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = version.major;
            }
            if ((n4 & 2) != 0) {
                n2 = version.minor;
            }
            if ((n4 & 4) != 0) {
                n3 = version.patch;
            }
            return version.copy(n, n2, n3);
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.major);
            result2 = result2 * 31 + Integer.hashCode(this.minor);
            result2 = result2 * 31 + Integer.hashCode(this.patch);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            Version version = (Version)other;
            if (this.major != version.major) {
                return false;
            }
            if (this.minor != version.minor) {
                return false;
            }
            return this.patch == version.patch;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0010R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version$Companion;", "", "<init>", "()V", "INFINITY", "Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;", "MAJOR_BITS", "", "MINOR_BITS", "PATCH_BITS", "MAJOR_MASK", "MINOR_MASK", "PATCH_MASK", "decode", "version", "versionFull", "(Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement$Version;", "metadata"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Version decode(@Nullable Integer version, @Nullable Integer versionFull) {
                return versionFull != null ? new Version((int)(versionFull & 0xFF), versionFull >> 8 & 0xFF, versionFull >> 16 & 0xFF) : (version != null ? new Version(version & 7, version >> 3 & 0xF, version >> 7 & 0x7F) : INFINITY);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

