/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.deserialization;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.builtins.BuiltInsProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.MetadataVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.metadata.deserialization.VersionSpecificBehaviorKt;
import org.jetbrains.kotlin.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BinaryModuleData;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB5\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\n\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "version", "", "", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "packageFqName2Parts", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "moduleData", "debugName", "<init>", "(Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;Ljava/util/Map;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;Ljava/lang/String;)V", "packageFqName", "findPackageParts", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "getVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "Ljava/util/Map;", "getPackageFqName2Parts", "()Ljava/util/Map;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "getModuleData", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "Ljava/lang/String;", "Companion"})
public final class ModuleMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MetadataVersion version;
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    @NotNull
    private final BinaryModuleData moduleData;
    @NotNull
    private final String debugName;
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @NotNull
    public static final ModuleMapping EMPTY = new ModuleMapping(MetadataVersion.INSTANCE, MapsKt.emptyMap(), org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "EMPTY");
    @NotNull
    public static final ModuleMapping CORRUPTED = new ModuleMapping(MetadataVersion.INSTANCE, MapsKt.emptyMap(), org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping$Companion.access$emptyBinaryData(Companion), "CORRUPTED");
    public static final int STRICT_METADATA_VERSION_SEMANTICS_FLAG = 1;

    private ModuleMapping(MetadataVersion version, Map<String, PackageParts> packageFqName2Parts, BinaryModuleData moduleData2, String debugName) {
        this.version = version;
        this.packageFqName2Parts = packageFqName2Parts;
        this.moduleData = moduleData2;
        this.debugName = debugName;
    }

    @NotNull
    public final MetadataVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    @NotNull
    public final BinaryModuleData getModuleData() {
        return this.moduleData;
    }

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    public /* synthetic */ ModuleMapping(MetadataVersion version, Map packageFqName2Parts, BinaryModuleData moduleData2, String debugName, DefaultConstructorMarker $constructor_marker) {
        this(version, packageFqName2Parts, moduleData2, debugName);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJO\u0010\u0016\u001a\u00020\u00152\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J=\u0010\u001e\u001a\u0004\u0018\u00010\u000b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u000b8\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00158\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&R\u0014\u0010(\u001a\u00020\u00198\u0006X\u0087T\u00a2\u0006\u0006\n\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping$Companion;", "", "<init>", "()V", "Ljava/io/DataInputStream;", "stream", "", "readVersionNumber", "(Ljava/io/DataInputStream;)[I", "", "bytes", "", "debugName", "", "skipMetadataVersionCheck", "isJvmPackageNameSupported", "Lorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;", "metadataVersionFromLanguageVersion", "Lkotlin/Function1;", "", "reportIncompatibleVersionError", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "loadModuleMapping", "([BLjava/lang/String;ZZLorg/jetbrains/kotlin/metadata/deserialization/MetadataVersion;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "", "", "multifileFacadeIds", "multifileFacadeShortNames", "index", "packageFqName", "loadMultiFileFacadeInternalName", "(Ljava/util/List;Ljava/util/List;ILjava/lang/String;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "emptyBinaryData", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/BinaryModuleData;", "MAPPING_FILE_EXT", "Ljava/lang/String;", "EMPTY", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "CORRUPTED", "STRICT_METADATA_VERSION_SEMANTICS_FLAG", "I"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final int[] readVersionNumber(@NotNull DataInputStream stream) {
            int[] nArray;
            Intrinsics.checkNotNullParameter(stream, "stream");
            try {
                int[] nArray2;
                int size = stream.readInt();
                if (size < 0 || size > 1024) {
                    nArray2 = null;
                } else {
                    int n = 0;
                    int[] nArray3 = new int[size];
                    while (n < size) {
                        int n2 = n++;
                        nArray3[n2] = stream.readInt();
                    }
                    nArray2 = nArray3;
                }
                nArray = nArray2;
            }
            catch (IOException e) {
                nArray = null;
            }
            return nArray;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping loadModuleMapping(@Nullable byte[] bytes, @NotNull String debugName, boolean skipMetadataVersionCheck, boolean isJvmPackageNameSupported, @NotNull MetadataVersion metadataVersionFromLanguageVersion, @NotNull Function1<? super MetadataVersion, Unit> reportIncompatibleVersionError) {
            void $this$mapTo$iv$iv;
            ProtoBuf.Annotation jvmPackageName;
            Object packageParts;
            PackageParts answer$iv;
            Object value$iv;
            ExtensionRegistryLite extensionRegistryLite;
            Intrinsics.checkNotNullParameter(debugName, "debugName");
            Intrinsics.checkNotNullParameter(metadataVersionFromLanguageVersion, "metadataVersionFromLanguageVersion");
            Intrinsics.checkNotNullParameter(reportIncompatibleVersionError, "reportIncompatibleVersionError");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream = new DataInputStream(new ByteArrayInputStream(bytes));
            int[] nArray = this.readVersionNumber(stream);
            if (nArray == null) {
                return CORRUPTED;
            }
            int[] versionNumber = nArray;
            MetadataVersion preVersion = new MetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (!skipMetadataVersionCheck && !preVersion.isCompatible(metadataVersionFromLanguageVersion)) {
                reportIncompatibleVersionError.invoke(preVersion);
                return EMPTY;
            }
            int flags = VersionSpecificBehaviorKt.isKotlin1Dot4OrLater(preVersion) ? stream.readInt() : 0;
            MetadataVersion version = new MetadataVersion(versionNumber, (flags & 1) != 0);
            if (!skipMetadataVersionCheck && !version.isCompatible(metadataVersionFromLanguageVersion)) {
                reportIncompatibleVersionError.invoke(version);
                return EMPTY;
            }
            ExtensionRegistryLite p0 = extensionRegistryLite = ExtensionRegistryLite.newInstance();
            boolean bl = false;
            BuiltInsProtoBuf.registerAllExtensions(p0);
            ExtensionRegistryLite extensions = extensionRegistryLite;
            JvmModuleProtoBuf.Module module2 = JvmModuleProtoBuf.Module.parseFrom(stream, extensions);
            if (module2 == null) {
                return EMPTY;
            }
            JvmModuleProtoBuf.Module moduleProto = module2;
            LinkedHashMap result2 = new LinkedHashMap();
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getPackagePartsList()) {
                String partShortName;
                Object object;
                String packageFqName = proto.getPackageFqName();
                Iterator $this$getOrPut$iv = result2;
                int $i$f$getOrPut = 0;
                value$iv = $this$getOrPut$iv.get(packageFqName);
                if (value$iv == null) {
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(packageFqName);
                    answer$iv = new PackageParts(packageFqName);
                    $this$getOrPut$iv.put(packageFqName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                packageParts = (PackageParts)object;
                $this$getOrPut$iv = ((Iterable)proto.getShortClassNameList()).iterator();
                $i$f$getOrPut = 0;
                while ($this$getOrPut$iv.hasNext()) {
                    int index2 = $i$f$getOrPut++;
                    partShortName = (String)$this$getOrPut$iv.next();
                    Intrinsics.checkNotNull(packageFqName);
                    Intrinsics.checkNotNull(partShortName);
                    String string2 = ModuleMappingKt.access$internalNameOf(packageFqName, partShortName);
                    List<Integer> list = proto.getMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(list, "getMultifileFacadeShortNameIdList(...)");
                    ProtocolStringList protocolStringList = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList, "getMultifileFacadeShortNameList(...)");
                    ((PackageParts)packageParts).addPart(string2, this.loadMultiFileFacadeInternalName(list, protocolStringList, index2, packageFqName));
                }
                if (!isJvmPackageNameSupported) continue;
                $this$getOrPut$iv = ((Iterable)proto.getClassWithJvmPackageNameShortNameList()).iterator();
                $i$f$getOrPut = 0;
                while ($this$getOrPut$iv.hasNext()) {
                    int n;
                    int index3 = $i$f$getOrPut++;
                    partShortName = (String)$this$getOrPut$iv.next();
                    List<Integer> list = proto.getClassWithJvmPackageNamePackageIdList();
                    Intrinsics.checkNotNullExpressionValue(list, "getClassWithJvmPackageNamePackageIdList(...)");
                    Integer n2 = CollectionsKt.getOrNull(list, index3);
                    if (n2 != null) {
                        n = n2;
                    } else {
                        List<Integer> list2 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkNotNullExpressionValue(list2, "getClassWithJvmPackageNamePackageIdList(...)");
                        Integer n3 = CollectionsKt.lastOrNull(list2);
                        if (n3 == null) continue;
                        n = n3;
                    }
                    int packageId = n;
                    ProtocolStringList protocolStringList = moduleProto.getJvmPackageNameList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList, "getJvmPackageNameList(...)");
                    if ((String)CollectionsKt.getOrNull(protocolStringList, packageId) == null) continue;
                    Intrinsics.checkNotNull(partShortName);
                    String string3 = ModuleMappingKt.access$internalNameOf((String)((Object)jvmPackageName), partShortName);
                    List<Integer> list3 = proto.getClassWithJvmPackageNameMultifileFacadeShortNameIdList();
                    Intrinsics.checkNotNullExpressionValue(list3, "getClassWithJvmPackageNa\u2026acadeShortNameIdList(...)");
                    ProtocolStringList protocolStringList2 = proto.getMultifileFacadeShortNameList();
                    Intrinsics.checkNotNullExpressionValue(protocolStringList2, "getMultifileFacadeShortNameList(...)");
                    ((PackageParts)packageParts).addPart(string3, this.loadMultiFileFacadeInternalName(list3, protocolStringList2, index3, (String)((Object)jvmPackageName)));
                }
            }
            for (JvmModuleProtoBuf.PackageParts proto : moduleProto.getMetadataPartsList()) {
                Object object;
                void $this$getOrPut$iv;
                packageParts = result2;
                String key$iv = proto.getPackageFqName();
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    String string4 = proto.getPackageFqName();
                    Intrinsics.checkNotNullExpressionValue(string4, "getPackageFqName(...)");
                    answer$iv = new PackageParts(string4);
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                PackageParts packageParts2 = (PackageParts)object;
                ProtocolStringList protocolStringList = proto.getShortClassNameList();
                Intrinsics.checkNotNullExpressionValue(protocolStringList, "getShortClassNameList(...)");
                Iterable $this$forEach$iv = protocolStringList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p02 = (String)element$iv;
                    boolean bl4 = false;
                    packageParts2.addMetadataPart(p02);
                }
            }
            ProtoBuf.StringTable stringTable = moduleProto.getStringTable();
            Intrinsics.checkNotNullExpressionValue(stringTable, "getStringTable(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = moduleProto.getQualifiedNameTable();
            Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "getQualifiedNameTable(...)");
            NameResolverImpl nameResolver = new NameResolverImpl(stringTable, qualifiedNameTable);
            List<ProtoBuf.Annotation> list = moduleProto.getAnnotationList();
            Intrinsics.checkNotNullExpressionValue(list, "getAnnotationList(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable $i$f$forEach = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void proto;
                jvmPackageName = (ProtoBuf.Annotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                collection.add(nameResolver.getQualifiedClassName(proto.getId()));
            }
            List annotations2 = (List)destination$iv$iv;
            Map map2 = result2;
            List<ProtoBuf.Class> list4 = moduleProto.getOptionalAnnotationClassList();
            Intrinsics.checkNotNullExpressionValue(list4, "getOptionalAnnotationClassList(...)");
            return new ModuleMapping(version, map2, new BinaryModuleData(annotations2, list4, nameResolver), debugName, null);
        }

        public static /* synthetic */ ModuleMapping loadModuleMapping$default(Companion companion, byte[] byArray, String string2, boolean bl, boolean bl2, MetadataVersion metadataVersion, Function1 function1, int n, Object object) {
            if ((n & 0x10) != 0) {
                metadataVersion = MetadataVersion.INSTANCE;
            }
            return companion.loadModuleMapping(byArray, string2, bl, bl2, metadataVersion, function1);
        }

        private final String loadMultiFileFacadeInternalName(List<Integer> multifileFacadeIds, List<String> multifileFacadeShortNames, int index2, String packageFqName) {
            String string2;
            String facadeShortName;
            String string3;
            Integer multifileFacadeId;
            Integer n = CollectionsKt.getOrNull(multifileFacadeIds, index2);
            Integer n2 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
            if (n2 != null) {
                int p0 = ((Number)n2).intValue();
                boolean bl = false;
                string3 = CollectionsKt.getOrNull(multifileFacadeShortNames, p0);
            } else {
                string3 = null;
            }
            String string4 = facadeShortName = string3;
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                string2 = ModuleMappingKt.access$internalNameOf(packageFqName, it);
            } else {
                string2 = null;
            }
            return string2;
        }

        private final BinaryModuleData emptyBinaryData() {
            List<String> list = CollectionsKt.emptyList();
            List<ProtoBuf.Class> list2 = CollectionsKt.emptyList();
            ProtoBuf.StringTable stringTable = ProtoBuf.StringTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue(stringTable, "getDefaultInstance(...)");
            ProtoBuf.QualifiedNameTable qualifiedNameTable = ProtoBuf.QualifiedNameTable.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue(qualifiedNameTable, "getDefaultInstance(...)");
            return new BinaryModuleData(list, list2, new NameResolverImpl(stringTable, qualifiedNameTable));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ BinaryModuleData access$emptyBinaryData(Companion $this) {
            return $this.emptyBinaryData();
        }
    }
}

