/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.metadata.jvm.serialization;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolverBase;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmNameResolverKt;
import org.jetbrains.kotlin.metadata.serialization.StringTable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\r\u001a\u00020\f*\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\nJ\u0015\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cR*\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u001dj\b\u0012\u0004\u0012\u00020\u0006`\u001e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R$\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u001dj\b\u0012\u0004\u0012\u00020\u000b`\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010 R0\u0010&\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0$j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b`%8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R$\u0010*\u001a\u0012\u0012\u0004\u0012\u00020\b0(j\b\u0012\u0004\u0012\u00020\b`)8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+"}, d2={"Lorg/jetbrains/kotlin/metadata/jvm/serialization/JvmStringTable;", "Lorg/jetbrains/kotlin/metadata/serialization/StringTable;", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;", "nameResolver", "<init>", "(Lorg/jetbrains/kotlin/metadata/jvm/deserialization/JvmNameResolver;)V", "", "string", "", "getStringIndex", "(Ljava/lang/String;)I", "Lorg/jetbrains/kotlin/metadata/jvm/JvmProtoBuf$StringTableTypes$Record$Builder;", "", "isTrivial", "(Lorg/jetbrains/kotlin/metadata/jvm/JvmProtoBuf$StringTableTypes$Record$Builder;)Z", "className", "isLocal", "getQualifiedClassNameIndex", "(Ljava/lang/String;Z)I", "fqName", "getPackageFqNameIndexByString", "Ljava/io/OutputStream;", "output", "", "serializeTo", "(Ljava/io/OutputStream;)V", "Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "toNameResolver", "()Lorg/jetbrains/kotlin/metadata/deserialization/NameResolver;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "strings", "Ljava/util/ArrayList;", "getStrings", "()Ljava/util/ArrayList;", "records", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "map", "Ljava/util/HashMap;", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "localNames", "Ljava/util/LinkedHashSet;"})
public class JvmStringTable
implements StringTable {
    @NotNull
    private final ArrayList<String> strings;
    @NotNull
    private final ArrayList<JvmProtoBuf.StringTableTypes.Record.Builder> records;
    @NotNull
    private final HashMap<String, Integer> map;
    @NotNull
    private final LinkedHashSet<Integer> localNames;

    /*
     * WARNING - void declaration
     */
    public JvmStringTable(@Nullable JvmNameResolver nameResolver) {
        this.strings = new ArrayList();
        this.records = new ArrayList();
        this.map = new HashMap();
        this.localNames = new LinkedHashSet();
        if (nameResolver != null) {
            void $this$mapTo$iv;
            CollectionsKt.addAll((Collection)this.strings, nameResolver.getStrings());
            List<JvmProtoBuf.StringTableTypes.Record> list = nameResolver.getTypes().getRecordList();
            Intrinsics.checkNotNullExpressionValue(list, "getRecordList(...)");
            Iterable iterable = list;
            Collection destination$iv = this.records;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                JvmProtoBuf.StringTableTypes.Record record = (JvmProtoBuf.StringTableTypes.Record)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(p0.toBuilder());
            }
            int n = ((Collection)this.strings).size();
            for (int index2 = 0; index2 < n; ++index2) {
                Integer n2 = index2;
                ((Map)this.map).put(nameResolver.getString(index2), n2);
            }
            this.localNames.addAll((Collection<Integer>)nameResolver.getTypes().getLocalNameList());
        }
    }

    public /* synthetic */ JvmStringTable(JvmNameResolver jvmNameResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            jvmNameResolver = null;
        }
        this(jvmNameResolver);
    }

    @NotNull
    public final ArrayList<String> getStrings() {
        return this.strings;
    }

    @Override
    public int getStringIndex(@NotNull String string2) {
        Object object;
        Intrinsics.checkNotNullParameter(string2, "string");
        Map $this$getOrPut$iv = this.map;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(string2);
        if (value$iv == null) {
            int n;
            boolean bl = false;
            int $this$getStringIndex_u24lambda_u241_u24lambda_u240 = n = this.strings.size();
            boolean bl2 = false;
            this.strings.add(string2);
            JvmProtoBuf.StringTableTypes.Record.Builder lastRecord = (JvmProtoBuf.StringTableTypes.Record.Builder)CollectionsKt.lastOrNull((List)this.records);
            if (lastRecord != null && this.isTrivial(lastRecord)) {
                lastRecord.setRange(lastRecord.getRange() + 1);
            } else {
                this.records.add(JvmProtoBuf.StringTableTypes.Record.newBuilder());
            }
            Integer answer$iv = n;
            $this$getOrPut$iv.put(string2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).intValue();
    }

    private final boolean isTrivial(JvmProtoBuf.StringTableTypes.Record.Builder $this$isTrivial) {
        return !$this$isTrivial.hasPredefinedIndex() && !$this$isTrivial.hasOperation() && $this$isTrivial.getSubstringIndexCount() == 0 && $this$isTrivial.getReplaceCharCount() == 0;
    }

    @Override
    public int getQualifiedClassNameIndex(@NotNull String className, boolean isLocal) {
        boolean bl;
        Intrinsics.checkNotNullParameter(className, "className");
        Integer n = this.map.get(className);
        if (n != null) {
            int recordedIndex = ((Number)n).intValue();
            boolean bl2 = false;
            if (isLocal == this.localNames.contains(recordedIndex)) {
                return recordedIndex;
            }
        }
        int index2 = this.strings.size();
        if (isLocal) {
            this.localNames.add(index2);
        }
        JvmProtoBuf.StringTableTypes.Record.Builder record = JvmProtoBuf.StringTableTypes.Record.newBuilder();
        if (isLocal || StringsKt.contains$default((CharSequence)className, '$', false, 2, null)) {
            bl = this.strings.add(className);
        } else {
            Integer predefinedIndex = JvmNameResolverBase.Companion.getPredefinedStringIndex(className);
            if (predefinedIndex != null) {
                record.setPredefinedIndex(predefinedIndex);
                bl = this.strings.add("");
            } else {
                record.setOperation(JvmProtoBuf.StringTableTypes.Record.Operation.DESC_TO_CLASS_ID);
                bl = this.strings.add('L' + StringsKt.replace$default(className, '.', '$', false, 4, null) + ';');
            }
        }
        this.records.add(record);
        Integer n2 = index2;
        ((Map)this.map).put(className, n2);
        return index2;
    }

    @Override
    public int getPackageFqNameIndexByString(@NotNull String fqName2) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        throw new IllegalStateException(("JvmStringTable does not contain package FQ names (requested FQ name: " + fqName2 + ')').toString());
    }

    /*
     * WARNING - void declaration
     */
    public final void serializeTo(@NotNull OutputStream output) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(output, "output");
        JvmProtoBuf.StringTableTypes.Builder $this$serializeTo_u24lambda_u244 = JvmProtoBuf.StringTableTypes.newBuilder();
        boolean bl = false;
        Iterable iterable = this.records;
        JvmProtoBuf.StringTableTypes.Builder builder2 = $this$serializeTo_u24lambda_u244;
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmProtoBuf.StringTableTypes.Record.Builder builder3 = (JvmProtoBuf.StringTableTypes.Record.Builder)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.build());
        }
        builder2.addAllRecord((List)destination$iv$iv);
        $this$serializeTo_u24lambda_u244.addAllLocalName((Iterable<? extends Integer>)this.localNames);
        $this$serializeTo_u24lambda_u244.build().writeDelimitedTo(output);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final NameResolver toNameResolver() {
        Collection<JvmProtoBuf.StringTableTypes.Record> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$toTypedArray$iv = this.strings;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        $this$toTypedArray$iv = this.records;
        Set set = this.localNames;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        boolean $i$f$map = false;
        thisCollection$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JvmProtoBuf.StringTableTypes.Record.Builder builder2 = (JvmProtoBuf.StringTableTypes.Record.Builder)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.build());
        }
        collection = (List)destination$iv$iv;
        List<JvmProtoBuf.StringTableTypes.Record> list = JvmNameResolverKt.toExpandedRecordsList((List<JvmProtoBuf.StringTableTypes.Record>)collection);
        Set set2 = set;
        String[] stringArray2 = stringArray;
        return new JvmNameResolverBase(stringArray2, set2, list);
    }

    public JvmStringTable() {
        this(null, 1, null);
    }
}

