/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeType;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementType;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocLink;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinParser;
import org.jetbrains.kotlin.psi.KtCommonFile;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.stubs.elements.KtFileElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\r\u001a\u00020\fH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0019H\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0014H\u0017\u00a2\u0006\u0004\b!\u0010\""}, d2={"Lorg/jetbrains/kotlin/parsing/KotlinCommonParserDefinition;", "Lcom/intellij/lang/ParserDefinition;", "<init>", "()V", "Lcom/intellij/openapi/project/Project;", "project", "Lcom/intellij/lexer/Lexer;", "createLexer", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/lexer/Lexer;", "Lcom/intellij/lang/PsiParser;", "createParser", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/lang/PsiParser;", "Lcom/intellij/psi/tree/IFileElementType;", "getFileNodeType", "()Lcom/intellij/psi/tree/IFileElementType;", "Lcom/intellij/psi/tree/TokenSet;", "getWhitespaceTokens", "()Lcom/intellij/psi/tree/TokenSet;", "getCommentTokens", "getStringLiteralElements", "Lcom/intellij/lang/ASTNode;", "astNode", "Lcom/intellij/psi/PsiElement;", "createElement", "(Lcom/intellij/lang/ASTNode;)Lcom/intellij/psi/PsiElement;", "Lcom/intellij/psi/FileViewProvider;", "fileViewProvider", "Lcom/intellij/psi/PsiFile;", "createFile", "(Lcom/intellij/psi/FileViewProvider;)Lcom/intellij/psi/PsiFile;", "left", "right", "Lcom/intellij/lang/ParserDefinition$SpaceRequirements;", "spaceExistanceTypeBetweenTokens", "(Lcom/intellij/lang/ASTNode;Lcom/intellij/lang/ASTNode;)Lcom/intellij/lang/ParserDefinition$SpaceRequirements;"})
public class KotlinCommonParserDefinition
implements ParserDefinition {
    @Override
    @NotNull
    public Lexer createLexer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        return new KotlinLexer();
    }

    @Override
    @NotNull
    public PsiParser createParser(@NotNull Project project) {
        Intrinsics.checkNotNullParameter(project, "project");
        return new KotlinParser(project);
    }

    @Override
    @NotNull
    public IFileElementType getFileNodeType() {
        KtFileElementType ktFileElementType = KtFileElementType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue(ktFileElementType, "INSTANCE");
        return ktFileElementType;
    }

    @Override
    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = KtTokens.WHITESPACES;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "WHITESPACES");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = KtTokens.COMMENTS;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "COMMENTS");
        return tokenSet;
    }

    @Override
    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = KtTokens.STRINGS;
        Intrinsics.checkNotNullExpressionValue(tokenSet, "STRINGS");
        return tokenSet;
    }

    @Override
    @NotNull
    public PsiElement createElement(@NotNull ASTNode astNode) {
        PsiElement psiElement;
        IElementType elementType;
        Intrinsics.checkNotNullParameter(astNode, "astNode");
        IElementType iElementType = astNode.getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
        IElementType iElementType2 = elementType = iElementType;
        if (iElementType2 instanceof KtStubElementType) {
            Object PsiT = ((KtStubElementType)elementType).createPsiFromAst(astNode);
            Intrinsics.checkNotNullExpressionValue(PsiT, "createPsiFromAst(...)");
            psiElement = (PsiElement)PsiT;
        } else if (Intrinsics.areEqual(iElementType2, KtNodeTypes.TYPE_CODE_FRAGMENT) || Intrinsics.areEqual(iElementType2, KtNodeTypes.EXPRESSION_CODE_FRAGMENT) || Intrinsics.areEqual(iElementType2, KtNodeTypes.BLOCK_CODE_FRAGMENT)) {
            psiElement = new ASTWrapperPsiElement(astNode);
        } else if (iElementType2 instanceof KDocElementType) {
            PsiElement psiElement2 = ((KDocElementType)elementType).createPsi(astNode);
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue(psiElement2, "createPsi(...)");
        } else if (Intrinsics.areEqual(iElementType2, KDocTokens.MARKDOWN_LINK)) {
            psiElement = new KDocLink(astNode);
        } else {
            KtElement ktElement = ((KtNodeType)elementType).createPsi(astNode);
            Intrinsics.checkNotNullExpressionValue(ktElement, "createPsi(...)");
            psiElement = ktElement;
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider fileViewProvider) {
        Intrinsics.checkNotNullParameter(fileViewProvider, "fileViewProvider");
        return new KtCommonFile(fileViewProvider, false);
    }

    @Override
    @Deprecated(message="Deprecated in Java")
    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(@NotNull ASTNode left, @NotNull ASTNode right) {
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        IElementType iElementType = right.getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
        IElementType rightTokenType = iElementType;
        if (Intrinsics.areEqual(rightTokenType, KtTokens.GET_KEYWORD) || Intrinsics.areEqual(rightTokenType, KtTokens.SET_KEYWORD)) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        IElementType iElementType2 = left.getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType2, "getElementType(...)");
        IElementType leftTokenType = iElementType2;
        if (leftTokenType instanceof KtKeywordToken && rightTokenType instanceof KtKeywordToken) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        PsiElement psiElement = right.getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        PsiElement $this$getNonStrictParentOfType$iv = psiElement;
        boolean $i$f$getNonStrictParentOfType = false;
        KtWhenEntry rightWhenEntry = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtWhenEntry.class, false);
        if (rightWhenEntry != null) {
            PsiElement psiElement2 = left.getPsi();
            Intrinsics.checkNotNullExpressionValue(psiElement2, "getPsi(...)");
            PsiElement $this$getNonStrictParentOfType$iv2 = psiElement2;
            boolean $i$f$getNonStrictParentOfType2 = false;
            KtWhenEntry leftWhenEntry = PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv2, KtWhenEntry.class, false);
            if (leftWhenEntry != null && !Intrinsics.areEqual(leftWhenEntry, rightWhenEntry) && !Intrinsics.areEqual(leftTokenType, KtTokens.SEMICOLON)) {
                return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
            }
        }
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

