/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parsing;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.LiteralFormatUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.utils.NumberWithRadix;
import org.jetbrains.kotlin.utils.NumbersKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000<\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0015\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\b\u001a\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\b\u001a!\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u001a\u0019\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u0019\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0015\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\b\"\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d"}, d2={"", "text", "Lcom/intellij/psi/tree/IElementType;", "elementType", "", "hasIllegalUnderscore", "(Ljava/lang/String;Lcom/intellij/psi/tree/IElementType;)Z", "hasLongSuffix", "(Ljava/lang/String;)Z", "hasUnsignedSuffix", "hasUnsignedLongSuffix", "type", "", "parseNumericLiteral", "(Ljava/lang/String;Lcom/intellij/psi/tree/IElementType;)Ljava/lang/Number;", "", "parseLong", "(Ljava/lang/String;)Ljava/lang/Long;", "parseFloatingLiteral", "(Ljava/lang/String;)Ljava/lang/Number;", "", "parseDouble", "(Ljava/lang/String;)Ljava/lang/Double;", "", "parseFloat", "(Ljava/lang/String;)Ljava/lang/Float;", "parseBoolean", "Lkotlin/text/Regex;", "FP_LITERAL_PARTS", "Lkotlin/text/Regex;"})
public final class ParseUtilsKt {
    @NotNull
    private static final Regex FP_LITERAL_PARTS = new Regex("([_\\d]*)\\.?([_\\d]*)e?[+-]?([_\\d]*)[f]?");

    public static final boolean hasIllegalUnderscore(@NotNull String text, @NotNull IElementType elementType) {
        boolean bl;
        block7: {
            List<Object> list;
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(elementType, "elementType");
            if (elementType == KtNodeTypes.INTEGER_CONSTANT) {
                int start = 0;
                int end = text.length();
                if (StringsKt.startsWith(text, "0x", true) || StringsKt.startsWith(text, "0b", true)) {
                    start += 2;
                }
                if (StringsKt.endsWith((CharSequence)text, 'l', true)) {
                    --end;
                }
                String string2 = text.substring(start, end);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                list = CollectionsKt.listOf(string2);
            } else {
                list = SequencesKt.toList(SequencesKt.flatMapIterable(Regex.findAll$default(FP_LITERAL_PARTS, text, 0, 2, null), ParseUtilsKt::hasIllegalUnderscore$lambda$0));
            }
            List parts = list;
            Iterable $this$any$iv = parts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(it != null && (StringsKt.startsWith$default(it, "_", false, 2, null) || StringsKt.endsWith$default(it, "_", false, 2, null)))) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasLongSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return StringsKt.endsWith$default((CharSequence)text, 'l', false, 2, null) || StringsKt.endsWith$default((CharSequence)text, 'L', false, 2, null);
    }

    public static final boolean hasUnsignedSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return StringsKt.endsWith$default((CharSequence)text, 'u', false, 2, null) || StringsKt.endsWith$default((CharSequence)text, 'U', false, 2, null);
    }

    public static final boolean hasUnsignedLongSuffix(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return StringsKt.endsWith$default(text, "ul", false, 2, null) || StringsKt.endsWith$default(text, "uL", false, 2, null) || StringsKt.endsWith$default(text, "Ul", false, 2, null) || StringsKt.endsWith$default(text, "UL", false, 2, null);
    }

    @Nullable
    public static final Number parseNumericLiteral(@NotNull String text, @NotNull IElementType type2) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(type2, "type");
        String string2 = LiteralFormatUtil.removeUnderscores(text);
        Intrinsics.checkNotNullExpressionValue(string2, "removeUnderscores(...)");
        String canonicalText = string2;
        IElementType iElementType = type2;
        return Intrinsics.areEqual(iElementType, KtNodeTypes.INTEGER_CONSTANT) ? (Number)ParseUtilsKt.parseLong(canonicalText) : (Number)(Intrinsics.areEqual(iElementType, KtNodeTypes.FLOAT_CONSTANT) ? ParseUtilsKt.parseFloatingLiteral(canonicalText) : null);
    }

    private static final Long parseLong(String text) {
        Long l;
        try {
            boolean isUnsigned = false;
            String numberWithoutSuffix = null;
            if (ParseUtilsKt.hasUnsignedLongSuffix(text)) {
                isUnsigned = true;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text, 2);
            } else if (ParseUtilsKt.hasUnsignedSuffix(text)) {
                isUnsigned = true;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text, 1);
            } else if (ParseUtilsKt.hasLongSuffix(text)) {
                isUnsigned = false;
                numberWithoutSuffix = ParseUtilsKt.parseLong$removeSuffix(text, 1);
            } else {
                isUnsigned = false;
                numberWithoutSuffix = text;
            }
            NumberWithRadix numberWithRadix = NumbersKt.extractRadix(numberWithoutSuffix);
            String number = numberWithRadix.component1();
            int radix = numberWithRadix.component2();
            l = isUnsigned ? Long.parseUnsignedLong(number, radix) : Long.parseLong(number, radix);
        }
        catch (NumberFormatException e) {
            l = null;
        }
        return l;
    }

    private static final Number parseFloatingLiteral(String text) {
        if (StringsKt.endsWith$default((CharSequence)text, 'f', false, 2, null) || StringsKt.endsWith$default((CharSequence)text, 'F', false, 2, null)) {
            return ParseUtilsKt.parseFloat(text);
        }
        return ParseUtilsKt.parseDouble(text);
    }

    private static final Double parseDouble(String text) {
        Double d;
        try {
            d = Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        return d;
    }

    private static final Float parseFloat(String text) {
        Float f;
        try {
            f = Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            f = null;
        }
        return f;
    }

    public static final boolean parseBoolean(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        if (Intrinsics.areEqual("true", text)) {
            return true;
        }
        if (Intrinsics.areEqual("false", text)) {
            return false;
        }
        throw new IllegalStateException("Must not happen. A boolean literal has text: " + text);
    }

    private static final Iterable hasIllegalUnderscore$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getGroupValues();
    }

    private static final String parseLong$removeSuffix(String $this$parseLong_u24removeSuffix, int i) {
        String string2 = $this$parseLong_u24removeSuffix.substring(0, $this$parseLong_u24removeSuffix.length() - i);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return string2;
    }
}

