/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.platform;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\r\u001a\u00020\u00028'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\u000f\u001a\u00020\u000e8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/platform/SimplePlatform;", "", "", "platformName", "<init>", "(Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getPlatformName", "getTargetName", "targetName", "getOldFashionedDescription", "oldFashionedDescription", "Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "targetPlatformVersion", "Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "getTargetPlatformVersion", "()Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;"})
public abstract class SimplePlatform {
    @NotNull
    private final String platformName;
    @NotNull
    private final TargetPlatformVersion targetPlatformVersion;

    public SimplePlatform(@NotNull String platformName) {
        Intrinsics.checkNotNullParameter(platformName, "platformName");
        this.platformName = platformName;
        this.targetPlatformVersion = TargetPlatformVersion.NoVersion.INSTANCE;
    }

    @NotNull
    public final String getPlatformName() {
        return this.platformName;
    }

    @NotNull
    public String toString() {
        String targetName = this.getTargetName();
        return ((CharSequence)targetName).length() > 0 ? this.platformName + " (" + targetName + ')' : this.platformName;
    }

    @NotNull
    public String getTargetName() {
        return this.getTargetPlatformVersion().getDescription();
    }

    @NotNull
    public abstract String getOldFashionedDescription();

    @NotNull
    public TargetPlatformVersion getTargetPlatformVersion() {
        return this.targetPlatformVersion;
    }
}

