/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\n\u0010\n\u001a\u00060\bj\u0002`\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/psi/KotlinStringLiteralTextEscaper;", "Lcom/intellij/psi/LiteralTextEscaper;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "host", "<init>", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)V", "Lcom/intellij/openapi/util/TextRange;", "rangeInsideHost", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "outChars", "", "decode", "(Lcom/intellij/openapi/util/TextRange;Ljava/lang/StringBuilder;)Z", "", "offsetInDecoded", "getOffsetInHost", "(ILcom/intellij/openapi/util/TextRange;)I", "getRelevantTextRange", "()Lcom/intellij/openapi/util/TextRange;", "isOneLine", "()Z", "", "sourceOffsets", "[I"})
public final class KotlinStringLiteralTextEscaper
extends LiteralTextEscaper<KtStringTemplateExpression> {
    @Nullable
    private int[] sourceOffsets;

    public KotlinStringLiteralTextEscaper(@NotNull KtStringTemplateExpression host) {
        Intrinsics.checkNotNullParameter(host, "host");
        super((PsiLanguageInjectionHost)host);
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        Intrinsics.checkNotNullParameter(rangeInsideHost, "rangeInsideHost");
        Intrinsics.checkNotNullParameter(outChars, "outChars");
        IntArrayList sourceOffsetsList = new IntArrayList();
        int sourceOffset = 0;
        for (KtStringTemplateEntry child : ((KtStringTemplateExpression)this.myHost).getEntries()) {
            TextRange textRange;
            int it;
            int n;
            int n2;
            TextRange childRange;
            Intrinsics.checkNotNullExpressionValue(TextRange.from(child.getStartOffsetInParent(), child.getTextLength()), "from(...)");
            if (rangeInsideHost.getEndOffset() <= childRange.getStartOffset()) break;
            if (childRange.getEndOffset() <= rangeInsideHost.getStartOffset()) continue;
            if (child instanceof KtEscapeStringTemplateEntry) {
                if (!rangeInsideHost.contains(childRange)) {
                    sourceOffsetsList.add(sourceOffset);
                    this.sourceOffsets = sourceOffsetsList.toIntArray();
                    return false;
                }
                String unescaped = ((KtEscapeStringTemplateEntry)child).getUnescapedValue();
                outChars.append(unescaped);
                n2 = unescaped.length();
                n = 0;
                while (n < n2) {
                    it = n++;
                    boolean bl = false;
                    sourceOffsetsList.add(sourceOffset);
                }
                sourceOffset += ((KtEscapeStringTemplateEntry)child).getTextLength();
                continue;
            }
            TextRange textRange2 = rangeInsideHost.intersection(childRange);
            Intrinsics.checkNotNull(textRange2);
            Intrinsics.checkNotNullExpressionValue(textRange2.shiftRight(-childRange.getStartOffset()), "shiftRight(...)");
            outChars.append(child.getText(), textRange.getStartOffset(), textRange.getEndOffset());
            n2 = textRange.getLength();
            n = 0;
            while (n < n2) {
                it = n++;
                boolean bl = false;
                int n3 = sourceOffset;
                sourceOffset = n3 + 1;
                sourceOffsetsList.add(n3);
            }
        }
        sourceOffsetsList.add(sourceOffset);
        this.sourceOffsets = sourceOffsetsList.toIntArray();
        return true;
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        Intrinsics.checkNotNullParameter(rangeInsideHost, "rangeInsideHost");
        int[] offsets = this.sourceOffsets;
        if (offsets == null || offsetInDecoded >= offsets.length) {
            return -1;
        }
        return Math.min(offsets[offsetInDecoded], rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
    }

    @Override
    @NotNull
    public TextRange getRelevantTextRange() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue(psiLanguageInjectionHost, "myHost");
        return KtPsiUtilKt.getContentRange((KtStringTemplateExpression)psiLanguageInjectionHost);
    }

    @Override
    public boolean isOneLine() {
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.myHost;
        Intrinsics.checkNotNullExpressionValue(psiLanguageInjectionHost, "myHost");
        return KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)psiLanguageInjectionHost);
    }
}

