/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinClassStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtClassElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\u0010\n\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u0004\u0010\u000bJ7\u0010\u0011\u001a\u00028\u0000\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000e2\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u0019J\r\u0010\u001b\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u0019J\r\u0010\u001c\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001c\u0010\u0019J\r\u0010\u001d\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001d\u0010\u0019J\r\u0010\u001e\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001e\u0010\u0019J\u0015\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u0013H\u0017\u00a2\u0006\u0004\b \u0010\u0016J\u0011\u0010\"\u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0011\u0010$\u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0004\b$\u0010#J\u0011\u0010%\u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0004\b%\u0010#R\u0019\u0010(\u001a\u00070&\u00a2\u0006\u0002\b'8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010,\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+"}, d2={"Lorg/jetbrains/kotlin/psi/KtClass;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/lang/ASTNode;", "node", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "stub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;)V", "Lcom/intellij/psi/stubs/IStubElementType;", "nodeType", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;Lcom/intellij/psi/stubs/IStubElementType;)V", "R", "D", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "getProperties", "()Ljava/util/List;", "", "isInterface", "()Z", "isEnum", "isSealed", "isInner", "isInline", "isValue", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "getCompanionObjects", "Lcom/intellij/psi/PsiElement;", "getClassOrInterfaceKeyword", "()Lcom/intellij/psi/PsiElement;", "getClassKeyword", "getFunKeyword", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "classInterfaceTokenSet", "Lcom/intellij/psi/tree/TokenSet;", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinClassStub;", "_stub"})
public class KtClass
extends KtClassOrObject {
    @NotNull
    private final TokenSet classInterfaceTokenSet;

    public KtClass(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    public KtClass(@NotNull KotlinClassStub stub2) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub2;
        KtClassElementType ktClassElementType = KtStubElementTypes.CLASS;
        Intrinsics.checkNotNullExpressionValue(ktClassElementType, "CLASS");
        super(kotlinClassOrObjectStub, (IStubElementType)ktClassElementType);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    public KtClass(@NotNull KotlinClassStub stub2, @NotNull IStubElementType<?, ?> nodeType) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        Intrinsics.checkNotNullParameter(nodeType, "nodeType");
        super(stub2, nodeType);
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.CLASS_KEYWORD, KtTokens.INTERFACE_KEYWORD};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue(tokenSet, "create(...)");
        this.classInterfaceTokenSet = tokenSet;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitClass(this, data2);
    }

    private final KotlinClassStub get_stub() {
        Object t = this.getGreenStub();
        return t instanceof KotlinClassStub ? (KotlinClassStub)t : null;
    }

    @NotNull
    public final List<KtProperty> getProperties() {
        KtClassBody ktClassBody = this.getBody();
        List<KtProperty> list = ktClassBody != null ? ktClassBody.getProperties() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean isInterface() {
        KotlinClassStub kotlinClassStub = this.get_stub();
        return kotlinClassStub != null ? kotlinClassStub.isInterface() : this.findChildByType(KtTokens.INTERFACE_KEYWORD) != null;
    }

    public final boolean isEnum() {
        return this.hasModifier(KtTokens.ENUM_KEYWORD);
    }

    public final boolean isSealed() {
        return this.hasModifier(KtTokens.SEALED_KEYWORD);
    }

    public final boolean isInner() {
        return this.hasModifier(KtTokens.INNER_KEYWORD);
    }

    public final boolean isInline() {
        return this.hasModifier(KtTokens.INLINE_KEYWORD);
    }

    public final boolean isValue() {
        return this.hasModifier(KtTokens.VALUE_KEYWORD);
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        KtClassBody ktClassBody = this.getBody();
        List<KtObjectDeclaration> list = ktClassBody != null ? ktClassBody.getAllCompanionObjects() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final PsiElement getClassOrInterfaceKeyword() {
        return this.findChildByType(this.classInterfaceTokenSet);
    }

    @Nullable
    public final PsiElement getClassKeyword() {
        return this.findChildByType(KtTokens.CLASS_KEYWORD);
    }

    @Nullable
    public final PsiElement getFunKeyword() {
        KtModifierList ktModifierList = this.getModifierList();
        return ktModifierList != null ? ktModifierList.getModifier(KtTokens.FUN_KEYWORD) : null;
    }
}

