/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0011\u0010\u0003\u001a\u0004\u0018\u00010\u0002H'\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0001H&\u00a2\u0006\u0004\b\u0007\u0010\bJ7\u0010\u000e\u001a\u00028\u0000\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b2\u0006\u0010\r\u001a\u00028\u0001H&\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0004R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0004R\u0014\u0010\u001b\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/psi/KtDoubleColonExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/psi/PsiElement;", "findColonColon", "()Lcom/intellij/psi/PsiElement;", "newReceiverExpression", "", "setReceiverExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "R", "D", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "getReceiverExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "receiverExpression", "", "getHasQuestionMarks", "()Z", "hasQuestionMarks", "getDoubleColonTokenReference", "doubleColonTokenReference", "getLhs", "lhs", "isEmptyLHS"})
public interface KtDoubleColonExpression
extends KtExpression {
    @Nullable
    default public KtExpression getReceiverExpression() {
        PsiElement psiElement = this.getNode().getFirstChildNode().getPsi();
        return psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
    }

    default public boolean getHasQuestionMarks() {
        Iterator<ASTNode> iterator2 = SequencesKt.generateSequence(this.getNode().getFirstChildNode(), (Function1)hasQuestionMarks.1.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            ASTNode element = iterator2.next();
            IElementType iElementType = element.getElementType();
            if (Intrinsics.areEqual(iElementType, KtTokens.QUEST)) {
                return true;
            }
            if (!Intrinsics.areEqual(iElementType, KtTokens.COLONCOLON)) continue;
            return false;
        }
        throw new IllegalStateException(("Double colon expression must have '::': " + this.getText()).toString());
    }

    @Nullable
    public PsiElement findColonColon();

    @NotNull
    default public PsiElement getDoubleColonTokenReference() {
        PsiElement psiElement = this.findColonColon();
        Intrinsics.checkNotNull(psiElement);
        return psiElement;
    }

    @Nullable
    default public PsiElement getLhs() {
        return this.getDoubleColonTokenReference().getPrevSibling();
    }

    default public void setReceiverExpression(@NotNull KtExpression newReceiverExpression) {
        Intrinsics.checkNotNullParameter(newReceiverExpression, "newReceiverExpression");
        KtExpression oldReceiverExpression = this.getReceiverExpression();
        PsiElement psiElement = oldReceiverExpression;
        if (psiElement == null || (psiElement = psiElement.replace(newReceiverExpression)) == null) {
            psiElement = this.addBefore(newReceiverExpression, this.getDoubleColonTokenReference());
        }
    }

    default public boolean isEmptyLHS() {
        return this.getLhs() == null;
    }

    @Override
    default public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitDoubleColonExpression(this, data2);
    }
}

