/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtObjectElementType;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0011\u0010\n\u001a\u0004\u0018\u00010\tH\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\f\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J7\u0010\u001b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00182\u0006\u0010\u001a\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\r\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u0012J\u0011\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0011\u0010 \u001a\u0004\u0018\u00010\rH\u0017\u00a2\u0006\u0004\b \u0010\u001fJ\u0015\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00000!H\u0017\u00a2\u0006\u0004\b\"\u0010#R\u0016\u0010&\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%"}, d2={"Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/lang/ASTNode;", "node", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "stub", "(Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;)V", "", "getName", "()Ljava/lang/String;", "name", "Lcom/intellij/psi/PsiElement;", "setName", "(Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "", "isCompanion", "()Z", "", "getTextOffset", "()I", "R", "D", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/psi/KtVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "isObjectLiteral", "getObjectKeyword", "()Lcom/intellij/psi/PsiElement;", "getIdentifyingElement", "", "getCompanionObjects", "()Ljava/util/List;", "get_stub", "()Lorg/jetbrains/kotlin/psi/stubs/KotlinObjectStub;", "_stub"})
public final class KtObjectDeclaration
extends KtClassOrObject {
    public KtObjectDeclaration(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    public KtObjectDeclaration(@NotNull KotlinObjectStub stub2) {
        Intrinsics.checkNotNullParameter(stub2, "stub");
        KotlinClassOrObjectStub kotlinClassOrObjectStub = stub2;
        KtObjectElementType ktObjectElementType = KtStubElementTypes.OBJECT_DECLARATION;
        Intrinsics.checkNotNullExpressionValue(ktObjectElementType, "OBJECT_DECLARATION");
        super(kotlinClassOrObjectStub, (IStubElementType)ktObjectElementType);
    }

    private final KotlinObjectStub get_stub() {
        Object t = this.getGreenStub();
        return t instanceof KotlinObjectStub ? (KotlinObjectStub)t : null;
    }

    @Override
    @Nullable
    public String getName() {
        String string2 = super.getName();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        if (this.isCompanion() && !this.isTopLevel()) {
            return SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.toString();
        }
        return null;
    }

    @Override
    @NotNull
    public PsiElement setName(@NotNull String name) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter(name, "name");
        if (this.getNameIdentifier() == null) {
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue(project, "getProject(...)");
            KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
            PsiElement psiElement2 = psiFactory.createIdentifier(name);
            PsiElement psiElement3 = this.getObjectKeyword();
            Intrinsics.checkNotNull(psiElement3);
            PsiElement result2 = this.addAfter(psiElement2, psiElement3);
            PsiElement psiElement4 = psiFactory.createWhiteSpace();
            PsiElement psiElement5 = this.getObjectKeyword();
            Intrinsics.checkNotNull(psiElement5);
            this.addAfter(psiElement4, psiElement5);
            PsiElement psiElement6 = result2;
            Intrinsics.checkNotNull(psiElement6);
            psiElement = psiElement6;
        } else {
            PsiElement psiElement7 = super.setName(name);
            Intrinsics.checkNotNull(psiElement7);
            psiElement = psiElement7;
        }
        return psiElement;
    }

    public final boolean isCompanion() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isCompanion() : this.hasModifier(KtTokens.COMPANION_KEYWORD);
    }

    @Override
    public int getTextOffset() {
        int n;
        Object object = this.getNameIdentifier();
        if (object != null && (object = object.getTextRange()) != null) {
            n = ((TextRange)object).getStartOffset();
        } else {
            PsiElement psiElement = this.getObjectKeyword();
            Intrinsics.checkNotNull(psiElement);
            n = psiElement.getTextRange().getStartOffset();
        }
        return n;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitObjectDeclaration(this, data2);
    }

    public final boolean isObjectLiteral() {
        KotlinObjectStub kotlinObjectStub = this.get_stub();
        return kotlinObjectStub != null ? kotlinObjectStub.isObjectLiteral() : this.getParent() instanceof KtObjectLiteralExpression;
    }

    @Nullable
    public final PsiElement getObjectKeyword() {
        return this.findChildByType(KtTokens.OBJECT_KEYWORD);
    }

    @Override
    @Nullable
    public PsiElement getIdentifyingElement() {
        return this.getObjectKeyword();
    }

    @Override
    @NotNull
    public List<KtObjectDeclaration> getCompanionObjects() {
        return CollectionsKt.emptyList();
    }
}

