/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtSimpleNameExpressionImpl;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\b\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\r8G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpressionImpl;", "Lcom/intellij/lang/ASTNode;", "node", "<init>", "(Lcom/intellij/lang/ASTNode;)V", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/annotations/Nullable;", "getReferencedNameElement", "()Lcom/intellij/psi/PsiElement;", "", "isConventionOperator", "()Z", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "getOperationSignTokenType", "()Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "operationSignTokenType"})
public final class KtOperationReferenceExpression
extends KtSimpleNameExpressionImpl {
    public KtOperationReferenceExpression(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter(node, "node");
        super(node);
    }

    @Override
    @NotNull
    public PsiElement getReferencedNameElement() {
        Object object = this.findChildByType(KotlinExpressionParsing.ALL_OPERATIONS);
        if (object == null) {
            object = this;
        }
        return object;
    }

    @Nullable
    public final KtSingleValueToken getOperationSignTokenType() {
        PsiElement psiElement = this.getFirstChild();
        TreeElement treeElement = psiElement instanceof TreeElement ? (TreeElement)((Object)psiElement) : null;
        IElementType iElementType = treeElement != null ? treeElement.getElementType() : null;
        return iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
    }

    public final boolean isConventionOperator() {
        KtSingleValueToken ktSingleValueToken = this.getOperationSignTokenType();
        if (ktSingleValueToken == null) {
            return false;
        }
        KtSingleValueToken tokenType = ktSingleValueToken;
        return OperatorConventions.getNameForOperationSymbol(tokenType) != null;
    }
}

